/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import net.sf.sdedit.ui.components.ATabbedPaneListener;
import net.sf.sdedit.ui.components.Stainable;
import net.sf.sdedit.ui.components.StainedListener;
import net.sf.sdedit.util.base64.Base64;

public class ATabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -1422640863L;
    private static String cleanString = "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAOVSURBVHjaYtTUdGdAA4K/fv3U+Pv3rw+QLfT//3+Gf//+vWNiYtjCwsJyAyj2HiT2//8/sGKAAGJB1gkU9Pj581eNnJyctaamMgM/Py8DIyMDw+fPXxlu3rxfdfPmjaPMzIwtTEzMO2B6AAKIBaH5fw4LC1tHeHgQt7u7PYOOjhIDNzcb2IBfv/4x3LjxiGHr1n3WK1duXPPx45sKJiamKSB9AAHECPIC0GZ3ZmbWzQkJkazu7rYMLCyMDD9//gYZCzWcgYGVlRUozsxw9Oh5hv7+Gb8/fXrnC+TvBAggZhERZb7fv3/PdnCwV7C3twT69w+DlpYcw5s3HxkeP34FdP53IPsDg6qqNAMXFxvQIA4GoGXMFy9eVgK6eg1AADH9/ftbW0hIxEpFRQms0MBAlYGDg51BQ0OegZ2dneH58zdAMRUGKSlhBnFxQYY7dx4CvfSHQVBQyAqkFyCAmIWEFDOlpaVtgQHH8O7dB4aXLz8wqKjIMHBysoE1SUqKMCgoSIC90te3lGHNmu0MDx8+Yfjx4xvQmz9eAgQQCzAwhBiBIfX69RugwC+GR4+eAl3yliEx0Y+Bl5eDQU5ODBwG3d0LGdau3QH0AjMwLFiBruQEBjCTEEAAsYBC+du3HwxPnjxnAMY90JCfoLBlePXqLdAAabDNX778AHvl37+/QP9DYubfP0haAAggJlAi+fr1M8Pbt2+Bml4z8PBwMxQURDMoK0uDbf78+QfYJY2N2Qy2thZA//8CGsIMtOg70MI/7wACiAkYkluAfmH48+cPMOHwMbS1FTJoaspB/bwYqHE6w4cP3xn4+DgYWltzgAGqywCMNbABQBdsAQggJmAsX/3+/esxkPNAoX7jxgNQomKYMWMtw65dRxkuXLjGMHHiEobv338x3Lv3DEhDLAO6+hjQq1cBAohRWdkOqOGvOwcHz2Z1dU1WcXEJBgkJYYbbtx+AExIogH/9+s2gra0KDOgPwLTxmOHKlfO/v3z55AtM0jsBAggYjfKg0Lz769eP958/f7FnZ2djAyYUBhERQWBUcgLDhItBWFiY4f37j8AYeshw/frVr1++fCwFal4O8iZAAIENAKdpRoZTwLg99/Llc8VPnz7JffnyFWQwMAa+Mdy/fw+YmW4w3Lp1/eiPH19zgJqXwfIQQACBvQDNiaBsC/K/IDCQNICKfNjYWIVAYQNMH++AIb4FGPrg7IycgwECDADIUZC5UWvTuwAAAABJRU5ErkJggg==";
    private static String stainedString = "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH1wMbBRAgdDDcCwAAAyVJREFUOMtdk0tsVGUYhp/vP2eml9PLzLRAq4MUqKVyS2tIkBZKCCZl0bIgLly68xLcSECjBkx04cIlCy8bFgYXspKaiqZNjGkXalACaGPaUrHTmSntdJzpdOac8//nd6FtiO/++fK+yfPJlXQj/0vSGNNrTDQCpAAibEEhY0rJDLAGYK0FwH2ctNae0Vq/29a+bXBH127qm1oACKoV8g/m387lc1MK+UAp+WaTcR+DzzuO++Gzp4e9/Wdf4MnBU8SaWxDHwdSq5H+a5u6Xnw/e/nb8RrVafUuEqwByJd2ItXZYKXXzudFzsf3nXkS5MUzgbzWLjMGtq0eUYn5inMlrn4ZV3x91RG45J5vdliiKPnv6cF9Xz/NnsFFE59HjlB4uUJz/g2phhfVclm2H+om3JlBKIdWKk5mf3WPhhrLWHmj0vIHte3soZ5dInziN6zXRefQ4bn0DpaVF0seGaO3eR/OuPTz6/S4mDPEaGge05YAz1OS8mki1nUh0PsFGYYXSg1m2H+on1tRMa1c3rTt30XawD4CJCy9zZ/wrVrNLhGGIMTrvikhKRKisrqADn7XMX1RW8gy8+T7xRJJk70GsMUxcfIVfvhvHcVyUo4jFY1CrplwRwfdrrGUzRMagwxCA0sIc7X1HAAjLJf7OZbHWIiIoUVseKGttIfB9NkolysUi9Z7HqUvv0d53BGsMQXGNeCLJyNVr7D3cjzEaEUGHGm0pKGvtmA41URTR4HmMfvQxHceGAJi89Bpfv/4S1XyWulQ7Zz+5Trq7B601WodEMKaA+0HgTxtjcGMxlu/8jDWGHy6/wczU9yzO/Mbk5QuE5RKr934l9H2iKGIj1NPAfXmnIw4w7LruzY70zlhzWzstOzpYnpsF+K9uQOe+Z1hfeUQxnyPz50JY0dGoCLecoSYHYE5rs1bbqJx0HSeulMJLthFvaKCu0cNLpKiWihSWMuQyi5WKNhdF+AJg8wAi8mOg9e1ysbi7Vi49FVTWEcCvrFNYWiS/+JDs8vJUzUTnRbi+qfnmhH+djyxAMrC21xVGXKVSUWSpWVuwljERtt55M/8AP9V9H5Qdd08AAAAASUVORK5CYII=";
    private static Image clean = Base64.decodeBase64EncodedImage(cleanString);
    private static Image stain = Base64.decodeBase64EncodedImage(stainedString);
    private List<ATabbedPaneListener> listeners = new LinkedList<ATabbedPaneListener>();

    public ATabbedPane() {
        super(1);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ATabbedPane.this.getUI().tabForCoordinate(ATabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                if (n < 0) {
                    return;
                }
                Rectangle rectangle = ((ACloseTabIcon)ATabbedPane.this.getIconAt(n)).getBounds();
                if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    ATabbedPane.this.selectAndCloseTab(n);
                }
            }
        });
    }

    public String getCurrentTitle() {
        if (this.getSelectedIndex() == -1) {
            return "";
        }
        return this.getTitleAt(this.getSelectedIndex());
    }

    public void addListener(ATabbedPaneListener aTabbedPaneListener) {
        this.listeners.add(aTabbedPaneListener);
    }

    private String generateUniqueTabName(String string) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < this.getTabCount(); ++n) {
            hashSet.add(this.getTitleAt(n));
        }
        if (!hashSet.contains(string)) {
            return string;
        }
        n = 1;
        String string2;
        while (hashSet.contains(string2 = string + "-" + n)) {
            ++n;
        }
        return string2;
    }

    public void setTabTitle(String string) {
        int n = this.getSelectedIndex();
        this.setTitleAt(n, "");
        string = this.generateUniqueTabName(string);
        this.setTitleAt(n, string);
    }

    public String addTab(Component component, String string) {
        string = this.generateUniqueTabName(string);
        ACloseTabIcon aCloseTabIcon = new ACloseTabIcon(component, this);
        this.addTab(string, aCloseTabIcon, component);
        this.setSelectedIndex(this.getTabCount() - 1);
        return string;
    }

    public String addTab(Component component, String string, ImageIcon imageIcon) {
        string = this.generateUniqueTabName(string);
        ACloseTabIcon aCloseTabIcon = new ACloseTabIcon(component, this, imageIcon);
        this.addTab(string, aCloseTabIcon, component);
        this.setSelectedIndex(this.getTabCount() - 1);
        return string;
    }

    public boolean removeCurrentTab(boolean bl) {
        if (this.getTabCount() == 0) {
            return false;
        }
        if (bl && this.getTabCount() == 1) {
            return false;
        }
        int n = this.getSelectedIndex();
        if (n != -1) {
            this.remove(n);
            return true;
        }
        return false;
    }

    protected void fireCurrentTabClosing() {
        for (ATabbedPaneListener aTabbedPaneListener : this.listeners) {
            aTabbedPaneListener.currentTabClosing();
        }
    }

    private void selectAndCloseTab(int n) {
        this.setSelectedIndex(n);
        if (this.getTabCount() > 1) {
            this.fireCurrentTabClosing();
        }
    }

    private class ACloseTabIcon
    implements Icon,
    StainedListener {
        private int x_pos;
        private int y_pos;
        private Image image;

        public ACloseTabIcon(Component component, ATabbedPane aTabbedPane2, ImageIcon imageIcon) {
            this.image = imageIcon.getImage();
        }

        public ACloseTabIcon(Component component, ATabbedPane aTabbedPane2) {
            if (component instanceof Stainable) {
                ((Stainable)((Object)component)).addStainedListener(this);
            }
            this.image = clean;
        }

        public void stainedStatusChanged(boolean bl) {
            this.image = bl ? stain : clean;
            ATabbedPane.this.repaint();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawImage(this.image, n, n2, component);
            this.x_pos = n;
            this.y_pos = n2;
        }

        public int getIconWidth() {
            return this.image.getWidth(null);
        }

        public int getIconHeight() {
            return this.image.getHeight(null);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.getIconWidth(), this.getIconHeight());
        }
    }
}

