/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputListener;
import net.sf.sdedit.Constants;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.Rectangle;
import net.sf.sdedit.ui.PanelPaintDeviceListener;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelPaintDevice
extends PaintDevice
implements MouseInputListener,
Constants {
    private FontMetrics fontMetrics;
    private FontMetrics boldFontMetrics;
    private Drawable lastDrawableMovedOver;
    private Dimension size;
    private final List<PanelPaintDeviceListener> listeners;
    private final Panel panel;
    private final boolean interactive;
    private boolean antialias;
    private boolean blank;

    public PanelPaintDevice(boolean bl) {
        this.interactive = bl;
        this.listeners = new LinkedList<PanelPaintDeviceListener>();
        this.panel = new Panel();
        ToolTipManager.sharedInstance().registerComponent(this.panel);
        this.antialias = true;
        this.blank = true;
    }

    @Override
    public void setDiagram(Diagram diagram) {
        super.setDiagram(diagram);
        Graphics graphics = new BufferedImage(1, 1, 1).getGraphics();
        graphics.setFont(this.getFont(false));
        this.fontMetrics = graphics.getFontMetrics();
        Graphics graphics2 = new BufferedImage(1, 1, 1).getGraphics();
        graphics2.setFont(this.getFont(true));
        this.boldFontMetrics = graphics2.getFontMetrics();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.interactive) {
            JPanel jPanel = this.panel.getZoomPane().getPanel();
            Point point = mouseEvent.getPoint();
            if (this.lastDrawableMovedOver != null) {
                if (!this.lastDrawableMovedOver.contains(point)) {
                    for (PanelPaintDeviceListener object : this.listeners) {
                        object.mouseExitedDrawable(this.lastDrawableMovedOver);
                        jPanel.setCursor(Cursor.getDefaultCursor());
                    }
                } else {
                    return;
                }
            }
            this.lastDrawableMovedOver = null;
            for (Drawable drawable : this) {
                if (drawable instanceof Fragment || !drawable.contains(point)) continue;
                this.lastDrawableMovedOver = drawable;
                for (PanelPaintDeviceListener panelPaintDeviceListener : this.listeners) {
                    if (!panelPaintDeviceListener.mouseEnteredDrawable(drawable)) continue;
                    jPanel.setCursor(HAND_CURSOR);
                }
                return;
            }
        }
    }

    public void addListener(PanelPaintDeviceListener panelPaintDeviceListener) {
        this.listeners.add(panelPaintDeviceListener);
    }

    @Override
    public void close() {
        super.close();
        this.size = new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public int getTextHeight(boolean bl) {
        return (bl ? this.boldFontMetrics : this.fontMetrics).getHeight();
    }

    @Override
    public int getTextWidth(String string, boolean bl) {
        return (bl ? this.boldFontMetrics : this.fontMetrics).stringWidth(string);
    }

    public Zoomable<JPanel> getPanel() {
        return this.panel;
    }

    public void setAntialiasing(boolean bl) {
        this.antialias = bl;
    }

    public boolean isBlank() {
        return this.blank;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.lastDrawableMovedOver != null) {
            for (PanelPaintDeviceListener panelPaintDeviceListener : this.listeners) {
                panelPaintDeviceListener.mouseClickedDrawable(this.lastDrawableMovedOver);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Panel
    extends JPanel
    implements Zoomable<JPanel> {
        private ZoomPane zoomPane;

        Panel() {
            this.addMouseMotionListener(PanelPaintDevice.this);
            this.addMouseListener(PanelPaintDevice.this);
        }

        @Override
        public ZoomPane getZoomPane() {
            return this.zoomPane;
        }

        @Override
        public void setZoomPane(ZoomPane zoomPane) {
            this.zoomPane = zoomPane;
        }

        @Override
        public JPanel asJComponent() {
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public Dimension getSize() {
            if (PanelPaintDevice.this.size == null) {
                return super.getSize();
            }
            return PanelPaintDevice.this.size;
        }

        @Override
        public int getWidth() {
            return this.getAbsoluteWidth();
        }

        @Override
        public int getHeight() {
            return this.getAbsoluteHeight();
        }

        @Override
        public int getAbsoluteWidth() {
            if (PanelPaintDevice.this.size == null) {
                return super.getWidth();
            }
            return ((PanelPaintDevice)PanelPaintDevice.this).size.width;
        }

        @Override
        public int getAbsoluteHeight() {
            if (PanelPaintDevice.this.size == null) {
                return super.getHeight();
            }
            return ((PanelPaintDevice)PanelPaintDevice.this).size.height;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            Point point = mouseEvent.getPoint();
            for (Drawable drawable : PanelPaintDevice.this) {
                ExtensibleDrawable extensibleDrawable;
                if (!(drawable instanceof ExtensibleDrawable) || !(extensibleDrawable = (ExtensibleDrawable)drawable).contains(point)) continue;
                Lifeline lifeline = extensibleDrawable.getLifeline();
                string = lifeline.toString();
                if (!lifeline.getDiagram().getConfiguration().isThreaded() || lifeline.isAlwaysActive() || !(extensibleDrawable instanceof Rectangle)) continue;
                string = string + " [thread=" + lifeline.getThread() + "]";
            }
            return string;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            java.awt.Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(rectangle);
            PanelPaintDevice.this.blank = PanelPaintDevice.this.isEmpty();
            if (!PanelPaintDevice.this.isEmpty()) {
                graphics2D.setFont(PanelPaintDevice.this.getFont(false));
                if (PanelPaintDevice.this.antialias) {
                    graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                }
                graphics2D.setColor(Color.BLACK);
                for (Drawable drawable : PanelPaintDevice.this) {
                    if (!drawable.intersects(rectangle)) continue;
                    drawable.draw(graphics2D);
                }
            }
            graphics2D.dispose();
        }
    }
}

