/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sf.sdedit.Constants;
import net.sf.sdedit.ui.Graphics2DPaintDevice;

public class ImagePaintDevice
extends Graphics2DPaintDevice
implements Constants {
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Image image;

    public Image getImage() {
        return this.image;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        this.drawAll();
        ImageIO.write((RenderedImage)((Object)this.image), "PNG", outputStream);
    }

    public void saveImage(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writeToStream(fileOutputStream);
    }

    public void saveImage(File file) throws IOException {
        this.writeToStream(new FileOutputStream(file));
    }

    protected Graphics2D createDummyGraphics(boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 11);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        Font font = this.getFont(bl);
        graphics2D.setFont(font);
        return graphics2D;
    }

    protected Graphics2D createGraphics() {
        this.image = this.getDiagram().isThreaded() ? new BufferedImage(this.getWidth(), this.getHeight(), 2) : new BufferedImage(this.getWidth(), this.getHeight(), 11);
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.setRenderingHints(AALIAS);
        graphics2D.setFont(this.getFont(false));
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        return graphics2D;
    }
}

