/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.text;

import java.io.BufferedReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.drawable.Note;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.text.TextBasedMessageData;
import net.sf.sdedit.util.Grep;
import net.sf.sdedit.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextHandler
implements DiagramDataProvider {
    private BufferedReader reader;
    private String text;
    private String rawLine;
    private String currentLine;
    private int lineBegin = 0;
    private int lineEnd = -1;
    private int section = -1;
    private Diagram diagram;
    private int lineNumber = 0;
    private String title;
    private String[] description;
    private Map<Lifeline, String> annotations;
    private boolean parseProperties;

    public TextHandler(String string) {
        this.text = string;
        this.annotations = new HashMap<Lifeline, String>();
        this.reset();
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        this.parseProperties = diagram.getConfiguration().isAllowMessageProperties();
    }

    public int getLineBegin() {
        return this.lineBegin;
    }

    @Override
    public Object getState() {
        return this.lineBegin;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getText() {
        return this.text;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    private void reset() {
        String[] stringArray = Grep.parse("(?s).*#!\\[([^\n\r]*?)\\].*", this.text);
        this.title = stringArray == null ? null : stringArray[0];
        String[] stringArray2 = Grep.parse("(?s).*#!>>(.*)#!<<.*", this.text);
        this.description = stringArray2 == null ? null : stringArray2[0].trim().split("\n");
        for (int i = 0; this.description != null && i < this.description.length; ++i) {
            this.description[i] = this.description[i].trim();
            if (!this.description[i].startsWith("#!")) {
                this.description = null;
                continue;
            }
            this.description[i] = this.description[i].replaceFirst("#!", "");
        }
        this.reader = new BufferedReader(new StringReader(this.text));
        this.section = -1;
        this.lineBegin = 0;
        this.lineEnd = -1;
        this.currentLine = null;
        this.rawLine = null;
        this.annotations.clear();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String[] getDescription() {
        return this.description;
    }

    @Override
    public boolean advance() {
        return this.advance(true);
    }

    private boolean advance(boolean bl) {
        if (this.reader == null) {
            throw new IllegalStateException("null reader");
        }
        try {
            String string;
            if (!this.reader.ready()) {
                this.section = 1;
                return false;
            }
            do {
                int n;
                this.lineBegin = this.lineEnd + 2;
                this.rawLine = string = this.reader.readLine();
                ++this.lineNumber;
                if (string == null) {
                    this.section = 1;
                    return false;
                }
                this.lineEnd = this.lineBegin + string.length() - 1;
                if (bl) {
                    string = string.trim();
                }
                if (this.section == -1 && (string.equals("") || string.startsWith("#"))) continue;
                this.section = Math.max(0, this.section);
                if (this.section == 0 && (n = string.indexOf("#")) >= 0) {
                    string = string.substring(0, n).trim();
                }
                if (this.section != 0 || !string.equals("")) continue;
                this.section = 1;
                return false;
            } while (bl && (string.equals("") || string.startsWith("#")));
            this.currentLine = string;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public String openFragment() {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine == null) {
            throw new IllegalStateException("nothing to read");
        }
        if (this.currentLine.startsWith("//")) {
            System.err.println("Warning: Comments starting with // are deprecated. Use [c:<type> <text>]...[/c].");
            return this.currentLine.substring(2).trim();
        }
        if (this.currentLine.endsWith("]") && this.currentLine.startsWith("[c")) {
            return this.currentLine;
        }
        return null;
    }

    @Override
    public String getFragmentSeparator() {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine == null) {
            throw new IllegalStateException("nothing to read");
        }
        if (this.currentLine.startsWith("--")) {
            return this.currentLine.substring(2);
        }
        return null;
    }

    @Override
    public boolean closeFragment() {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine == null) {
            throw new IllegalStateException("nothing to read");
        }
        return this.currentLine.equals("\\\\") || this.currentLine.endsWith("]") && this.currentLine.startsWith("[/c");
    }

    @Override
    public MessageData nextMessage() throws SyntaxError {
        TextBasedMessageData textBasedMessageData;
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine == null) {
            throw new IllegalStateException("nothing to read");
        }
        try {
            textBasedMessageData = new TextBasedMessageData(this.currentLine);
        }
        catch (SyntaxError syntaxError) {
            syntaxError.setProvider(this);
            throw syntaxError;
        }
        this.currentLine = null;
        return textBasedMessageData;
    }

    @Override
    public Lifeline nextObject() throws SyntaxError {
        Lifeline lifeline;
        boolean bl;
        if (this.section == 1) {
            throw new IllegalStateException("reading objects has already been finished");
        }
        if (this.currentLine == null) {
            throw new IllegalStateException("nothing to read");
        }
        if (this.currentLine.indexOf(58) == -1) {
            throw new SyntaxError(this, "not a valid object declaration - ':' missing");
        }
        String[] stringArray = Grep.parse("(\\/?.+?):([^\\[\\]]+?)\\s*(\\[.*?\\]|)\\s*(\".*\"|)", this.currentLine);
        if (stringArray == null || stringArray.length != 4) {
            String string = this.currentLine.indexOf(46) >= 0 ? "not a valid object declaration, perhaps you forgot to enter an empty line before the message section" : "not a valid object declaration";
            throw new SyntaxError(this, string);
        }
        this.currentLine = null;
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        if (!string4.equals("")) {
            string4 = string4.substring(1, string4.length() - 1);
        }
        boolean bl2 = string3.indexOf(97) >= 0;
        boolean bl3 = string3.indexOf(114) >= 0;
        boolean bl4 = string3.indexOf(118) >= 0;
        boolean bl5 = string3.indexOf(112) >= 0;
        boolean bl6 = string3.indexOf(116) >= 0;
        boolean bl7 = string3.indexOf(120) >= 0;
        boolean bl8 = bl = string3.indexOf(101) >= 0;
        if (bl && !bl5) {
            throw new SyntaxError(this, "only processes can be declared external");
        }
        if (string.startsWith("/")) {
            if (string2.equals("Actor") || bl5) {
                throw new SyntaxError(this, "processes and actors must be visible");
            }
            if (bl6) {
                throw new SyntaxError(this, "invisible objects cannot have their own thread");
            }
            lifeline = new Lifeline(string.substring(1), string2, string4, false, bl2, bl3, bl4, false, false, bl7, bl, this.diagram);
        } else {
            if (string2.equals("Actor") && bl2) {
                throw new SyntaxError(this, "actors cannot be anonymous");
            }
            if ((string2.equals("Actor") || bl5) && bl6) {
                throw new SyntaxError(this, "actors cannot have their own thread");
            }
            if ((string2.equals("Actor") || bl5) && bl7) {
                throw new SyntaxError(this, "actors cannot be (automatically) destroyed");
            }
            lifeline = new Lifeline(stringArray[0], stringArray[1], string4, true, bl2, bl3, bl4, bl5, bl6, bl7, bl, this.diagram);
        }
        int n = this.rawLine.indexOf("#!");
        if (n >= 0 && n + 2 < this.rawLine.length() - 1) {
            String string5 = this.rawLine.substring(n + 2).trim();
            this.annotations.put(lifeline, string5);
        }
        return lifeline;
    }

    public String getAnnotation(Lifeline lifeline) {
        String string = this.annotations.get(lifeline);
        return string;
    }

    @Override
    public Note getNote() throws SyntaxError {
        Object object;
        boolean bl;
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine == null) {
            throw new IllegalStateException("nothing to read");
        }
        String[] stringArray = Grep.parse("\\s*(\\*|\\+)(\\d+)\\s*(.+)", this.currentLine);
        if (stringArray == null) {
            return null;
        }
        boolean bl2 = stringArray[0].equals("+");
        int n = -1;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 0) {
            throw new SyntaxError(this, "bad note number: " + stringArray[1]);
        }
        String string = stringArray[2];
        Lifeline lifeline = this.diagram.getLifeline(string);
        if (lifeline == null) {
            throw new SyntaxError(this, string + " does not exist");
        }
        int n2 = this.lineBegin;
        int n3 = this.lineEnd;
        lifeline = lifeline.getRightmost();
        LinkedList<String> linkedList = new LinkedList<String>();
        do {
            if (!this.advance(false)) {
                this.lineBegin = n2;
                this.lineEnd = n3;
                throw new SyntaxError(this, "The note is not closed.");
            }
            boolean bl3 = bl = !this.currentLine.trim().equals(stringArray[0] + stringArray[1]);
        } while (bl && linkedList.add(this.currentLine));
        if (linkedList.size() == 0) {
            this.lineBegin = n2;
            this.lineEnd = n3;
            throw new SyntaxError(this, "The note is empty.");
        }
        String[] stringArray2 = linkedList.toArray(new String[0]);
        URI uRI = null;
        if (stringArray2.length == 1 && ((String)(object = stringArray2[0].trim())).startsWith("link:")) {
            try {
                object = ((String)object).substring(5).trim();
                uRI = new URI((String)object);
                if (uRI.getPath() == null) {
                    throw new SyntaxError(this, "Empty path in URI: " + (String)object);
                }
                stringArray2[0] = uRI.getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new SyntaxError(this, "Bad URI syntax: " + uRISyntaxException.getMessage());
            }
        }
        object = new Note(lifeline, n, stringArray2, bl2);
        ((Note)object).setLink(uRI);
        return object;
    }

    @Override
    public Pair<Lifeline, Integer> getEventAssociation() throws SyntaxError {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine == null) {
            throw new IllegalStateException("nothing to read");
        }
        String[] stringArray = Grep.parse("\\((\\d+)\\)\\s*(\\w+)", this.currentLine);
        if (stringArray == null) {
            return null;
        }
        int n = Integer.parseInt(stringArray[0]);
        String string = stringArray[1];
        Lifeline lifeline = this.diagram.getLifeline(string);
        if (lifeline == null) {
            throw new SyntaxError(this, string + " does not exist");
        }
        return new Pair<Lifeline, Integer>(lifeline, n);
    }
}

