/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.text;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.util.Grep;

public class TextBasedMessageData
extends MessageData {
    private static final String LEVELS = "(\\[(\\d*),(\\d+)\\]|\\[(\\d+)\\]|\\[(\\D.*)\\])";
    private static final String PREFIX = "(\\(\\d*(,\\d+)?\\))?\\s*(.+)";
    private static final String COLON = "(?<!\\\\):(?!>)";
    private static final String SPAWN = "(?<!\\\\):>";
    private static final String DOT = "(?<!\\\\)\\.";
    private static final String EQ = "(?<!\\\\)=";
    private static final String MSG = "(.*)()()()";
    private static final String MSG_PROP = "(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?";
    private String string;

    public TextBasedMessageData(String string) throws SyntaxError {
        this.string = string;
        this.parse();
    }

    private void parse() throws SyntaxError {
        boolean bl = false;
        if (this.string.indexOf(58) == -1) {
            throw new SyntaxError(null, "not a valid message - ':' missing");
        }
        try {
            bl = Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(\\[(\\d*),(\\d+)\\]|\\[(\\d+)\\]|\\[(\\D.*)\\])(?<!\\\\):(?!>)(.*)(?<!\\\\)=(.+?)(?<!\\\\)\\.(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "caller", "dummy", "levelString", "threadString", "levelString", "callerMnemonic", "answer", "callee", "message", "properties", "dummy", "dummy") || Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(\\[(\\d*),(\\d+)\\]|\\[(\\d+)\\]|\\[(\\D.*)\\])(?<!\\\\):(?!>)(.+?)(?<!\\\\)\\.(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "caller", "dummy", "levelString", "threadString", "levelString", "callerMnemonic", "callee", "message", "properties", "dummy", "dummy") || Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(?<!\\\\):(?!>)(.*)(?<!\\\\)=(.+?)(?<!\\\\)\\.(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "caller", "answer", "callee", "message", "properties", "dummy", "dummy") || Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(?<!\\\\):(?!>)(.*?)(?<!\\\\)\\.(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "caller", "callee", "message", "properties", "dummy", "dummy") || Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(\\[(\\d*),(\\d+)\\]|\\[(\\d+)\\]|\\[(\\D.*)\\])(?<!\\\\):(?!>)(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "caller", "dummy", "levelString", "threadString", "levelString", "callerMnemonic", "message", "properties", "dummy", "dummy") || Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(?<!\\\\):(?!>)(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "caller", "message", "properties", "dummy", "dummy") || Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(\\[(\\d*),(\\d+)\\]|\\[(\\d+)\\]|\\[(\\D.*)\\])(?<!\\\\):>(.+?)(?<!\\\\)\\.(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "spawner", "dummy", "levelString", "threadString", "levelString", "callerMnemonic", "callee", "message", "properties", "dummy", "dummy") || Grep.parseAndSetProperties(this, "(\\(\\d*(,\\d+)?\\))?\\s*(.+)(?<!\\\\):>(.+?)(?<!\\\\)\\.(.*?)(\\{([^,=]+=[^,=]+)(,[^,=]+=[^,=]+)*\\})?", this.string, "noteId", "dummy", "spawner", "callee", "message", "properties", "dummy", "dummy");
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        if (!bl) {
            throw new SyntaxError(null, "not a valid message");
        }
    }

    public void setMessage(String string) {
        if (string.endsWith("&")) {
            this.setReturnsInstantly(true);
            string = string.substring(0, string.length() - 1);
        }
        super.setMessage(string);
    }

    public void setCallee(String string) {
        if (string.length() >= 2 && string.charAt(0) == '{' && string.charAt(string.length() - 1) == '}') {
            this.setCallees(string.substring(1, string.length() - 1).split(","));
        } else {
            String[] stringArray = Grep.parse("(.*)\\[(\\D.*)\\]$", string);
            if (stringArray == null) {
                super.setCallee(string);
            } else {
                super.setCallee(stringArray[0]);
                super.setCalleeMnemonic(stringArray[1]);
            }
        }
    }

    public void setSpawner(String string) {
        this.setSpawnMessage(true);
        this.setCaller(string);
    }

    public void setLevelString(String string) {
        if (!string.equals("")) {
            this.setLevel(Integer.parseInt(string));
        }
    }

    public void setThreadString(String string) {
        if (!string.equals("")) {
            this.setThread(Integer.parseInt(string));
        }
    }

    public void setDummy(String string) {
    }

    public void setNoteId(String string) {
        if (!(string = string.trim()).equals("")) {
            String[] stringArray = (string = string.substring(1, string.length() - 1)).split(",");
            if (stringArray[0].length() > 0) {
                this.setNoteNumber(Integer.parseInt(stringArray[0]));
            }
            if (stringArray.length > 1) {
                this.setAnswerNoteNumber(Integer.parseInt(stringArray[1]));
            }
        }
    }

    static {
        for (Method method : TextBasedMessageData.class.getMethods()) {
            try {
                method.setAccessible(true);
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getClass().getSimpleName());
            }
        }
    }
}

