/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.taglet;

import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.ImagePaintDevice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceTaglet
implements Taglet {
    private static final String tagName = "sequence.diagram";
    private static final String imageSubDirectory = "sequence-diagrams";
    private File diagramDirectory;
    private Map<String, Integer> nameCounter = new HashMap<String, Integer>();

    public static void register(Map<String, Taglet> map) {
        SequenceTaglet sequenceTaglet = new SequenceTaglet();
        Taglet taglet = map.get(sequenceTaglet.getName());
        if (taglet != null) {
            map.remove(sequenceTaglet.getName());
        }
        map.put(sequenceTaglet.getName(), sequenceTaglet);
    }

    private SequenceTaglet() {
    }

    private String getPathToJavadocDestination(Tag tag) throws SequenceTagletException {
        Object object;
        PackageDoc packageDoc = null;
        if (tag.holder() instanceof PackageDoc) {
            packageDoc = (PackageDoc)tag.holder();
        } else {
            object = (ProgramElementDoc)tag.holder();
            packageDoc = object.containingPackage();
        }
        if (packageDoc.allClasses() == null || packageDoc.allClasses().length == 0) {
            throw new SequenceTagletException("Cowardly refusing to generate a sequence diagram for an empty package", null);
        }
        object = packageDoc.allClasses()[0].qualifiedName();
        String string = "";
        for (int i = 0; i < ((String)object).length(); ++i) {
            if (((String)object).charAt(i) != '.') continue;
            string = string + "../";
        }
        return string;
    }

    private String getImageName(Tag tag) {
        String string = tag.holder().name();
        Integer n = this.nameCounter.get(string);
        if (n == null) {
            n = 1;
        } else {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        this.nameCounter.put(string, n);
        return string + "-" + n;
    }

    private String generateOutput(String string, String string2, String[] stringArray) throws SequenceTagletException {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string3 = null;
        if (stringArray[0].trim().matches("^[\"'].*[\"']$")) {
            string3 = stringArray[0].replaceAll("[\"']", "");
            stringArray[0] = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string4 : stringArray) {
            String object2 = string4.trim();
            if (object2.startsWith("<") && object2.endsWith(">")) continue;
            stringBuffer.append(object2 + "\n");
        }
        String string4 = stringBuffer.toString().trim();
        if (string4.length() == 0) {
            return "";
        }
        Configuration configuration = ConfigurationManager.createNewDefaultConfiguration().getDataObject();
        configuration.setHeadWidth(25);
        configuration.setMainLifelineWidth(5);
        configuration.setSubLifelineWidth(5);
        configuration.setThreaded(true);
        configuration.setGlue(3);
        ImagePaintDevice imagePaintDevice = new ImagePaintDevice();
        TextHandler textHandler = new TextHandler(string4);
        try {
            new Diagram(configuration, textHandler, imagePaintDevice).generate();
        }
        catch (Exception exception) {
            int n = textHandler.getLineNumber();
            StringBuffer string7 = new StringBuffer("<br><tt>");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i].replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
                if (i == n) {
                    string5 = "<FONT COLOR=\"red\"><U><B>" + string5 + "</B></U></FONT>";
                }
                string7.append(string5 + "<br>");
            }
            throw new SequenceTagletException("Malformed diagram specification: " + exception.getMessage(), "<DT><HR><B>Sequence Diagram:</B></DT><DD><B>Could not create sequence diagram: <font color=\"red\">" + exception.getMessage() + "</font></B>" + string7.toString() + "</DD>");
        }
        String string6 = string2 + ".png";
        File file = new File(this.diagramDirectory, string6);
        try {
            imagePaintDevice.saveImage(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new SequenceTagletException("Could not save diagram image: " + iOException.getMessage(), "");
        }
        if (string3 == null) {
            string3 = "Sequence Diagram " + string2;
        }
        String string7 = string + imageSubDirectory + "/" + string6;
        String string8 = "<A name=\"" + string2 + "\"/>";
        return "<DT><HR><B>" + string8 + string3 + ":</B><P></DT>" + "<DD><img src='" + string7 + "'></DD>";
    }

    public String getName() {
        return tagName;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inField() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return false;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return false;
    }

    private String toString(Tag tag, TagletWriter tagletWriter) {
        String string;
        try {
            String string2 = this.getPathToJavadocDestination(tag);
            string = this.generateOutput(string2, this.getImageName(tag), tag.text().split("\n"));
        }
        catch (SequenceTagletException sequenceTagletException) {
            tagletWriter.configuration().message.warning("doclet.in", sequenceTagletException.getMessage(), tag.holder().name());
            return sequenceTagletException.output;
        }
        return string;
    }

    private String toString(Tag[] tagArray, TagletWriter tagletWriter) {
        if (tagArray != null && tagArray.length > 0) {
            String string = "";
            for (Tag tag : tagArray) {
                try {
                    string = string + this.generateOutput(this.getPathToJavadocDestination(tag), this.getImageName(tag), tag.text().split("\n"));
                }
                catch (SequenceTagletException sequenceTagletException) {
                    tagletWriter.configuration().message.warning("doclet.in", sequenceTagletException.getMessage(), tagArray[0].holder().name());
                    string = string + sequenceTagletException.output;
                }
            }
            return string;
        }
        return null;
    }

    private void setDestinationDirectory(String string) {
        File file = new File(string);
        this.diagramDirectory = new File(file, imageSubDirectory);
        this.diagramDirectory.mkdirs();
    }

    public TagletOutput getTagletOutput(Tag tag, TagletWriter tagletWriter) throws IllegalArgumentException {
        if (this.diagramDirectory == null) {
            this.setDestinationDirectory(tagletWriter.configuration().destDirName);
        }
        TagletOutput tagletOutput = tagletWriter.getTagletOutputInstance();
        tagletOutput.setOutput((Object)this.toString(tag, tagletWriter));
        return tagletOutput;
    }

    public TagletOutput getTagletOutput(Doc doc, TagletWriter tagletWriter) throws IllegalArgumentException {
        if (this.diagramDirectory == null) {
            this.setDestinationDirectory(tagletWriter.configuration().destDirName);
        }
        TagletOutput tagletOutput = tagletWriter.getTagletOutputInstance();
        Tag[] tagArray = doc.tags(this.getName());
        if (tagArray.length == 0) {
            return null;
        }
        tagletOutput.setOutput((Object)this.toString(tagArray, tagletWriter));
        return tagletOutput;
    }

    private static class SequenceTagletException
    extends Exception {
        String output;

        SequenceTagletException(String string, String string2) {
            super(string);
            this.output = string2;
        }
    }
}

