/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.server.Receiver;
import net.sf.sdedit.util.Grep;

public class RealtimeServer
extends Thread
implements Constants {
    private ServerSocket serverSocket;
    private Editor editor;
    private List<Receiver> receivers;
    private boolean shutDown;

    public RealtimeServer(int n, Editor editor) throws IOException {
        this.serverSocket = new ServerSocket(n);
        this.editor = editor;
        this.receivers = new LinkedList<Receiver>();
    }

    public void shutDown() {
        this.shutDown = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Receiver receiver : this.receivers) {
            receiver.shutDown();
        }
    }

    public int getPort() {
        if (this.serverSocket == null) {
            return 0;
        }
        return this.serverSocket.getLocalPort();
    }

    private void createReceiver(final Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, ConfigurationManager.getGlobalConfiguration().getFileEncoding()));
        String string = bufferedReader.readLine();
        if (string != null) {
            BufferedReader bufferedReader2;
            String string2;
            String[] stringArray = Grep.parse("^(.*)\\[(.*)\\]$", string = string.trim());
            if (stringArray != null) {
                String string3 = stringArray[1];
                string2 = stringArray[0];
                BufferedReader bufferedReader3 = null;
                try {
                    bufferedReader3 = new BufferedReader(new InputStreamReader(inputStream, string3));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bufferedReader3 = null;
                }
                bufferedReader2 = bufferedReader3 == null ? bufferedReader : bufferedReader3;
            } else {
                string2 = string;
                bufferedReader2 = bufferedReader;
            }
            if (string2.length() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = RealtimeServer.this.editor.getUI().addTab(string2, ConfigurationManager.createNewDefaultConfiguration());
                        Receiver receiver = new Receiver(RealtimeServer.this.editor, string, bufferedReader2, socket);
                        RealtimeServer.this.receivers.add(receiver);
                        Thread thread = new Thread(receiver);
                        thread.setDaemon(true);
                        thread.start();
                    }
                });
            }
        }
    }

    public void run() {
        while (true) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException iOException) {
                if (this.shutDown) {
                    return;
                }
                this.editor.getUI().errorMessage("While waiting for a client to be connected,\nthe realtime server caught an exception of type\n" + iOException.getClass().getSimpleName() + " with the message:\n" + iOException.getMessage());
                return;
            }
            try {
                this.createReceiver(socket);
                continue;
            }
            catch (Exception exception) {
                this.editor.getUI().errorMessage("While establishing a connection to a client,\nthe realtime server caught an exception of type\n" + exception.getClass().getSimpleName() + " with the message:\n" + exception.getMessage());
                continue;
            }
            break;
        }
    }
}

