/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.server;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import net.sf.sdedit.server.Exporter;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.gif.GIFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.graphicsio.swf.SWFGraphics2D;

class ExporterImpl
extends Exporter {
    private OutputStream stream;
    private String type;
    private VectorGraphics vg;
    private String orientation;
    private String format;
    private Dimension dim;

    public ExporterImpl(String string, String string2) {
        this.orientation = string;
        this.format = string2;
    }

    private VectorGraphics getGraphics() {
        GIFGraphics2D gIFGraphics2D;
        if (this.orientation == null) {
            String string = this.orientation = this.dim.getWidth() <= this.dim.getHeight() ? "Portrait" : "Landscape";
        }
        if (this.type.equals("gif")) {
            gIFGraphics2D = new GIFGraphics2D(this.stream, this.dim);
        } else if (this.type.equals("png")) {
            gIFGraphics2D = new ImageGraphics2D(this.stream, this.dim, "png");
        } else if (this.type.equals("bmp")) {
            gIFGraphics2D = new ImageGraphics2D(this.stream, this.dim, "bmp");
        } else if (this.type.equals("jpg")) {
            gIFGraphics2D = new ImageGraphics2D(this.stream, this.dim, "jpg");
        } else if (this.type.equals("pdf")) {
            PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(this.stream, this.dim);
            Properties properties = new Properties();
            properties.setProperty(PDFGraphics2D.ORIENTATION, this.orientation);
            properties.setProperty(PDFGraphics2D.PAGE_SIZE, this.format);
            pDFGraphics2D.setProperties(properties);
            gIFGraphics2D = pDFGraphics2D;
        } else if (this.type.equals("ps")) {
            PSGraphics2D pSGraphics2D = new PSGraphics2D(this.stream, this.dim);
            Properties properties = new Properties();
            properties.setProperty(PSGraphics2D.ORIENTATION, this.orientation);
            properties.setProperty(PSGraphics2D.PAGE_SIZE, this.format);
            pSGraphics2D.setProperties(properties);
            pSGraphics2D.setMultiPage(true);
            gIFGraphics2D = pSGraphics2D;
        } else if (this.type.equals("emf")) {
            gIFGraphics2D = new EMFGraphics2D(this.stream, this.dim);
        } else if (this.type.equals("svg")) {
            gIFGraphics2D = new SVGGraphics2D(this.stream, this.dim);
        } else if (this.type.equals("swf")) {
            gIFGraphics2D = new SWFGraphics2D(this.stream, this.dim);
        } else {
            throw new IllegalArgumentException("Unknown type: " + this.type);
        }
        return gIFGraphics2D;
    }

    protected Graphics2D createDummyGraphics(boolean bl) {
        this.dim = new Dimension(1, 1);
        return this.getGraphics();
    }

    protected Graphics2D createGraphics() {
        this.dim = new Dimension(this.getWidth(), this.getHeight());
        this.vg = this.getGraphics();
        if (this.vg instanceof ImageGraphics2D) {
            this.vg.setColor(Color.WHITE);
            this.vg.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        return this.vg;
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.stream = outputStream;
    }

    protected void setType(String string) {
        this.type = string.toLowerCase();
    }

    public void export() {
        this.vg.startExport();
        if (this.vg instanceof PSGraphics2D) {
            try {
                ((PSGraphics2D)this.vg).openPage(this.dim, "");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.drawAll();
        if (this.vg instanceof PSGraphics2D) {
            ((PSGraphics2D)this.vg).closePage();
        }
        this.vg.endExport();
    }
}

