/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.PriorityQueue;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.server.Exporter;
import net.sf.sdedit.text.TextHandler;

public class DiagramServer
extends Thread {
    private ServerSocket serverSocket;
    private PriorityQueue<ServerThread> threadPool;
    private static int poolSize = 5;

    public DiagramServer(int n) throws IOException {
        this.serverSocket = new ServerSocket(n);
        this.setName("DiagramServer");
        this.setDaemon(true);
        this.threadPool = new PriorityQueue();
        for (int i = 0; i < poolSize; ++i) {
            ServerThread serverThread = new ServerThread();
            serverThread.start();
            this.threadPool.add(serverThread);
        }
        this.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket socket = this.serverSocket.accept();
                    ServerThread serverThread = (ServerThread)this.threadPool.remove();
                    serverThread.addJob(socket);
                    this.threadPool.add(serverThread);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServerThread
    extends Thread
    implements Comparable<ServerThread> {
        private LinkedList<Socket> queue = new LinkedList();

        ServerThread() {
            this.setName("DiagramServer worker thread");
            this.setDaemon(true);
        }

        synchronized void addJob(Socket socket) {
            this.queue.addFirst(socket);
            this.notify();
        }

        @Override
        public synchronized int compareTo(ServerThread serverThread) {
            return this.queue.size() - serverThread.queue.size();
        }

        public synchronized boolean equals(Object object) {
            if (!(object instanceof ServerThread)) {
                return false;
            }
            ServerThread serverThread = (ServerThread)object;
            return this.compareTo(serverThread) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            while (true) {
                String string;
                Object object;
                String string2;
                Socket socket = null;
                Object object2 = this;
                synchronized (object2) {
                    while (this.queue.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    socket = this.queue.removeLast();
                }
                object2 = new InputStreamReader(socket.getInputStream(), "utf-8");
                BufferedReader bufferedReader = new BufferedReader((Reader)object2);
                String string3 = bufferedReader.readLine().trim();
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null && !string2.equals("END")) {
                    stringBuffer.append(string2 + "\n");
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), "utf-8");
                PrintWriter printWriter = new PrintWriter(outputStreamWriter);
                try {
                    Exporter exporter = Exporter.getExporter(string3, null, "A4", socket.getOutputStream());
                    if (exporter == null) {
                        throw new RuntimeException("FreeHEP library missing.");
                    }
                    object = new Diagram(ConfigurationManager.createNewDefaultConfiguration().getDataObject(), new TextHandler(stringBuffer.toString()), exporter);
                    ((Diagram)object).generate();
                    exporter.export();
                }
                catch (SyntaxError syntaxError) {
                    object = (TextHandler)syntaxError.getProvider();
                    string = "ERROR:syntax error in line " + ((TextHandler)object).getLineNumber() + ": " + syntaxError.getMessage();
                    printWriter.println(string);
                    printWriter.flush();
                    printWriter.close();
                }
                catch (SemanticError semanticError) {
                    object = (TextHandler)semanticError.getProvider();
                    string = "ERROR:semantic error in line " + ((TextHandler)object).getLineNumber() + ": " + semanticError.getMessage();
                    printWriter.println(string);
                    printWriter.flush();
                    printWriter.close();
                }
                catch (Throwable throwable) {
                    printWriter.println("ERROR:fatal error: " + throwable.getMessage());
                    printWriter.flush();
                    printWriter.close();
                }
                socket.close();
                Object var13_18 = null;
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception exception) {}
                continue;
                {
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        var13_18 = null;
                        if (socket == null) continue;
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var13_18 = null;
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

