/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.multipage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipagePaintDevice
extends PaintDevice {
    private Dimension pageSize;
    private Graphics2D graphics;
    private Graphics2D boldGraphics;
    private List<MultipagePanel> panels;
    private double scale;
    private PrintConfiguration properties;

    public MultipagePaintDevice(PrintConfiguration printConfiguration, Dimension dimension) {
        this.pageSize = dimension;
        this.panels = new ArrayList<MultipagePanel>();
        this.properties = printConfiguration;
    }

    @Override
    public void setDiagram(Diagram diagram) {
        super.setDiagram(diagram);
        this.graphics = (Graphics2D)new BufferedImage(1, 1, 11).getGraphics();
        this.graphics.setFont(this.getFont(false));
        this.boldGraphics = (Graphics2D)new BufferedImage(1, 1, 11).getGraphics();
        this.boldGraphics.setFont(this.getFont(false));
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    private double computeScale() {
        int n = this.pageSize.height;
        int n2 = this.pageSize.width;
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        double d = 1.0 * (double)n2 / (double)n4;
        if (this.properties.isMultipage()) {
            return Math.min(1.0, d);
        }
        double d2 = 1.0 * (double)n / (double)n3;
        if (this.properties.isFitToPage()) {
            return Math.min(d, d2);
        }
        return Math.min(1.0, Math.min(d, d2));
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void close() {
        super.close();
        this.scale = this.computeScale();
        int n = this.properties.isMultipage() ? (int)((double)this.getHeight() * this.scale) / this.pageSize.height + 1 : 1;
        for (int i = 0; i < n; ++i) {
            this.panels.add(new MultipagePanel(i));
        }
    }

    public List<MultipagePanel> getPanels() {
        return this.panels;
    }

    @Override
    public void announce(int n) {
        int n2;
        int n3;
        if (this.properties.isMultipage() && (n3 = (n2 = this.getDiagram().getVerticalPosition()) + n) / this.pageSize.height > n2 / this.pageSize.height) {
            int n4 = this.pageSize.height - n2 % this.pageSize.height;
            this.getDiagram().extendLifelines(n4);
        }
    }

    @Override
    public int getTextHeight(boolean bl) {
        return (bl ? this.boldGraphics : this.graphics).getFontMetrics().getHeight();
    }

    @Override
    public int getTextWidth(String string, boolean bl) {
        return (bl ? this.boldGraphics : this.graphics).getFontMetrics().stringWidth(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MultipagePanel
    extends JPanel
    implements Zoomable<JPanel> {
        private int index;
        private ZoomPane zoomPane;
        private Dimension dim;

        MultipagePanel(int n) {
            this.index = n;
            this.dim = MultipagePaintDevice.this.pageSize;
        }

        @Override
        public Dimension getSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.dim;
        }

        @Override
        public int getHeight() {
            return this.dim.height;
        }

        @Override
        public int getWidth() {
            return this.dim.width;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.scale(MultipagePaintDevice.this.scale, MultipagePaintDevice.this.scale);
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(rectangle);
            Rectangle rectangle2 = null;
            int n2 = (int)((double)((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.width / MultipagePaintDevice.this.scale);
            int n3 = (int)((double)((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.height / MultipagePaintDevice.this.scale);
            if (MultipagePaintDevice.this.properties.isMultipage()) {
                n = this.index * (int)((double)((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.height / MultipagePaintDevice.this.scale);
                graphics2D.translate(0, -n);
                rectangle2 = new Rectangle(0, n, n2, n3);
            } else if (MultipagePaintDevice.this.properties.isCenterVertically() && (n = n3 - MultipagePaintDevice.this.getHeight()) > 0) {
                graphics2D.translate(0, n / 2);
            }
            if (MultipagePaintDevice.this.properties.isCenterHorizontally() && (n = n2 - MultipagePaintDevice.this.getWidth()) > 0) {
                graphics2D.translate(n / 2, 0);
            }
            for (Drawable drawable : MultipagePaintDevice.this) {
                if (rectangle2 != null && !drawable.intersects(rectangle2)) continue;
                drawable.draw(graphics2D);
            }
            graphics2D.dispose();
        }

        @Override
        public JPanel asJComponent() {
            return this;
        }

        @Override
        public int getAbsoluteHeight() {
            return ((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.height;
        }

        @Override
        public int getAbsoluteWidth() {
            return ((MultipagePaintDevice)MultipagePaintDevice.this).pageSize.width;
        }

        @Override
        public ZoomPane getZoomPane() {
            return this.zoomPane;
        }

        @Override
        public void setZoomPane(ZoomPane zoomPane) {
            this.zoomPane = zoomPane;
        }
    }
}

