/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.multipage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.multipage.ExportDocument;
import net.sf.sdedit.multipage.MultipagePaintDevice;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.components.ZoomPane;
import org.freehep.graphicsio.PageConstants;

public class MultipageExporter
extends JPanel {
    private static Class<? extends Graphics2D> ps;
    private static Class<? extends Graphics2D> pdf;
    private String source;
    private Configuration configuration;
    private Dimension size;
    private MultipagePaintDevice paintDevice;
    private double scale;
    private Dimension previewSize;
    private PrintConfiguration properties;

    public static boolean isAvailable() {
        return pdf != null;
    }

    public MultipageExporter(PrintConfiguration printConfiguration, String string, Configuration configuration) {
        this.properties = printConfiguration;
        this.source = string;
        this.configuration = configuration;
        this.size = PageConstants.getSize(printConfiguration.getFormat(), printConfiguration.getOrientation());
        double d = 315.0;
        if (printConfiguration.getOrientation().equals("Portrait")) {
            this.scale = d / (double)this.size.height;
            this.previewSize = new Dimension(223, 315);
        } else {
            this.scale = d / (double)this.size.width;
            this.previewSize = new Dimension(315, 223);
        }
    }

    public double getScale() {
        return this.paintDevice.getScale();
    }

    public void init() throws SyntaxError, SemanticError {
        this.paintDevice = new MultipagePaintDevice(this.properties, this.size);
        TextHandler textHandler = new TextHandler(this.source);
        new Diagram(this.configuration, textHandler, this.paintDevice).generate();
        int n = this.paintDevice.getPanels().size();
        this.setLayout(new BoxLayout(this, 0));
        int n2 = 0;
        for (MultipagePaintDevice.MultipagePanel multipagePanel : this.paintDevice.getPanels()) {
            ++n2;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            jPanel.setAlignmentY(0.5f);
            ZoomPane zoomPane = new ZoomPane(false);
            zoomPane.setViewportView(multipagePanel);
            zoomPane.setScale(this.scale);
            zoomPane.setMinimumSize(this.previewSize);
            zoomPane.setMaximumSize(this.previewSize);
            zoomPane.setPreferredSize(this.previewSize);
            zoomPane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            jPanel.add(zoomPane);
            JLabel jLabel = new JLabel(n2 + "/" + n);
            jLabel.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            this.add(jPanel);
        }
    }

    public void exportTo(OutputStream outputStream, String string) throws IOException {
        Class<? extends Graphics2D> clazz = string.toLowerCase().equals("pdf") ? pdf : ps;
        ExportDocument exportDocument = new ExportDocument(clazz, this.paintDevice, outputStream, this.properties.getFormat(), this.properties.getOrientation());
        exportDocument.export();
    }

    static {
        try {
            ps = Class.forName("org.freehep.graphicsio.ps.PSGraphics2D");
            pdf = Class.forName("org.freehep.graphicsio.pdf.PDFGraphics2D");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

