/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.multipage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import net.sf.sdedit.multipage.MultipagePaintDevice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDocument {
    private MultipagePaintDevice mpd;
    private Class<? extends Graphics2D> graphicsClass;
    private Graphics2D graphics;

    public ExportDocument(Class<? extends Graphics2D> clazz, MultipagePaintDevice multipagePaintDevice, OutputStream outputStream, String string, String string2) {
        this.mpd = multipagePaintDevice;
        this.graphicsClass = clazz;
        try {
            this.graphics = clazz.getConstructor(OutputStream.class, Dimension.class).newInstance(outputStream, multipagePaintDevice.getPageSize());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Cannot create instance of " + clazz.getSimpleName());
        }
        this.invoke("setMultiPage", Boolean.TYPE, Boolean.TRUE);
        Properties properties = new Properties();
        properties.setProperty(this.getStringConstant("ORIENTATION"), string2);
        properties.setProperty(this.getStringConstant("PAGE_SIZE"), string);
        this.invoke("setProperties", Properties.class, properties);
    }

    private void invoke(String string) {
        this.invoke(string, null, null);
    }

    private String getStringConstant(String string) {
        try {
            Field field = this.graphicsClass.getField(string);
            return (String)field.get(null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("cannot resolve string constant " + string);
        }
    }

    private <T> void invoke(String string, Class<? extends T> clazz, T t) {
        try {
            Object[] objectArray;
            Class[] classArray;
            if (clazz == null) {
                classArray = new Class[]{};
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = clazz;
            }
            Class[] classArray3 = classArray;
            Method method = this.graphicsClass.getMethod(string, classArray3);
            if (t == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = t;
            }
            Object[] objectArray3 = objectArray;
            method.invoke((Object)this.graphics, objectArray3);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IllegalArgumentException("invocation of " + string + " failed");
        }
    }

    public void export() throws IOException {
        this.invoke("startExport");
        for (MultipagePaintDevice.MultipagePanel multipagePanel : this.mpd.getPanels()) {
            this.invoke("openPage", Component.class, multipagePanel);
            multipagePanel.paintComponent(this.graphics);
            this.invoke("closePage");
        }
        this.invoke("endExport");
    }
}

