/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.drawable.Arrow;

public abstract class Message
implements Constants {
    private final Lifeline caller;
    private final Lifeline callee;
    protected final Diagram diagram;
    private final MessageData data;
    private final Configuration conf;
    private Arrow arrow;

    protected Message(Lifeline lifeline, Lifeline lifeline2, Diagram diagram, MessageData messageData) {
        this.caller = lifeline;
        this.callee = lifeline2;
        this.diagram = diagram;
        this.data = messageData;
        this.conf = diagram.getConfiguration();
    }

    public String toString() {
        return "{" + this.getClass().getSimpleName() + "} " + this.caller.toString() + " --[" + this.getText() + "]--> " + (this.callee == null ? "" : this.callee.toString());
    }

    public final int getThread() {
        return this.caller.getThread();
    }

    protected final void setArrow(Arrow arrow) {
        this.arrow = arrow;
    }

    public final Arrow getArrow() {
        return this.arrow;
    }

    public abstract void updateView();

    public final Diagram getDiagram() {
        return this.diagram;
    }

    public final Lifeline getCallee() {
        return this.callee;
    }

    public final Lifeline getCaller() {
        return this.caller;
    }

    public final MessageData getData() {
        return this.data;
    }

    public final Configuration getConfiguration() {
        return this.conf;
    }

    public boolean isSynchronous() {
        return !this.getCallee().isActiveObject() && !this.data.isSpawnMessage() && !this.getCaller().isAlwaysActive() && !this.getCallee().isAlwaysActive();
    }

    protected final void extendLifelines(int n) {
        this.diagram.extendLifelines(n);
    }

    public abstract String getText();

    protected final int v() {
        return this.diagram.getVerticalPosition();
    }
}

