/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.DestructorAnswer;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class ForwardMessage
extends Message {
    public ForwardMessage(Lifeline lifeline, Lifeline lifeline2, Diagram diagram, MessageData messageData) {
        super(lifeline, lifeline2, diagram, messageData);
    }

    public Answer getAnswerMessage() {
        if (this.getCallee().isAlwaysActive() || this.getData().isSpawnMessage() || this.getCallee().isActiveObject()) {
            return null;
        }
        if (this.getCaller().isAlwaysActive() && this.getData().returnsInstantly()) {
            return null;
        }
        if (this.getText().equals("destroy") || this.getText().startsWith("destroy(")) {
            return new DestructorAnswer(this.getCallee(), this.getCaller(), this.getDiagram(), this.getData(), this);
        }
        return new Answer(this.getCallee(), this.getCaller(), this.getDiagram(), this.getData(), this);
    }

    protected final boolean isActivating() {
        return !this.getData().returnsInstantly() || !this.getData().isSpawnMessage() && !this.getCaller().isAlwaysActive();
    }

    public void updateView() {
        if (!this.getCallee().isAlwaysActive()) {
            this.extendLifelines(this.getConfiguration().getSpaceBeforeActivation());
        }
        int n = Arrow.getInnerHeight(this);
        this.getDiagram().getPaintDevice().announce(n + this.diagram.arrowSize / 2);
        this.extendLifelines(n);
        if (!this.getCallee().isAlwaysActive() && this.isActivating()) {
            this.getCallee().setActive(true);
        }
        Arrow arrow = this.getCaller().getPosition() < this.getCallee().getPosition() ? new Arrow(this, ArrowStroke.SOLID, Direction.RIGHT, this.v() - n) : new Arrow(this, ArrowStroke.SOLID, Direction.LEFT, this.v() - n);
        this.setArrow(arrow);
        this.getDiagram().getPaintDevice().addSequenceElement(arrow);
    }

    public String getText() {
        return this.getData().getMessage();
    }
}

