/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.BroadcastArrow;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.util.Direction;

public class BroadcastMessage
extends ForwardMessage {
    private Lifeline[] otherCallees;
    public static final int FIRST = 1;
    public static final int OTHER = 2;
    public static final int LAST = 3;

    public BroadcastMessage(Lifeline lifeline, Lifeline lifeline2, Diagram diagram, MessageData messageData) {
        super(lifeline, lifeline2, diagram, messageData);
    }

    public Answer getAnswerMessage() {
        return null;
    }

    public void setOtherCallees(Lifeline[] lifelineArray) {
        this.otherCallees = lifelineArray;
    }

    public void updateView() {
        if (this.getData().getBroadcastType() == 1) {
            this.getDiagram().getPaintDevice().announce(this.getConfiguration().getSpaceBeforeActivation() + 3 + Arrow.getInnerHeight(this) + this.diagram.arrowSize / 2);
            this.extendLifelines(this.getConfiguration().getSpaceBeforeActivation() + 3);
        }
        BroadcastArrow broadcastArrow = this.getCaller().getPosition() < this.getCallee().getPosition() ? new BroadcastArrow(this, Direction.RIGHT, this.v()) : new BroadcastArrow(this, Direction.LEFT, this.v());
        this.setArrow(broadcastArrow);
        if (this.getData().getBroadcastType() == 3) {
            this.extendLifelines(broadcastArrow.getInnerHeight());
            for (Lifeline lifeline : this.otherCallees) {
                if (lifeline.isAlwaysActive() || !this.isActivating()) continue;
                lifeline.setActive(true);
            }
            if (!this.getCallee().isAlwaysActive() && this.isActivating()) {
                this.getCallee().setActive(true);
            }
        }
        this.getDiagram().getPaintDevice().addSequenceElement(broadcastArrow);
    }

    public boolean isSynchronous() {
        return false;
    }
}

