/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class Answer
extends Message {
    private final ForwardMessage forward;

    public Answer(Lifeline lifeline, Lifeline lifeline2, Diagram diagram, MessageData messageData, ForwardMessage forwardMessage) {
        super(lifeline, lifeline2, diagram, messageData);
        this.forward = forwardMessage;
    }

    public final ForwardMessage getForwardMessage() {
        return this.forward;
    }

    public void updateView() {
        this.getDiagram().getFragmentManager().finishFragmentsNotIncluding(this);
        if (this.getCallee().isAlwaysActive()) {
            return;
        }
        ArrowStroke arrowStroke = this.getText().equals("") && this.getCallee().isAlwaysActive() ? ArrowStroke.NONE : ArrowStroke.DASHED;
        this.getDiagram().getPaintDevice().announce(Arrow.getInnerHeight(this) + this.diagram.arrowSize / 2);
        Arrow arrow = this.getCaller().getPosition() < this.getCallee().getPosition() ? new Arrow(this, arrowStroke, Direction.RIGHT, this.v()) : new Arrow(this, arrowStroke, Direction.LEFT, this.v());
        arrow.setVisible(this.getText().length() > 0 || this.diagram.returnArrowVisible);
        this.setArrow(arrow);
        this.getDiagram().getPaintDevice().addSequenceElement(arrow);
        this.extendLifelines(arrow.getInnerHeight());
        if (!this.getCaller().isAlwaysActive()) {
            this.terminate();
        }
    }

    protected final void terminate() {
        this.getCaller().finish();
        if (this.getCaller().getRoot() != this.getCaller()) {
            this.getCaller().dispose();
        }
    }

    public String getText() {
        return this.getData().getAnswer();
    }
}

