/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor.apple;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.apple.AppInstaller;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;

class AppInstallerImpl
extends AppInstaller
implements ApplicationListener {
    private Editor editor;
    private UserInterfaceImpl ui;
    private File fileToLoad;

    AppInstallerImpl() {
    }

    void install(Editor editor) {
        this.editor = editor;
        this.ui = (UserInterfaceImpl)editor.getUI();
        Application application = Application.getApplication();
        if (application != null) {
            application.setEnabledPreferencesMenu(true);
            application.addApplicationListener((ApplicationListener)this);
        }
    }

    public File fileToLoad() {
        return this.fileToLoad;
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        this.ui.showAboutDialog(Editor.class.getResource("/net/sf/sdedit/about.html"));
        applicationEvent.setHandled(true);
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
        this.ui.configure(false);
        applicationEvent.setHandled(true);
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        this.editor.quit();
        applicationEvent.setHandled(false);
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(true);
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
        this.ui.toFront();
        applicationEvent.setHandled(true);
    }

    public void handleOpenFile(ApplicationEvent applicationEvent) {
        File file = new File(applicationEvent.getFilename());
        if (!this.editor.isSetup()) {
            this.fileToLoad = file;
        } else {
            try {
                this.editor.loadCode(file);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                this.ui.errorMessage("Cannot load " + file.getAbsolutePath() + "\n" + "due to an exception of type " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
            }
        }
        applicationEvent.setHandled(true);
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
        if (applicationEvent.getFilename() != null) {
            this.handleOpenFile(applicationEvent);
        }
    }
}

