/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import net.sf.sdedit.util.OS;

public class Shortcuts {
    public static final int CLEAR = 0;
    public static final int GLOBAL_CONFIGURATION = 1;
    public static final int DIAGRAM_CONFIGURATION = 2;
    public static final int HELP = 3;
    public static final int OPEN = 4;
    public static final int NEW = 5;
    public static final int CLOSE_ALL = 6;
    public static final int CLOSE = 7;
    public static final int QUIT = 8;
    public static final int SAVE = 9;
    public static final int SAVE_AS = 10;
    public static final int EXPORT_IMAGE = 11;
    public static final int WIDEN = 12;
    public static final int NARROW = 13;
    public static final int UNDO = 14;
    public static final int REDO = 15;
    public static final int FULL_SCREEN = 16;
    public static final int FILTER = 17;
    public static final int SPLIT_LEFT_RIGHT = 18;
    public static final int SPLIT_TOP_BOTTOM = 19;
    public static final int PRINT = 20;
    public static final int REDRAW = 21;
    public static final int EXPORT = 22;
    public static final int ENABLE_THREADS = 23;
    private static final int MAX = 23;
    private static final Shortcuts instance = new Shortcuts();
    private String[] shortcuts = new String[24];

    public static final String getShortcut(int n) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Shortcut key out of range: " + n);
        }
        String string = Shortcuts.instance.shortcuts[n];
        if (string == null) {
            throw new IllegalStateException("No shortcut defined for key " + n);
        }
        return "[" + string + "]";
    }

    private static final String ctrl(String string) {
        String string2 = OS.TYPE == OS.Type.MAC ? "meta" : "control";
        return string2 + " " + string;
    }

    private Shortcuts() {
        this.init();
        if (OS.TYPE == OS.Type.MAC) {
            this.initForMac();
        }
    }

    private void init() {
        this.shortcuts[0] = Shortcuts.ctrl("shift X");
        this.shortcuts[1] = Shortcuts.ctrl("shift G");
        this.shortcuts[2] = Shortcuts.ctrl("shift D");
        this.shortcuts[3] = "F1";
        this.shortcuts[4] = Shortcuts.ctrl("O");
        this.shortcuts[5] = Shortcuts.ctrl("T");
        this.shortcuts[6] = Shortcuts.ctrl("shift W");
        this.shortcuts[7] = Shortcuts.ctrl("W");
        this.shortcuts[8] = Shortcuts.ctrl("shift Q");
        this.shortcuts[9] = Shortcuts.ctrl("S");
        this.shortcuts[10] = Shortcuts.ctrl("shift S");
        this.shortcuts[11] = Shortcuts.ctrl("shift E");
        this.shortcuts[12] = Shortcuts.ctrl("shift K");
        this.shortcuts[13] = Shortcuts.ctrl("shift J");
        this.shortcuts[15] = Shortcuts.ctrl("Y");
        this.shortcuts[14] = Shortcuts.ctrl("Z");
        this.shortcuts[16] = "F9";
        this.shortcuts[17] = "F6";
        this.shortcuts[18] = "?";
        this.shortcuts[19] = "?";
        this.shortcuts[22] = Shortcuts.ctrl("shift E");
        this.shortcuts[20] = Shortcuts.ctrl("P");
        this.shortcuts[21] = "F5";
        this.shortcuts[23] = Shortcuts.ctrl("shift M");
    }

    private void initForMac() {
        this.shortcuts[15] = "meta shift Y";
        this.shortcuts[14] = "meta shift Z";
        this.shortcuts[8] = "meta q";
    }
}

