/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.util.Grep;

class ExportMapAction
extends AbstractAction {
    private Editor editor;
    private File directory;

    ExportMapAction(Editor editor) {
        this.editor = editor;
        this.putValue("Name", "Export &HTML map file");
        this.putValue("ShortDescription", "Create an HTML file with an image map for the diagram currently being displayed");
        this.putValue("SmallIcon", Icons.getIcon("map"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File[] fileArray;
        Diagram diagram = this.editor.getUI().getDiagram();
        if (diagram == null || diagram.getLifelines().isEmpty()) {
            return;
        }
        TextHandler textHandler = (TextHandler)diagram.getDataProvider();
        File file = this.editor.getUI().getCurrentFile();
        if (file == null) {
            this.editor.getUI().message("Please save the diagram as a file first.");
            return;
        }
        String string = file.getName();
        int n = Math.min(string.length(), string.lastIndexOf(46));
        string = file.getName().substring(0, n);
        if (this.directory == null) {
            this.directory = file.getParentFile();
        }
        if ((fileArray = this.editor.getUI().getFiles(false, false, "Export HTML map file", string + ".html", this.directory, "HTML files", "html")) != null && fileArray.length > 0) {
            this.directory = fileArray[0].getParentFile();
            if (!fileArray[0].exists() || 1 == this.editor.getUI().confirmOrCancel("Overwrite existing file:\n" + fileArray[0].getAbsolutePath() + "?")) {
                try {
                    this.generateMapFile(diagram, textHandler, string, fileArray[0]);
                }
                catch (IOException iOException) {
                    this.editor.getUI().errorMessage("The map file could not be saved due to an exception of type\n" + iOException.getClass().getSimpleName() + " with the message: " + iOException.getMessage());
                }
            }
        }
    }

    private void generateMapFile(Diagram diagram, TextHandler textHandler, String string, File file) throws IOException {
        String string2 = ConfigurationManager.getGlobalConfiguration().getFileEncoding();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.println("<!-- Generated by Quick Sequence Diagram Editor -->");
        printWriter.println("<!-- encoding: " + string2 + " -->");
        printWriter.println("<!-- You may append '#!href=\"<url>\"' to an object declaration\nin order to set the 'href' attribute of an AREA tag -->");
        printWriter.println("<map id=\"" + string + "\" name=\"" + string + "\">");
        for (Lifeline lifeline : diagram.getAllLifelines()) {
            String[] stringArray;
            String string3 = textHandler.getAnnotation(lifeline);
            String string4 = lifeline.getName();
            if (string3 != null && (stringArray = Grep.parse("^.*?href=\"(.*?)\".*$", string3)) != null) {
                string4 = stringArray[0];
            }
            stringArray = lifeline.getHead();
            int n = stringArray.getLeft();
            int n2 = stringArray.getTop();
            int n3 = stringArray.getRight();
            int n4 = stringArray.getBottom();
            String string5 = n + "," + n2 + "," + n3 + "," + n4;
            printWriter.println("  <area shape=\"rect\" coords=\"" + string5 + "\"" + " href=\"" + string4 + "\"/>");
        }
        printWriter.println("</map>");
        printWriter.flush();
        printWriter.close();
    }
}

