/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import net.sf.sdedit.Constants;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.Shortcuts;
import net.sf.sdedit.ui.PanelPaintDevice;
import net.sf.sdedit.ui.impl.LookAndFeelManager;
import org.freehep.util.export.ExportDialog;
import org.freehep.util.export.ExportDialogListener;

public class ExportAction
extends AbstractAction
implements ExportDialogListener,
Constants {
    private static final Set<String> vectorFormats = new HashSet<String>();
    private ExportDialog exportDialog;
    private Editor editor;
    private Properties properties;
    private PanelPaintDevice exportDevice;

    public ExportAction(Editor editor) {
        this.editor = editor;
        this.properties = new Properties();
        this.putValue("Name", Shortcuts.getShortcut(22) + "E&xport...");
        this.putValue("icon-name", "image");
        this.putValue("ShortDescription", "Export diagram as bitmap or vector graphics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Diagram diagram = this.editor.getUI().getDiagram();
        if (diagram == null) {
            return;
        }
        this.exportDevice = (PanelPaintDevice)diagram.getPaintDevice();
        if (this.exportDevice.isEmpty()) {
            return;
        }
        try {
            try {
                File file = this.editor.getUI().getCurrentFile();
                if (this.exportDialog == null) {
                    this.exportDialog = new ExportDialog("Quick Sequence Diagram Editor");
                    LookAndFeelManager.instance().registerOrphan(this.exportDialog);
                    this.exportDialog.setUserProperties(this.properties);
                    this.exportDialog.addExportDialogListener(this);
                    if (file != null) {
                        this.properties.setProperty("org.freehep.util.export.ExportDialog.SaveAsFile", file.getAbsolutePath());
                    }
                } else {
                    File file2;
                    String string = this.properties.getProperty("org.freehep.util.export.ExportDialog.SaveAsFile");
                    File file3 = file2 = string != null ? new File(string) : null;
                    if (file2 != null && file2.exists()) {
                        File file4 = file2.getParentFile();
                        file2 = file == null ? new File(file4, "untitled") : new File(file4, file.getName());
                        this.properties.setProperty("org.freehep.util.export.ExportDialog.SaveAsFile", file2.getAbsolutePath());
                    }
                }
                this.exportDialog.showExportDialog((Component)((Object)this.editor.getUI()), "Export via FreeHEP library (see http://www.freehep.org/vectorgraphics)", this.exportDevice.getPanel().asJComponent(), "untitled");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.editor.getUI().errorMessage("Cannot export due to an exception\nof type " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
                Object var8_9 = null;
                this.exportDevice.setAntialiasing(true);
            }
            Object var8_8 = null;
            this.exportDevice.setAntialiasing(true);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.exportDevice.setAntialiasing(true);
            throw throwable;
        }
    }

    public void writeFile(String string) {
        if (vectorFormats.contains(string)) {
            this.exportDevice.setAntialiasing(false);
        }
    }

    static {
        vectorFormats.add("pdf");
        vectorFormats.add("ps");
        vectorFormats.add("eps");
        vectorFormats.add("svg");
        vectorFormats.add("emf");
        vectorFormats.add("swf");
    }
}

