/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.LinkedList;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.error.FatalError;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.text.TextHandler;

final class Engine
extends Thread {
    private final Editor editor;
    private final LinkedList<Boolean> stack;

    private static final String getFatalErrorDescription(Throwable throwable) {
        return "A FATAL ERROR has occured: " + throwable.getClass().getSimpleName();
    }

    Engine(Editor editor) {
        this.editor = editor;
        this.setName("Diagram-Engine");
        this.setDaemon(true);
        this.stack = new LinkedList();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void render(Configuration configuration, boolean bl, boolean bl2) {
        if (bl2) {
            this._render(bl);
        } else {
            LinkedList<Boolean> linkedList = this.stack;
            synchronized (linkedList) {
                this.stack.addLast(bl);
                this.stack.notify();
            }
        }
    }

    private synchronized void _render(boolean bl) {
        this.editor.getUI().leaveFilterMode();
        Diagram diagram = this.editor.getUI().renderDiagram();
        if (diagram == null) {
            return;
        }
        DiagramError diagramError = this.editor.getUI().getDiagramError();
        if (diagramError == null) {
            int n;
            this.editor.getUI().setErrorStatus(false, "", -1, -1);
            if (diagram.getFragmentManager().openFragmentsExist()) {
                this.editor.getUI().setErrorStatus(true, "Warning: There are open comments. Use [c:<type> <text>]...[/c]", -1, -1);
            }
            if ((n = diagram.getNextFreeNoteNumber()) == 0) {
                this.editor.getUI().setStatus("");
            } else {
                this.editor.getUI().setStatus("Next note number: " + diagram.getNextFreeNoteNumber());
            }
        } else {
            this.editor.getUI().setStatus("");
            if (diagramError instanceof FatalError) {
                FatalError fatalError = (FatalError)diagramError;
                System.err.println("********************************************************");
                System.err.println("*                                                      *");
                System.err.println("*            A FATAL ERROR HAS OCCURED.                *");
                System.err.println("*                                                      *");
                System.err.println("********************************************************");
                diagramError.getCause().printStackTrace();
                try {
                    this.handle(diagram, fatalError.getCause());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else {
                TextHandler textHandler = (TextHandler)diagramError.getProvider();
                String string = "";
                if (diagramError instanceof SemanticError) {
                    string = diagram.isThreaded() && diagram.getCallerThread() != -1 ? "Thread " + diagram.getCallerThread() + ": " : "";
                }
                this.editor.getUI().setErrorStatus(false, string + diagramError.getMessage(), textHandler.getLineBegin() - 1, textHandler.getLineEnd());
            }
        }
        if (!bl) {
            this.editor.getUI().redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog(File file, Throwable throwable, TextHandler textHandler) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, ConfigurationManager.getGlobalConfiguration().getFileEncoding()));
            BufferedReader bufferedReader = new BufferedReader(new StringReader(textHandler.getText()));
            int n = textHandler.getLineNumber();
            printWriter.println(throwable.getClass().getSimpleName() + " has occurred in line " + n + "\n");
            int n2 = 0;
            while (true) {
                String string;
                if ((string = bufferedReader.readLine()) == null) break;
                string = string.trim();
                if (n2 == n - 1) {
                    string = ">>>>>>>>>>>>>> " + string;
                }
                printWriter.println(string);
                ++n2;
            }
            bufferedReader.close();
            printWriter.println("\n\n:::::::::::::::::::::::::::::\n\n");
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            this.editor.getUI().errorMessage(Engine.getFatalErrorDescription(throwable) + "\n\nAn error log file has been saved under \n" + file.getAbsolutePath() + "\n\n" + "Please send an e-mail with this file as an attachment to:\n" + "sdedit@users.sourceforge.net");
            Object var11_10 = null;
        }
        catch (Throwable throwable2) {
            Object var11_11 = null;
            fileOutputStream.close();
            throw throwable2;
        }
        fileOutputStream.close();
    }

    private void handle(Diagram diagram, RuntimeException runtimeException) {
        String string = "sdedit-errorlog-" + System.currentTimeMillis();
        File file = new File(string);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            try {
                file = new File(System.getProperty("user.home"), string);
                file.createNewFile();
            }
            catch (IOException iOException2) {
                file = new File(System.getProperty("java.io.tmpdir", string));
            }
        }
        try {
            this.saveLog(file, runtimeException, (TextHandler)diagram.getDataProvider());
        }
        catch (IOException iOException) {
            this.editor.getUI().errorMessage(Engine.getFatalErrorDescription(runtimeException) + "\n\nAn error log file could not be saved.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            boolean bl;
            LinkedList<Boolean> linkedList = this.stack;
            synchronized (linkedList) {
                while (this.stack.isEmpty()) {
                    try {
                        this.stack.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                bl = this.stack.removeLast();
                this.stack.clear();
            }
            this._render(bl);
        }
    }
}

