/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.GlobalConfiguration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Note;
import net.sf.sdedit.editor.Actions;
import net.sf.sdedit.editor.DiagramLoader;
import net.sf.sdedit.editor.Engine;
import net.sf.sdedit.editor.ExportMapAction;
import net.sf.sdedit.editor.Shortcuts;
import net.sf.sdedit.editor.apple.AppInstaller;
import net.sf.sdedit.server.RealtimeServer;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.ImagePaintDevice;
import net.sf.sdedit.ui.PanelPaintDeviceListener;
import net.sf.sdedit.ui.UserInterface;
import net.sf.sdedit.ui.UserInterfaceListener;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationAction;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Editor
implements Constants,
PanelPaintDeviceListener,
UserInterfaceListener {
    private GlobalConfiguration globalConfiguration;
    private UserInterface ui = this.newUI();
    private Actions actions;
    private Engine engine;
    private RealtimeServer server;
    private LinkedList<String> recentFiles;
    private LinkedList<Action> recentFileActions;
    private boolean setup = false;
    private static Editor instance;
    private boolean firstImageSaved = false;

    public static Editor getEditor() {
        if (instance == null) {
            instance = new Editor();
        }
        return instance;
    }

    private Editor() {
        File file;
        if (OS.TYPE == OS.Type.MAC) {
            AppInstaller.installApplication(this);
        }
        this.recentFiles = new LinkedList();
        this.recentFileActions = new LinkedList();
        this.globalConfiguration = ConfigurationManager.getGlobalConfiguration();
        this.ui.addListener(this);
        this.setupUI();
        this.readRecentFiles();
        this.engine = new Engine(this);
        if (this.globalConfiguration.isAutostartServer()) {
            try {
                this.startRealtimeServer(this.globalConfiguration.getRealtimeServerPort());
                this.ui.message("Started real-time diagram server @localhost:" + this.server.getPort());
            }
            catch (Exception exception) {
                this.ui.errorMessage("The real-time diagram server could not be started due to\nan exception of type " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
            }
        }
        this.setup = true;
        if (OS.TYPE == OS.Type.MAC && (file = AppInstaller.getFileToLoad()) != null) {
            try {
                this.loadCode(file);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                this.ui.errorMessage("Cannot load " + file.getAbsolutePath() + "\n" + "due to an exception of type " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
            }
        }
    }

    @Override
    public void currentTabClosing() {
        this.actions.closeDiagramAction.actionPerformed(null);
    }

    @Override
    public void hyperlinkClicked(String string) {
        if (string.startsWith("example:")) {
            String string2 = string.substring(string.indexOf(58) + 1);
            this.actions.getExampleAction(string2, string2).actionPerformed(null);
        } else if (string.startsWith("help:")) {
            int n = string.indexOf(58);
            int n2 = string.lastIndexOf(58);
            String string3 = string.substring(n + 1, n2);
            String string4 = string.substring(n2 + 1);
            this.ui.help(string3, "/net/sf/sdedit/help/" + string4, false);
        }
    }

    public void error(String string) {
        this.ui.errorMessage(string);
    }

    private void readRecentFiles() {
        String string = System.getProperty("path.separator");
        String string2 = this.globalConfiguration.getRecentFiles();
        if (string2 != null && !string2.equals("")) {
            int n = 0;
            for (String string3 : string2.split(string)) {
                if (!new File(string3).exists()) continue;
                ++n;
                this.recentFiles.add(string3);
                Action action = this.actions.getRecentFileAction(string3);
                this.recentFileActions.add(action);
                this.ui.addAction("&File.Open &recent file", action, null);
                if (n != this.globalConfiguration.getMaxNumOfRecentFiles()) continue;
                return;
            }
        }
    }

    public List<String> getRecentFiles() {
        return Collections.checkedList(this.recentFiles, String.class);
    }

    private void addToRecentFiles(String string) {
        Action action;
        int n = this.globalConfiguration.getMaxNumOfRecentFiles();
        if (n == 0) {
            return;
        }
        int n2 = this.recentFiles.indexOf(string);
        if (n2 >= 0) {
            this.recentFiles.remove(n2);
            action = this.recentFileActions.get(n2);
            this.recentFileActions.remove(n2);
        } else {
            action = this.actions.getRecentFileAction(string);
            this.ui.addAction("&File.Open &recent file", action, null);
            if (this.recentFiles.size() == n) {
                Action action2 = this.recentFileActions.removeLast();
                this.ui.removeAction("&File.Open &recent file", action2);
                this.recentFiles.removeLast();
            }
        }
        this.recentFiles.addFirst(string);
        this.recentFileActions.addFirst(action);
    }

    private void writeRecentFiles() {
        String string = System.getProperty("path.separator");
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : this.recentFiles) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        this.globalConfiguration.setRecentFiles(stringBuffer.toString());
    }

    public int startRealtimeServer(int n) throws IOException {
        if (this.isServerRunning()) {
            return 0;
        }
        this.server = new RealtimeServer(n, this);
        this.server.setDaemon(true);
        this.server.start();
        return this.server.getPort();
    }

    public boolean isServerRunning() {
        return this.server != null;
    }

    public void shutDownServer() {
        if (this.isServerRunning()) {
            this.server.shutDown();
            this.server = null;
        }
    }

    private void setupUI() {
        this.ui.setTitle("Quick Sequence Diagram Editor");
        this.addActions();
        this.ui.showUI();
        this.ui.addToolbarSeparator();
        this.ui.addToToolbar(this.actions.helpAction, null);
    }

    private void addActions() {
        this.actions = new Actions(this);
        this.ui.addAction("&File", this.actions.newDiagramAction, null);
        this.ui.addAction("&File", this.actions.loadCodeAction, null);
        this.ui.addCategory("&File.Open &recent file", "open");
        this.ui.addAction("&File", this.actions.saveCodeAction, this.actions.regularTabActivator);
        this.ui.addAction("&File", this.actions.saveCodeAsAction, this.actions.regularTabActivator);
        Action action = this.actions.getExportAction();
        if (action != null) {
            this.ui.addAction("&File", action, this.actions.nonEmptyDiagramActivator);
        } else {
            this.ui.addAction("&File", this.actions.saveImageAction, this.actions.nonEmptyDiagramActivator);
        }
        this.ui.addAction("&File", this.actions.closeDiagramAction, null);
        this.ui.addAction("&File", this.actions.closeAllAction, null);
        Action action2 = this.actions.getPrintAction("pdf");
        if (action2 != null) {
            this.ui.addAction("&File", action2, this.actions.noDiagramErrorActivator);
        }
        this.ui.addAction("&File", this.actions.quitAction, null);
        ConfigurationAction<Configuration> configurationAction = new ConfigurationAction<Configuration>("lineWrap", "[control shift W]&Wrap lines", "Wrap lines whose length exceed the width of the text area", "wrap"){

            @Override
            public Bean<Configuration> getBean() {
                return Editor.this.ui.getConfiguration();
            }
        };
        ConfigurationAction<Configuration> configurationAction2 = new ConfigurationAction<Configuration>("threaded", Shortcuts.getShortcut(23) + "Enable &multithreading", "Create diagrams with arbitrarily many sequences running concurrently", "threads"){

            @Override
            public Bean<Configuration> getBean() {
                return Editor.this.ui.getConfiguration();
            }
        };
        ConfigurationAction<GlobalConfiguration> configurationAction3 = new ConfigurationAction<GlobalConfiguration>("autoUpdate", "Auto-redraw", "Update diagram as you type", "reload"){

            @Override
            public Bean<GlobalConfiguration> getBean() {
                return ConfigurationManager.getGlobalConfigurationBean();
            }
        };
        ConfigurationAction<GlobalConfiguration> configurationAction4 = new ConfigurationAction<GlobalConfiguration>("autoScroll", "Auto-scrolling", "Scroll automatically to where the message currently being specified is visible", "autoscroll"){

            @Override
            public Bean<GlobalConfiguration> getBean() {
                return ConfigurationManager.getGlobalConfigurationBean();
            }
        };
        this.ui.addAction("&Edit", this.actions.undoAction, this.actions.regularTabActivator);
        this.ui.addAction("&Edit", this.actions.redoAction, this.actions.regularTabActivator);
        this.ui.addAction("&Edit", this.actions.clearAction, this.actions.regularTabActivator);
        this.ui.addConfigurationAction("&Edit", configurationAction2, this.actions.regularTabActivator);
        this.ui.addAction("&Edit", this.actions.configureGloballyAction, null);
        this.ui.addAction("&Edit", this.actions.configureDiagramAction, this.actions.regularTabActivator);
        this.ui.addCategory("&View", null);
        this.ui.addConfigurationAction("&View", configurationAction3, null);
        this.ui.addConfigurationAction("&View", configurationAction4, null);
        this.ui.addAction("&View", this.actions.redrawAction, this.actions.regularTabActivator);
        this.ui.addAction("&View", this.actions.widenAction, this.actions.canConfigureActivator);
        this.ui.addAction("&View", this.actions.narrowAction, this.actions.canNarrowActivator);
        this.ui.addConfigurationAction("&View", configurationAction, this.actions.regularTabActivator);
        this.ui.addAction("&View", this.actions.fullScreenAction, this.actions.nonEmptyDiagramActivator);
        this.ui.addAction("&View", this.actions.splitLeftRightAction, this.actions.horizontalSplitPossibleActivator);
        this.ui.addAction("&View", this.actions.splitTopBottomAction, this.actions.verticalSplitPossibleActivator);
        if (OS.TYPE != OS.Type.MAC) {
            this.ui.setQuitAction(this.actions.quitAction);
        }
        this.ui.addToToolbar(this.actions.newDiagramAction, null);
        this.ui.addToToolbar(this.actions.loadCodeAction, null);
        this.ui.addToToolbar(this.actions.saveCodeAction, this.actions.regularTabActivator);
        this.ui.addToToolbar(this.actions.saveCodeAsAction, this.actions.regularTabActivator);
        if (action != null) {
            this.ui.addToToolbar(action, this.actions.nonEmptyDiagramActivator);
        } else {
            this.ui.addToToolbar(this.actions.saveImageAction, this.actions.nonEmptyDiagramActivator);
        }
        if (action2 != null) {
            this.ui.addToToolbar(action2, this.actions.noDiagramErrorActivator);
        }
        this.ui.addToolbarSeparator();
        this.ui.addToToolbar(this.actions.configureGloballyAction, null);
        this.ui.addToToolbar(this.actions.configureDiagramAction, this.actions.regularTabActivator);
        this.ui.addToToolbar(this.actions.redrawAction, this.actions.regularTabActivator);
        this.ui.addToolbarSeparator();
        this.ui.addToToolbar(this.actions.fullScreenAction, this.actions.nonEmptyDiagramActivator);
        this.ui.addToToolbar(this.actions.splitLeftRightAction, this.actions.horizontalSplitPossibleActivator);
        this.ui.addToToolbar(this.actions.splitTopBottomAction, this.actions.verticalSplitPossibleActivator);
        this.ui.addAction("E&xtras", this.actions.serverAction, null);
        this.ui.addAction("E&xtras", this.actions.filterAction, this.actions.regularTabActivator);
        this.ui.addAction("E&xtras", new ExportMapAction(this), this.actions.nonEmptyDiagramActivator);
        this.ui.addAction("&Help", this.actions.helpAction, null);
        this.ui.addAction("&Help", this.actions.helpOnMultithreadingAction, null);
        this.ui.addAction("&Help", this.actions.asyncNotesAction, null);
        if (OS.TYPE != OS.Type.MAC) {
            this.ui.addAction("&Help", this.actions.showAboutDialogAction, null);
        }
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Ticket order", "order.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Breadth first search", "bfs.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Levels and mnemonics", "levels.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("SSH 2 (by courtesy of Carlos Duarte)", "ssh.sdx"), null);
        this.ui.addAction("&Help.&Examples", this.actions.getExampleAction("Webserver", "webserver.sdx"), null);
    }

    void loadCode() throws IOException, DocUtil.XMLException {
        File[] fileArray = this.ui.getFiles(true, true, "Open diagram file(s)", null, null, "Plain diagram source (.sd)", "sd", "Diagram source with preferences (.sdx)", "sdx");
        if (fileArray != null) {
            for (File file : fileArray) {
                this.loadCode(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCode(File file) throws IOException, DocUtil.XMLException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.loadCode(fileInputStream, file.getName());
            this.addToRecentFiles(file.getAbsolutePath());
            this.ui.setCurrentFile(file);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    public boolean isSetup() {
        return this.setup;
    }

    void loadCode(InputStream inputStream, String string) throws IOException, DocUtil.XMLException {
        String string2 = this.globalConfiguration.getFileEncoding();
        Pair<String, Bean<Configuration>> pair = DiagramLoader.load(inputStream, string2);
        this.ui.addTab(string, pair.getSecond());
        this.ui.setCode(pair.getFirst());
        this.ui.home();
    }

    public void quit() {
        if (this.closeAll()) {
            this.ui.exit();
            this.writeRecentFiles();
            try {
                ConfigurationManager.storeConfigurations();
            }
            catch (IOException iOException) {
                this.ui.errorMessage("Could not save the global settings file:\n" + GLOBAL_CONF_FILE.getAbsolutePath() + "\n" + "due to an exception of type\n" + iOException.getClass().getSimpleName() + "\n" + "with the message: " + iOException.getMessage());
                iOException.printStackTrace();
            }
            if (this.server != null) {
                this.server.shutDown();
            }
            System.exit(0);
        }
    }

    boolean closeAll() {
        boolean bl = false;
        do {
            if (bl || this.ui.isClean()) continue;
            String string = this.ui.getOption("<html>There are unsaved changes. Do you want<br>to save them?", "Cancel", "No", "::::Yes#", "No to all");
            if (string == null || string.equals("Cancel")) {
                return false;
            }
            if (string.equals("Yes")) {
                try {
                    if (!this.saveCode(false)) {
                        return false;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    this.ui.message("The diagram could not be stored due to an exception\nof type " + exception.getClass().getSimpleName() + " with the message: " + exception.getMessage());
                }
            }
            if (!string.equals("No to all")) continue;
            bl = true;
        } while (this.ui.removeCurrentTab(false));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCode(boolean bl) throws IOException, DocUtil.XMLException {
        Object object;
        Object object2;
        String string = this.ui.getCode().trim();
        Bean<Configuration> bean = this.ui.getConfiguration();
        boolean bl2 = bl || this.ui.getCurrentFile() == null;
        File file = null;
        if (bl2) {
            object2 = this.ui.getCurrentFile();
            if (object2 != null) {
                object = ((File)object2).getName();
                object2 = ((File)object2).getParentFile();
            } else {
                object = "untitled.sdx";
            }
            File[] fileArray = this.ui.getFiles(false, false, "Save diagram file", (String)object, (File)object2, "Plain diagram source (.sd)", "sd", "Diagram source with preferences (.sdx)", "sdx");
            if (fileArray != null) {
                file = fileArray[0];
            }
        } else {
            file = this.ui.getCurrentFile();
        }
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            if (bl2 && !((String)(object = this.ui.getOption("Overwrite existing file?", "Cancel", "No", "Yes#"))).equals("Yes")) {
                return false;
            }
            if (this.globalConfiguration.isBackupFiles()) {
                object = new File(file.getParent(), file.getName() + ".bak");
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                file.renameTo((File)object);
            }
        }
        bean = file.getName().toLowerCase().endsWith("sdx") ? bean : null;
        object = new FileOutputStream(file);
        object2 = this.globalConfiguration.getFileEncoding();
        try {
            DiagramLoader.saveDiagram(string, bean, (OutputStream)object, (String)object2);
            this.addToRecentFiles(file.getAbsolutePath());
            this.ui.setCurrentFile(file);
            this.ui.setClean();
            if (bl2) {
                this.ui.setTabTitle(file.getName());
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((OutputStream)object).close();
            throw throwable;
        }
        ((OutputStream)object).close();
        return true;
    }

    void saveImage() throws IOException {
        String string = this.getUI().getCode().trim();
        if (string.equals("")) {
            return;
        }
        ImagePaintDevice imagePaintDevice = new ImagePaintDevice();
        TextHandler textHandler = new TextHandler(string);
        Configuration configuration = this.getUI().getConfiguration().getDataObject();
        try {
            new Diagram(configuration, textHandler, imagePaintDevice).generate();
        }
        catch (Exception exception) {
            this.ui.errorMessage("The diagram source text has errors.");
            return;
        }
        Image image = imagePaintDevice.getImage();
        if (image != null) {
            File[] fileArray;
            File file;
            int n;
            File file2 = null;
            if (!this.firstImageSaved) {
                file2 = this.ui.getCurrentFile();
                if (file2 != null) {
                    file2 = file2.getParentFile();
                }
                this.firstImageSaved = true;
            }
            String string2 = null;
            if (this.ui.getCurrentFile() != null && (n = (string2 = this.ui.getCurrentFile().getName()).lastIndexOf(46)) >= 0) {
                string2 = string2.substring(0, n + 1) + "png";
            }
            File file3 = file = (fileArray = this.ui.getFiles(false, false, "save as PNG", string2, file2, "PNG image", "png")) != null ? fileArray[0] : null;
            if (!(file == null || file.exists() && 1 != this.ui.confirmOrCancel("Overwrite existing file " + file.getName() + "?"))) {
                imagePaintDevice.saveImage(file);
                this.ui.message("Exported image as\n" + file.getAbsolutePath());
            }
        }
    }

    @Override
    public void codeChanged(boolean bl) {
        this.ui.setErrorStatus(false, "", -1, -1);
        String string = this.ui.getCode();
        if (string != null && !string.trim().equals("")) {
            this.engine.render(this.ui.getConfiguration().getDataObject(), bl, false);
        } else {
            this.ui.clearDisplay();
        }
    }

    public UserInterface getUI() {
        return this.ui;
    }

    private UserInterface newUI() {
        return new UserInterfaceImpl();
    }

    @Override
    public void mouseClickedDrawable(Drawable drawable) {
        File file;
        File file2;
        URI uRI;
        Object object;
        Diagram diagram = this.ui.getDiagram();
        if (diagram != null && (object = (Integer)diagram.getStateForDrawable(drawable)) != null) {
            this.ui.moveCursorToPosition((Integer)object - 1);
        }
        if (drawable instanceof Note && (uRI = ((Note)(object = (Note)drawable)).getLink()) != null && !this.ui.selectTabWith(file2 = (file = this.ui.getCurrentFile()) != null ? new File(file.toURI().resolve(uRI)) : new File(uRI))) {
            try {
                this.loadCode(file2);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                this.ui.errorMessage(file2.getAbsolutePath() + "\n" + "could not be loaded due to an exception of\n" + "type " + exception.getClass().getSimpleName() + " with the message\n" + exception.getMessage());
            }
        }
    }

    @Override
    public boolean mouseEnteredDrawable(Drawable drawable) {
        Diagram diagram = this.ui.getDiagram();
        return diagram != null && diagram.getStateForDrawable(drawable) != null;
    }

    @Override
    public void mouseExitedDrawable(Drawable drawable) {
    }

    @Override
    public PanelPaintDeviceListener getPanelPaintDeviceListener() {
        return this;
    }
}

