/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.ExportAction;
import net.sf.sdedit.editor.Shortcuts;
import net.sf.sdedit.multipage.MultipageExporter;
import net.sf.sdedit.server.Exporter;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.configuration.Bean;

public final class Actions
implements Constants {
    public static final String ICON_NAME = "icon-name";
    private Editor editor;
    public final Activator canConfigureActivator = new Activator(){

        public boolean isEnabled() {
            return Actions.this.editor.getUI().getConfiguration() != null;
        }
    };
    public final Activator nonEmptyDiagramActivator = new Activator(){

        public boolean isEnabled() {
            return !Actions.this.editor.getUI().isDiagramBlank();
        }
    };
    public final Activator noDiagramErrorActivator = new Activator(){

        public boolean isEnabled() {
            return !Actions.this.editor.getUI().isDiagramBlank() && Actions.this.editor.getUI().getDiagramError() == null;
        }
    };
    public final Activator canNarrowActivator = new Activator(){

        public boolean isEnabled() {
            Bean<Configuration> bean = Actions.this.editor.getUI().getConfiguration();
            if (bean == null) {
                return false;
            }
            return bean.getDataObject().getGlue() > 0;
        }
    };
    public final Activator regularTabActivator = new Activator(){

        public boolean isEnabled() {
            return Actions.this.editor.getUI().isDiagramTabSelected();
        }
    };
    public final Activator verticalSplitPossibleActivator = new Activator(){

        public boolean isEnabled() {
            Bean<Configuration> bean = Actions.this.editor.getUI().getConfiguration();
            return bean != null && !bean.getDataObject().isVerticallySplit();
        }
    };
    public final Activator horizontalSplitPossibleActivator = new Activator(){

        public boolean isEnabled() {
            Bean<Configuration> bean = Actions.this.editor.getUI().getConfiguration();
            return bean != null && bean.getDataObject().isVerticallySplit();
        }
    };
    final Action clearAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "eraser");
            this.putValue("ShortDescription", "Erase the source code");
            this.putValue("Name", Shortcuts.getShortcut(0) + "&Erase code");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().setCode("");
            Actions.this.editor.codeChanged(false);
        }
    };
    final Action configureGloballyAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "globalsettings");
            this.putValue("ShortDescription", "Edit global preferences");
            this.putValue("Name", Shortcuts.getShortcut(1) + "&Global preferences...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().configure(false);
        }
    };
    final Action configureDiagramAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "configure");
            this.putValue("ShortDescription", "Edit diagram preferences");
            this.putValue("Name", Shortcuts.getShortcut(2) + "&Diagram preferences...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().configure(true);
        }
    };
    final Action helpAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "help");
            this.putValue("ShortDescription", "Display a comprehensive help page");
            this.putValue("Name", Shortcuts.getShortcut(3) + "&Help");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().help("Help", "/net/sf/sdedit/help/help.html", true);
        }
    };
    final Action helpOnMultithreadingAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "help");
            this.putValue("ShortDescription", "Show a help page dedicated to multithreading");
            this.putValue("Name", "&Multithreading help");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().help("Multithreading help", "/net/sf/sdedit/help/multithreading_help.html", false);
        }
    };
    final Action asyncNotesAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "help");
            this.putValue("ShortDescription", "Show a help page containing notes on asynchronous messages");
            this.putValue("Name", "&Notes on asynchronous messages");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().help("Notes on asynchronous messages", "/net/sf/sdedit/help/async.html", false);
        }
    };
    final Action loadCodeAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "open");
            this.putValue("Name", Shortcuts.getShortcut(4) + "&Open...");
            this.putValue("ShortDescription", "Load diagram");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Actions.this.editor.loadCode();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Actions.this.editor.error("Could not open the file due to an\nexception of type: " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
            }
        }
    };
    final Action newDiagramAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "new");
            this.putValue("Name", Shortcuts.getShortcut(5) + "&New diagram");
            this.putValue("ShortDescription", "Add a tab for a new diagram");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Bean<Configuration> bean = ConfigurationManager.createNewDefaultConfiguration();
            Actions.this.editor.getUI().addTab("untitled", bean);
        }
    };
    final Action closeAllAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "close");
            this.putValue("Name", Shortcuts.getShortcut(6) + "Close All");
            this.putValue("ShortDescription", "Close all tabs");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Actions.this.editor.closeAll()) {
                Actions.this.editor.getUI().addTab("untitled", ConfigurationManager.createNewDefaultConfiguration());
            }
        }
    };
    public final Action closeDiagramAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "close");
            this.putValue("Name", Shortcuts.getShortcut(7) + "&Close");
            this.putValue("ShortDescription", "Close the current tab");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (Actions.this.editor.getUI().getNumberOfTabs() <= 1) return;
            if (Actions.this.editor.getUI().isClean()) {
                Actions.this.editor.getUI().removeCurrentTab(false);
                return;
            } else {
                String string = Actions.this.editor.getUI().getOption("<html>There are unsaved changes.<br>Do you want to save them?", "Cancel", "No", "Yes#");
                if (string.equals("Yes")) {
                    try {
                        if (!Actions.this.editor.saveCode(false)) return;
                        Actions.this.editor.getUI().removeCurrentTab(true);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        Actions.this.editor.error(exception.getMessage());
                        return;
                    }
                } else {
                    if (!string.equals("No")) return;
                    Actions.this.editor.getUI().removeCurrentTab(true);
                }
            }
        }
    };
    final Action quitAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "exit");
            this.putValue("ShortDescription", "Quit the application");
            this.putValue("Name", Shortcuts.getShortcut(8) + "&Quit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.quit();
        }
    };
    final Action saveCodeAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "save");
            this.putValue("Name", Shortcuts.getShortcut(9) + "&Save");
            this.putValue("ShortDescription", "Save the diagram source code");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Actions.this.editor.saveCode(false);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Actions.this.editor.error(exception.getMessage());
            }
        }
    };
    final Action saveCodeAsAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "saveas");
            this.putValue("Name", Shortcuts.getShortcut(10) + "S&ave as...");
            this.putValue("ShortDescription", "Save the diagram source code as a new file");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Actions.this.editor.saveCode(true);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Actions.this.editor.error("Could not open the file due to an\nexception of type: " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
            }
        }
    };
    final Action saveImageAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "image");
            this.putValue("Name", Shortcuts.getShortcut(11) + "&Export as PNG...");
            this.putValue("ShortDescription", "Export the diagram as a PNG image");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Actions.this.editor.saveImage();
            }
            catch (IOException iOException) {
                Actions.this.editor.error(iOException.getMessage());
            }
        }
    };
    final Action redrawAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "reload");
            this.putValue("Name", Shortcuts.getShortcut(21) + "Re&draw");
            this.putValue("ShortDescription", "Redraw the diagram");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.codeChanged(false);
        }
    };
    final Action widenAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "widen");
            this.putValue("ShortDescription", "Widen the diagram");
            this.putValue("Name", Shortcuts.getShortcut(12) + "&Widen");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Configuration configuration = Actions.this.editor.getUI().getConfiguration().getDataObject();
            if (configuration != null) {
                configuration.setGlue(configuration.getGlue() + ConfigurationManager.getGlobalConfiguration().getGlueChangeAmount());
                Actions.this.editor.codeChanged(false);
            }
        }
    };
    final Action narrowAction = new AbstractAction(){
        {
            this.putValue(Actions.ICON_NAME, "narrow");
            this.putValue("ShortDescription", "Narrow the diagram");
            this.putValue("Name", Shortcuts.getShortcut(13) + "&Narrow");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Configuration configuration = Actions.this.editor.getUI().getConfiguration().getDataObject();
            if (configuration != null) {
                int n = Math.max(0, configuration.getGlue() - ConfigurationManager.getGlobalConfiguration().getGlueChangeAmount());
                configuration.setGlue(n);
                Actions.this.editor.codeChanged(false);
            }
        }
    };
    final Action redoAction = new AbstractAction("Redo"){
        {
            this.putValue("Name", Shortcuts.getShortcut(15) + "&Redo");
            this.putValue("ShortDescription", "Redo the typing that has most recently been undone");
            this.putValue(Actions.ICON_NAME, "redo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().redo();
        }
    };
    final Action undoAction = new AbstractAction("Undo"){
        {
            this.putValue("Name", Shortcuts.getShortcut(14) + "&Undo");
            this.putValue("ShortDescription", "Undo the typing that has most recently been done");
            this.putValue(Actions.ICON_NAME, "undo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().undo();
        }
    };
    final Action showAboutDialogAction = new AbstractAction(){
        {
            this.putValue("Name", "About");
            this.putValue(Actions.ICON_NAME, "help");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().showAboutDialog(Editor.class.getResource("/net/sf/sdedit/about.html"));
        }
    };
    final Action fullScreenAction = new AbstractAction(){
        {
            this.putValue("Name", Shortcuts.getShortcut(16) + "&Full screen");
            this.putValue(Actions.ICON_NAME, "fullscreen");
            this.putValue("ShortDescription", "Display the diagram in full-screen mode");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().fullScreen();
        }
    };
    final Action filterAction = new AbstractAction(){
        {
            this.putValue("Name", Shortcuts.getShortcut(17) + "&Filter...");
            this.putValue(Actions.ICON_NAME, "filter");
            this.putValue("ShortDescription", "Filter the (selected) text through a command");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().toggleFilterMode();
        }
    };
    final Action serverAction = new AbstractAction(){
        {
            this.putValue("Name", "Start/stop &RT server...");
            this.putValue(Actions.ICON_NAME, "server");
            this.putValue("ShortDescription", "Start or stop a server that receives diagram specifications through sockets");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Actions.this.editor.isServerRunning()) {
                if (Actions.this.editor.getUI().confirmOrCancel("Stop real-time diagram server?") == 1) {
                    Actions.this.editor.shutDownServer();
                }
                return;
            }
            String string = String.valueOf(ConfigurationManager.getGlobalConfiguration().getRealtimeServerPort());
            string = Actions.this.editor.getUI().getString("Enter the port where the real-time diagram\nserver should listen (0 for any free port):", string);
            if (string == null || string.equals("")) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                int n2 = Actions.this.editor.startRealtimeServer(n);
                ConfigurationManager.getGlobalConfiguration().setRealtimeServerPort(n);
                Actions.this.editor.getUI().message("Started real-time diagram server@localhost:" + n2);
            }
            catch (Exception exception) {
                Actions.this.editor.getUI().errorMessage("The real-time diagram server could not be started\ndue to an exception of type " + exception.getClass().getSimpleName() + " with the message:" + exception.getMessage());
            }
        }
    };
    final Action splitLeftRightAction = new AbstractAction(){
        {
            this.putValue("Name", Shortcuts.getShortcut(18) + "Split view left/right");
            this.putValue(Actions.ICON_NAME, "view_left_right");
            this.putValue("ShortDescription", "Split view left/right");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().layout(0);
        }
    };
    final Action splitTopBottomAction = new AbstractAction(){
        {
            this.putValue("Name", Shortcuts.getShortcut(19) + "Split view top/bottom");
            this.putValue(Actions.ICON_NAME, "view_top_bottom");
            this.putValue("ShortDescription", "Split view top/bottom");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Actions.this.editor.getUI().layout(1);
        }
    };

    Actions(Editor editor) {
        this.editor = editor;
    }

    final Action getExampleAction(final String string, final String string2) {
        return new AbstractAction(){
            {
                this.putValue("Name", string);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent actionEvent) {
                InputStream inputStream = null;
                URL uRL = this.getClass().getResource("/net/sf/sdedit/examples/" + string2);
                inputStream = uRL.openStream();
                Actions.this.editor.loadCode(inputStream, string2);
                Object var5_6 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
                {
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        Actions.this.editor.getUI().errorMessage("Loading example from classpath failed\ndue to an exception of type " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
                        Object var5_7 = null;
                        if (inputStream == null) return;
                        try {
                            inputStream.close();
                            return;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
            }
        };
    }

    final Action getRecentFileAction(final String string) {
        return new AbstractAction(){
            {
                this.putValue("Name", new File(string).getName());
                this.putValue("ShortDescription", new File(string).getAbsolutePath());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Actions.this.editor.loadCode(new File(string));
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    Actions.this.editor.error("Could not open the file due to an\nexception of type: " + exception.getClass().getSimpleName() + "\n" + "with the message: " + exception.getMessage());
                }
            }
        };
    }

    final Action getExportAction() {
        return Exporter.isAvailable() ? new ExportAction(this.editor) : null;
    }

    final Action getPrintAction(final String string) {
        if (!MultipageExporter.isAvailable()) {
            return null;
        }
        return new AbstractAction(){
            {
                this.putValue(Actions.ICON_NAME, string);
                this.putValue("ShortDescription", "Prints or exports the diagram in multi-page " + string.toUpperCase() + " format");
                this.putValue("Name", Shortcuts.getShortcut(20) + "&Print/export multi-page " + string.toUpperCase() + "...");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string2 = Actions.this.editor.getUI().getCode();
                if (string2 != null && string2.trim().length() > 0) {
                    Actions.this.editor.getUI().showPrintDialog(string);
                }
            }
        };
    }
}

