/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.util.Direction;

public abstract class SequenceElement
extends Drawable
implements Constants {
    private String[] label;
    private ExtensibleDrawable leftEndpoint;
    private ExtensibleDrawable leftLimit;
    private ExtensibleDrawable rightEndpoint;
    private ExtensibleDrawable rightLimit;
    protected final Diagram diagram;
    private Direction align;
    private int rightPadding;
    private int leftPadding;
    protected final Configuration configuration;

    protected SequenceElement(Diagram diagram, Lifeline lifeline, Lifeline lifeline2, String[] stringArray, Direction direction, int n) {
        this.setTop(n);
        this.align = direction;
        this.diagram = diagram;
        this.configuration = this.configuration();
        this.label = stringArray;
        this.findEndpoints(lifeline, lifeline2);
        this.computePadding();
    }

    protected final Diagram diagram() {
        return this.diagram;
    }

    protected final int rightPadding() {
        return this.rightPadding;
    }

    protected final int leftPadding() {
        return this.leftPadding;
    }

    protected final Configuration configuration() {
        return this.diagram.getConfiguration();
    }

    public final Direction getAlign() {
        return this.align;
    }

    private void computePadding() {
        Lifeline lifeline;
        Lifeline lifeline2;
        int n = this.diagram.mainLifelineWidth;
        int n2 = this.diagram.subLifelineWidth;
        Lifeline lifeline3 = this.leftEndpoint.getLifeline();
        this.leftPadding = lifeline3 != null ? (lifeline3 == (lifeline2 = lifeline3.getRightmost()) ? 0 : (lifeline2.getDirection() == Direction.CENTER ? n + (lifeline3.getSideLevel() - 1) * n2 : (lifeline3.getDirection() == Direction.LEFT ? n + (lifeline3.getSideLevel() - 1) * n2 + lifeline2.getSideLevel() * n2 : (lifeline2.getSideLevel() - lifeline3.getSideLevel()) * n2))) : 0;
        lifeline2 = this.rightEndpoint.getLifeline();
        this.rightPadding = lifeline2 != null ? (lifeline2 == (lifeline = lifeline2.getLeftmost()) ? 0 : (lifeline.getDirection() == Direction.CENTER ? n + (lifeline2.getSideLevel() - 1) * n2 : (lifeline2.getDirection() == Direction.RIGHT ? n + (lifeline2.getSideLevel() - 1) * n2 + lifeline.getSideLevel() * n2 : (lifeline.getSideLevel() - lifeline2.getSideLevel()) * n2))) : 0;
    }

    public int getSpace() {
        return 0;
    }

    public ExtensibleDrawable getLeftEndpoint() {
        return this.leftEndpoint;
    }

    public ExtensibleDrawable getRightEndpoint() {
        return this.rightEndpoint;
    }

    protected void setLeftEndpoint(ExtensibleDrawable extensibleDrawable) {
        this.leftEndpoint = extensibleDrawable;
    }

    protected void setRightEndpoint(ExtensibleDrawable extensibleDrawable) {
        this.rightEndpoint = extensibleDrawable;
    }

    protected int textWidth() {
        int n = 0;
        for (int i = 0; i < this.label.length; ++i) {
            n = Math.max(n, this.diagram().getPaintDevice().getTextWidth(this.label[i]));
        }
        return n;
    }

    protected int textHeight() {
        return this.diagram().getPaintDevice().getTextHeight() * this.label.length;
    }

    private void findEndpoints(Lifeline lifeline, Lifeline lifeline2) {
        if (lifeline2 == null) {
            if (lifeline.getDirection() == Direction.LEFT) {
                this.leftEndpoint = lifeline.getLeftNeighbour().getView();
                this.rightEndpoint = lifeline.getView();
            } else {
                this.leftEndpoint = lifeline.getView();
                this.rightEndpoint = lifeline.getPosition() < this.diagram.getNumberOfLifelines() - 1 ? lifeline.getRightNeighbour().getView() : this.diagram.getPaintDevice().getRightBound();
            }
        } else if (lifeline.getPosition() < lifeline2.getPosition()) {
            this.leftEndpoint = lifeline.getView();
            this.rightEndpoint = lifeline2.getView();
        } else {
            this.leftEndpoint = lifeline2.getView();
            this.rightEndpoint = lifeline.getView();
        }
    }

    protected void drawMultilineString(Graphics2D graphics2D, int n, int n2, boolean bl, Color color) {
        SequenceElement.drawMultilineString(graphics2D, this.label, n, n2, this.diagram().getPaintDevice().getTextHeight(), this.textWidth(), bl, color);
    }

    public final ExtensibleDrawable getLeftLimit() {
        return this.leftLimit;
    }

    public final void setLeftLimit(ExtensibleDrawable extensibleDrawable) {
        this.leftLimit = extensibleDrawable;
    }

    public final ExtensibleDrawable getRightLimit() {
        return this.rightLimit;
    }

    public final void setRightLimit(ExtensibleDrawable extensibleDrawable) {
        this.rightLimit = extensibleDrawable;
    }
}

