/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.ExtensibleDrawable;

public class Rectangle
extends ExtensibleDrawable {
    private final Color color;
    private final String thread = String.valueOf(this.getLifeline().getThread());
    private final Configuration configuration;

    public Rectangle(int n, Lifeline lifeline) {
        super(n, lifeline);
        int n2 = lifeline.getDiagram().getConfiguration().isColorizeThreads() ? lifeline.getDiagram().threadColors.length : 1;
        this.color = lifeline.isAlwaysActive() ? Color.WHITE : lifeline.getDiagram().threadColors[lifeline.getThread() % n2];
        this.configuration = lifeline.getDiagram().getConfiguration();
    }

    public final Color getColor() {
        return this.color;
    }

    public void draw(Graphics2D graphics2D) {
        this.drawPartially(graphics2D, -1, -1);
    }

    public void drawPartially(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4;
        if (n == -1) {
            n4 = this.getTop();
            n3 = this.getHeight();
        } else {
            n4 = Math.max(this.getTop(), n);
            int n5 = this.getHeight() - n4 + this.getTop();
            n3 = Math.min(n5, n2 - n);
        }
        graphics2D.setStroke(solid);
        graphics2D.setColor(this.color);
        graphics2D.fillRect(this.getLeft(), n4, this.getWidth(), n3);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.getLeft(), n4, this.getWidth(), n3);
        if (this.getLifeline().getDiagram().isThreaded() && !this.getLifeline().isAlwaysActive() && this.configuration.isThreadNumbersVisible()) {
            graphics2D.drawString(this.thread, this.getLeft() + 1, this.getTop() + 1 + graphics2D.getFontMetrics().getHeight());
        }
    }
}

