/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.util.Direction;

public class Note
extends SequenceElement {
    private int number;
    private int padding;
    private int margin;
    private List<Point> targets;
    private Point[] anchors;
    private Lifeline location;
    private boolean consuming;
    private URI link;

    public Note(Lifeline lifeline, int n, String[] stringArray, boolean bl) {
        super(lifeline.getDiagram(), lifeline, lifeline.getRightNeighbour(), stringArray, Direction.RIGHT, 0);
        this.number = n;
        this.consuming = bl;
        this.location = lifeline;
        this.padding = this.configuration().getNotePadding();
        this.margin = this.configuration().getNoteMargin();
        int n2 = this.textHeight();
        this.setHeight(this.margin * 2 + this.padding + n2);
        this.setWidth(this.margin * 2 + this.padding * 2 + this.leftPadding() + this.rightPadding() + this.textWidth());
        this.targets = new LinkedList<Point>();
    }

    public boolean isConsuming() {
        return this.consuming;
    }

    public int getNumber() {
        return this.number;
    }

    public void addTarget(Point point) {
        this.targets.add(point);
    }

    public Lifeline getLocation() {
        return this.location;
    }

    public void setLink(URI uRI) {
        this.link = uRI;
    }

    public URI getLink() {
        return this.link;
    }

    private int distance2(Point point, Point point2) {
        int n = Math.abs(point.x - point2.x);
        int n2 = Math.abs(point.y - point2.y);
        return n * n + n2 * n2;
    }

    private Point findStart(Point point) {
        Point point2 = null;
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.distance2(point, this.anchors[i]);
            if (n2 > n) continue;
            point2 = this.anchors[i];
            n = n2;
        }
        return point2;
    }

    public void computeLayoutInformation() {
        int n = this.getLeftEndpoint().getLeft() + this.getLeftEndpoint().getWidth();
        this.setLeft(n);
        this.anchors = new Point[4];
        this.anchors[0] = new Point(this.getLeft() + this.margin, this.getTop() + this.getHeight() / 2);
        this.anchors[1] = new Point(this.getLeft() + this.getWidth() / 2, this.getTop() + this.margin);
        this.anchors[2] = new Point(this.getLeft() + this.getWidth() / 2, this.getTop() + this.getHeight() - this.margin);
        this.anchors[3] = new Point(this.getLeft() + this.getWidth() - this.margin, this.getTop() + this.getHeight() / 2);
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(solid);
        int n = this.getLeft();
        int n2 = n + this.getWidth() - this.margin - this.padding;
        int n3 = this.getTop() + this.margin + this.padding;
        graphics2D.drawLine(n + this.margin, this.getTop() + this.margin, n2, this.getTop() + this.margin);
        graphics2D.drawLine(n + this.margin, this.getTop() + this.margin, n + this.margin, this.getTop() + this.getHeight() - this.margin);
        graphics2D.drawLine(n + this.margin, this.getTop() + this.getHeight() - this.margin, n + this.getWidth() - this.margin, this.getTop() + this.getHeight() - this.margin);
        graphics2D.drawLine(n + this.getWidth() - this.margin, this.getTop() + this.getHeight() - this.margin, n + this.getWidth() - this.margin, n3);
        graphics2D.drawLine(n2, n3, n2, this.getTop() + this.margin);
        graphics2D.drawLine(n2, n3, n + this.getWidth() - this.margin, n3);
        graphics2D.drawLine(n2, this.getTop() + this.margin, n + this.getWidth() - this.margin, n3);
        this.drawMultilineString(graphics2D, n + this.margin + this.padding, this.getTop() + this.getHeight() - this.margin - this.padding, false, null);
        for (Point point : this.targets) {
            Point point2 = this.findStart(point);
            graphics2D.setStroke(dotted);
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    public boolean intersects(Rectangle rectangle) {
        if (this.targets.isEmpty()) {
            return super.intersects(rectangle);
        }
        int n = this.getLeft();
        int n2 = n + this.getWidth();
        int n3 = this.getTop();
        int n4 = n3 + this.getHeight();
        for (Point point : this.targets) {
            n = Math.min(n, point.x);
            n2 = Math.max(n2, point.x);
            n3 = Math.min(n3, point.y);
            n4 = Math.max(n4, point.y);
        }
        return rectangle.intersects(n - 10, n3 - 10, n2 - n + 20, n4 - n3 + 20);
    }
}

