/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.message.AnswerToSelf;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class LoopArrow
extends Arrow {
    private boolean isAnswer;
    private int xExtent;
    private Drawable from;
    private Drawable to;
    private Point[] pts;
    private Point textPosition;

    public LoopArrow(Message message, ArrowStroke arrowStroke, Direction direction, int n) {
        super(message, arrowStroke, direction, n);
        this.init();
    }

    private void init() {
        Message message = this.getMessage();
        Configuration configuration = message.getConfiguration();
        this.xExtent = configuration.getSelfMessageHorizontalSpace();
        this.setWidth(this.diagram.messagePadding + this.xExtent + this.diagram.subLifelineWidth + this.textWidth());
        this.isAnswer = message instanceof AnswerToSelf;
        this.from = message.getCaller().getView();
        this.to = message.getCallee().getView();
        if (this.getAlign() == Direction.LEFT) {
            this.setLeftEndpoint(message.getCallee().getLeftNeighbour().getView());
            if (message.getCaller().getSideLevel() < message.getCallee().getSideLevel()) {
                this.setRightEndpoint(message.getCaller().getView());
            } else {
                this.setRightEndpoint(message.getCallee().getView());
            }
        } else {
            int n = message.getCallee().getPosition();
            if (n < message.getDiagram().getNumberOfLifelines() - 1 && message.getDiagram().getLifelineAt(n + 1).isAlive()) {
                this.setRightEndpoint(message.getCallee().getRightNeighbour().getView());
            } else {
                this.setRightEndpoint(message.getDiagram().getPaintDevice().getRightBound());
            }
            if (message.getCaller().getSideLevel() < message.getCallee().getSideLevel()) {
                this.setLeftEndpoint(message.getCaller().getView());
            } else {
                this.setLeftEndpoint(message.getCallee().getView());
            }
        }
    }

    public void draw(Graphics2D graphics2D) {
        int n = this.getMessage().getData().getThread();
        Color color = !this.configuration().isOpaqueMessageText() || n == -1 ? null : THREAD_COLORS[n];
        this.drawMultilineString(graphics2D, this.textPosition.x, this.textPosition.y, this.isAnswer, color);
        graphics2D.setColor(Color.BLACK);
        this.overrideColor(graphics2D);
        int n2 = this.getAlign() == Direction.RIGHT ? 1 : -1;
        graphics2D.setStroke(this.getStroke() == ArrowStroke.SOLID ? solid : dashed);
        graphics2D.drawLine(this.pts[0].x, this.pts[0].y, this.pts[1].x, this.pts[1].y);
        graphics2D.drawLine(this.pts[1].x, this.pts[1].y, this.pts[2].x, this.pts[2].y);
        graphics2D.drawLine(this.pts[2].x, this.pts[2].y, this.pts[3].x, this.pts[3].y);
        this.drawArrowHead(graphics2D, this.pts[3].x, this.pts[3].y, n2);
        graphics2D.setStroke(solid);
    }

    public int getInnerHeight() {
        return this.textHeight();
    }

    public Point[] getLinePoints() {
        return this.pts;
    }

    public Point getAnchor() {
        return this.pts[1];
    }

    public Point getTextPosition() {
        return this.textPosition;
    }

    public void computeLayoutInformation() {
        int n;
        int n2;
        int n3 = this.getTop() + this.textHeight();
        int n4 = this.getTop();
        if (this.getAlign() == Direction.RIGHT) {
            n2 = this.from.getLeft() + this.from.getWidth();
            n = this.to.getLeft() + this.to.getWidth();
            this.setLeft(Math.min(n2, n));
        } else {
            n2 = this.from.getLeft();
            n = this.to.getLeft();
            this.setLeft(Math.min(n2 - this.getWidth(), n - this.getWidth()));
        }
        int n5 = this.getAlign() == Direction.RIGHT ? Math.max(n + this.xExtent, n2 + this.xExtent) : Math.min(n - this.xExtent, n2 - this.xExtent);
        this.pts = new Point[4];
        this.pts[0] = new Point(n2, n4);
        this.pts[1] = new Point(n5, n4);
        this.pts[2] = new Point(n5, n3);
        this.pts[3] = new Point(n, n3);
        int n6 = this.getAlign() == Direction.RIGHT ? this.diagram.messagePadding : -this.textWidth() - this.diagram.messagePadding;
        int n7 = this.isAnswer ? n3 : n4 + this.textHeight();
        this.textPosition = new Point(n5 + n6, n7);
    }
}

