/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;

public class LabeledBox
extends Drawable {
    private String label;
    private boolean underlined;
    private boolean shouldDrawShadow;
    private int headWidth;
    private int headHeight;
    private int textWidth;
    private int padding;
    private Stroke stroke;
    private Lifeline lifeline;

    public LabeledBox(Lifeline lifeline, String string, int n, boolean bl, boolean bl2) {
        this.setTop(n);
        this.underlined = bl2;
        this.lifeline = lifeline;
        this.label = lifeline.isExternal() ? "" : (!string.equals("") ? string : (bl ? ":" + lifeline.getType() : lifeline.getName() + ":" + lifeline.getType()));
        Configuration configuration = lifeline.getDiagram().getConfiguration();
        this.headWidth = configuration.getHeadWidth();
        this.headHeight = configuration.getHeadHeight();
        this.padding = configuration.getHeadLabelPadding();
        this.textWidth = lifeline.getDiagram().getPaintDevice().getTextWidth(this.label);
        this.shouldDrawShadow = configuration.getShouldShadowParticipants();
        if (lifeline.isExternal()) {
            this.setWidth(lifeline.getDiagram().mainLifelineWidth);
        } else {
            this.setWidth(2 + Math.max(2 * this.padding + this.textWidth, this.headWidth));
        }
        this.stroke = lifeline.isAlwaysActive() ? thick : solid;
        this.setHeight(this.headHeight + 4);
    }

    public boolean isVisible() {
        return !this.lifeline.isExternal() && super.isVisible();
    }

    public void draw(Graphics2D graphics2D) {
        int n = this.getLeft() + this.getWidth() / 2;
        int n2 = this.getTop();
        int n3 = this.getWidth();
        graphics2D.setStroke(solid);
        if (this.shouldDrawShadow) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(n - n3 / 2 + 2, n2 + 2, n3 + 2, this.headHeight + 2);
        }
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(n - n3 / 2, n2, n3, this.headHeight);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(this.stroke);
        graphics2D.drawRect(n - n3 / 2, n2, n3, this.headHeight);
        graphics2D.setStroke(solid);
        int n4 = n - this.textWidth / 2;
        int n5 = n2 + this.headHeight / 2;
        if (this.underlined) {
            graphics2D.drawLine(n4, n5 + 2, n4 + this.textWidth, n5 + 2);
        }
        graphics2D.drawString(this.label, n4, n5);
    }

    public void computeLayoutInformation() {
    }
}

