/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.message.ConstructorMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Pair;

public class Fragment
extends Drawable {
    private String type;
    private String condition;
    private Diagram diagram;
    private Set<SequenceElement> includedElements;
    private int typeTextPadding;
    private int level;
    private List<Pair<Integer, String>> separators;

    public Fragment(String string, String string2, Diagram diagram) {
        if (string.equals("")) {
            this.type = string2 + "  ";
            this.condition = "";
        } else {
            this.type = string + "  ";
            this.condition = string2.equals("") ? "" : "[" + string2 + "]";
        }
        this.diagram = diagram;
        this.includedElements = new HashSet<SequenceElement>();
        this.typeTextPadding = diagram.getConfiguration().getFragmentTextPadding();
        this.level = 0;
        this.separators = new LinkedList<Pair<Integer, String>>();
    }

    public void setLevel(int n) {
        this.level = Math.max(this.level, n);
    }

    public String getCondition() {
        return this.condition;
    }

    public void addElement(SequenceElement sequenceElement) {
        this.includedElements.add(sequenceElement);
    }

    public void addSection(String string) {
        int n = this.diagram.getPaintDevice().getTextHeight(true);
        this.diagram.extendLifelines(this.diagram.getConfiguration().getSeparatorTopMargin());
        this.separators.add(new Pair<Integer, String>(this.diagram.getVerticalPosition(), string));
        this.diagram.extendLifelines(n + this.diagram.getConfiguration().getSeparatorBottomMargin() + 5);
    }

    public boolean containsElement(SequenceElement sequenceElement) {
        return this.includedElements.contains(sequenceElement);
    }

    public void computeLayoutInformation() {
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (SequenceElement sequenceElement : this.includedElements) {
            n = sequenceElement.getLeft();
            int n4 = sequenceElement.getLeft() + sequenceElement.getWidth();
            if (sequenceElement instanceof Arrow) {
                Message message = ((Arrow)sequenceElement).getMessage();
                if (message instanceof ConstructorMessage) {
                    if (message.getCallee().getPosition() < message.getCaller().getPosition()) {
                        n = message.getCallee().getHead().getLeft();
                    } else {
                        n4 = message.getCallee().getHead().getLeft() + message.getCallee().getHead().getWidth();
                    }
                }
                if (((Arrow)sequenceElement).getStroke() != ArrowStroke.NONE) {
                    n4 += sequenceElement.getRightEndpoint().getWidth();
                }
            }
            n2 = Math.min(n2, n);
            n3 = Math.max(n3, n4);
        }
        int n5 = n3 - n2;
        int n6 = this.diagram.getConfiguration().getFragmentPadding();
        n = this.diagram.getConfiguration().getFragmentMargin();
        this.setLeft(n2 - n6 - this.level * n6);
        this.setWidth(2 * this.level * n6 + n5 + 2 * n6 + n);
    }

    public int getLabelHeight() {
        return this.diagram.getPaintDevice().getTextHeight(true) + 2;
    }

    public void draw(Graphics2D graphics2D) {
        int n = this.diagram.getPaintDevice().getTextWidth(this.type, true);
        int n2 = this.diagram.getPaintDevice().getTextWidth(this.condition, true);
        int n3 = this.diagram.getPaintDevice().getTextHeight(true);
        int n4 = n + 4 + this.typeTextPadding;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.getLeft(), this.getTop(), n + 4, n3 + 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(thick);
        graphics2D.setFont(this.diagram.getPaintDevice().getFont(true));
        graphics2D.drawRect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        if (!this.type.equals("")) {
            graphics2D.drawLine(this.getLeft(), this.getTop() + n3 + 2, this.getLeft() + n + this.typeTextPadding, this.getTop() + n3 + 2);
            graphics2D.drawLine(this.getLeft() + n + this.typeTextPadding, this.getTop() + n3 + 2, this.getLeft() + n + this.typeTextPadding + 2, this.getTop() + n3 - 2);
            graphics2D.drawLine(this.getLeft() + n + this.typeTextPadding + 2, this.getTop() + n3 - 2, this.getLeft() + n + this.typeTextPadding + 2, this.getTop());
            graphics2D.drawString(this.type, this.getLeft() + this.typeTextPadding, this.getTop() + n3 - 1);
        }
        if (this.condition.length() > 0) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(this.getLeft() + n4, this.getTop() + n3 + 2, n2, n3);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(this.condition, this.getLeft() + n4, this.getTop() + 2 * n3 - 1);
        }
        for (Pair<Integer, String> pair : this.separators) {
            int n5 = pair.getFirst();
            graphics2D.setStroke(thick_dashed);
            graphics2D.drawLine(this.getLeft(), n5, this.getRight(), n5);
            graphics2D.setStroke(solid);
            graphics2D.drawString(pair.getSecond(), this.getLeft() + n4, n5 + n3 + this.diagram.getConfiguration().getSeparatorBottomMargin());
        }
        graphics2D.setFont(this.diagram.getPaintDevice().getFont(false));
    }
}

