/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;

public class Figure
extends Drawable {
    private String label;
    private int textHeight;
    private int textWidth;
    private boolean underline;
    private int actorHeight;
    private int actorWidth;

    public Figure(Lifeline lifeline, String string, int n, boolean bl) {
        this.setTop(n);
        this.label = !string.equals("") ? string : lifeline.getName();
        this.underline = bl;
        this.textHeight = lifeline.getDiagram().getPaintDevice().getTextHeight();
        this.textWidth = lifeline.getDiagram().getPaintDevice().getTextWidth(this.label);
        int n2 = Math.max(lifeline.getDiagram().getConfiguration().getActorWidth(), this.textWidth);
        this.setWidth(n2);
        this.actorHeight = lifeline.getDiagram().getConfiguration().getHeadHeight();
        this.setHeight(this.textHeight + this.actorHeight + 3);
        this.actorWidth = lifeline.getDiagram().getConfiguration().getActorWidth();
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setStroke(solid);
        this.renderActor(graphics2D, this.getTop(), this.getTop() + this.actorHeight - 2, this.getLeft() + this.getWidth() / 2, this.actorWidth);
        graphics2D.drawString(this.label, this.getLeft() + this.getWidth() / 2 - this.textWidth / 2, this.getTop() + this.getHeight() - 3);
        if (this.underline) {
            graphics2D.drawLine(this.getLeft() + this.getWidth() / 2 - this.textWidth / 2, this.getTop() + this.getHeight() - 2, this.getLeft() + this.getWidth() / 2 + this.textWidth / 2, this.getTop() + this.getHeight() - 2);
        }
    }

    private void renderActor(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = 4;
        int n6 = 4;
        int n7 = n3 - n4 / 2;
        int n8 = n3 + n4 / 2;
        int n9 = n2 - n;
        int n10 = (int)((float)n9 * 0.4f);
        int n11 = (int)((float)n9 * 0.3f);
        int n12 = (int)((float)n9 * 0.6f);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillOval(n3 - n11 / 2 + n5, n + n5, n11, n11);
        graphics2D.setStroke(new BasicStroke(n6));
        graphics2D.drawLine(n3 + n5, n + n11, n3 + n5, n + n12);
        graphics2D.drawLine(n7 + n5, n + n10 + n5, n8 + n5, n + n10 + n5);
        graphics2D.drawLine(n3 + n5, n + n12 + n5, n7 + n5, n2 + n5);
        graphics2D.drawLine(n3 + (int)(1.5 * (double)n5), n + n12 + n5, n8 + (int)(1.5 * (double)n5) - 1, n2 + 1);
        graphics2D.setStroke(solid);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillOval(n3 - n11 / 2, n, n11, n11);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawOval(n3 - n11 / 2, n, n11, n11);
        Polygon polygon = new Polygon();
        polygon.addPoint(n3 - n6 / 2, n + n11);
        polygon.addPoint(n3 - n6 / 2, n + n10);
        polygon.addPoint(n7, n + n10);
        polygon.addPoint(n7, n + n10 + n6);
        polygon.addPoint(n3 - n6 / 2, n + n10 + n6);
        polygon.addPoint(n3 - n6 / 2, n + n12);
        polygon.addPoint(n7, n2);
        polygon.addPoint(n7 + n6, n2 + n6);
        polygon.addPoint(n3, n + n12 + n6);
        polygon.addPoint(n8, n2 + n6);
        polygon.addPoint(n8 + n6, n2);
        polygon.addPoint(n3 + n6 / 2, n + n12);
        polygon.addPoint(n3 + n6 / 2, n + n10 + n6);
        polygon.addPoint(n8 + n6, n + n10 + n6);
        polygon.addPoint(n8 + n6, n + n10);
        polygon.addPoint(n3 + n6 / 2, n + n10);
        polygon.addPoint(n3 + n6 / 2, n + n11);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillPolygon(polygon);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawPolygon(polygon);
    }

    public void computeLayoutInformation() {
    }
}

