/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.sf.sdedit.Constants;

public abstract class Drawable
implements Constants {
    private int top;
    private int left;
    private int height;
    private int width;
    private boolean visible = true;

    protected Drawable() {
    }

    public abstract void draw(Graphics2D var1);

    public abstract void computeLayoutInformation();

    public final int getTop() {
        return this.top;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final void setLeft(int n) {
        this.left = n;
    }

    public final void setTop(int n) {
        this.top = n;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getBottom() {
        return this.top + this.height;
    }

    public final int getRight() {
        return this.left + this.width;
    }

    public final void setRight(int n) {
        this.setWidth(n - this.left);
    }

    public final void setBottom(int n) {
        this.setHeight(n - this.getTop());
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.left - 10, this.top - 10, this.width + 20, this.height + 20);
    }

    public boolean contains(Point point) {
        int n = point.x;
        int n2 = point.y;
        return n >= this.left && n <= this.left + this.width && n2 >= this.top && n2 <= this.top + this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected static final void drawMultilineString(Graphics2D graphics2D, String[] stringArray, int n, int n2, int n3, int n4, boolean bl, Color color) {
        int n5;
        int n6;
        bl = true;
        if (color != null) {
            graphics2D.setColor(color);
            n6 = 2 + stringArray.length * n3;
            n5 = bl ? n2 - n6 + 2 : n2 + 2;
            graphics2D.fillRect(n - 1, n5, n4, n6);
        }
        graphics2D.setColor(Color.BLACK);
        if (bl) {
            for (n6 = 0; n6 < stringArray.length; ++n6) {
                n5 = n2 - n6 * n3;
                graphics2D.drawString(stringArray[stringArray.length - 1 - n6], n, n5);
            }
        } else {
            for (n6 = 0; n6 < stringArray.length; ++n6) {
                n5 = n2 + n6 * n3;
                graphics2D.drawString(stringArray[n6], n, n5);
            }
        }
    }
}

