/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;

public class Cross
extends Drawable {
    private Point[] pts;

    public Cross(Lifeline lifeline) {
        this.setWidth(lifeline.getDiagram().getConfiguration().getDestructorWidth());
        this.setHeight(this.getWidth());
    }

    public Point[] getPoints() {
        return this.pts;
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setStroke(thick);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(this.pts[0].x, this.pts[0].y, this.pts[1].x, this.pts[1].y);
        graphics2D.drawLine(this.pts[2].x, this.pts[2].y, this.pts[3].x, this.pts[3].y);
        graphics2D.setStroke(solid);
    }

    public void computeLayoutInformation() {
        int n = this.getLeft();
        int n2 = this.getTop();
        int n3 = this.getWidth();
        this.pts = new Point[4];
        this.pts[0] = new Point(n, n2 - n3 / 2 + 3);
        this.pts[1] = new Point(n + n3, n2 + n3 / 2 + 3);
        this.pts[2] = new Point(n, n2 + n3 / 2 + 3);
        this.pts[3] = new Point(n + n3, n2 - n3 / 2 + 3);
    }
}

