/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class BroadcastArrow
extends Arrow {
    public BroadcastArrow(Message message, Direction direction, int n) {
        super(message, ArrowStroke.SOLID, direction, n);
    }

    public void draw(Graphics2D graphics2D) {
        int n;
        ArrowStroke arrowStroke = this.getStroke();
        Point[] pointArray = this.getPoints();
        if (this.getMessage().getData().getBroadcastType() == 1) {
            this.drawText(graphics2D);
        }
        graphics2D.setColor(Color.BLACK);
        this.overrideColor(graphics2D);
        int n2 = n = this.getAlign() == Direction.LEFT ? 1 : -1;
        if (arrowStroke != ArrowStroke.NONE) {
            graphics2D.setStroke(arrowStroke == ArrowStroke.DASHED ? dashed : solid);
            graphics2D.drawLine(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y);
            graphics2D.setStroke(solid);
            this.drawArrowHead(graphics2D, pointArray[1].x, pointArray[1].y, n);
        }
        if (this.getMessage().getData().getBroadcastType() == 1) {
            int n3 = this.getMessage().getCaller().getRoot() == this.getMessage().getCaller() ? this.diagram.mainLifelineWidth : this.diagram.subLifelineWidth;
            int n4 = pointArray[0].x + n * n3 / 2;
            int n5 = pointArray[0].y;
            graphics2D.drawArc(n4 - 6, n5 - 4, 12, 6, 0, 180);
            graphics2D.drawArc(n4 - 8, n5 - 9, 16, 6, 0, 180);
            graphics2D.drawArc(n4 - 10, n5 - 14, 20, 6, 0, 180);
        }
    }
}

