/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.ArrowHeadType;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.message.BroadcastMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class Arrow
extends SequenceElement {
    private final ArrowStroke stroke;
    private final ArrowHeadType headType;
    private Message message;
    private int space;
    private Point[] pts;
    private Point textPoint;

    protected Arrow(Message message, Lifeline lifeline, Lifeline lifeline2, ArrowStroke arrowStroke, Direction direction, int n) {
        super(message.getDiagram(), lifeline, lifeline2, message.getText().split("\\\\n"), direction, n);
        int n2;
        this.message = message;
        this.stroke = arrowStroke;
        if (arrowStroke != ArrowStroke.NONE) {
            n2 = this.diagram.arrowSize;
            this.headType = message instanceof BroadcastMessage ? ArrowHeadType.ROUNDED : (message.isSynchronous() ? ArrowHeadType.CLOSED : ArrowHeadType.OPEN);
        } else {
            this.headType = ArrowHeadType.CLOSED;
            n2 = 0;
        }
        int n3 = this.textHeight();
        this.setHeight(n3 + this.configuration().getMessageLabelSpace() + this.diagram.arrowSize / 2);
        this.setWidth(n2 + this.leftPadding() + this.rightPadding() + this.diagram.messagePadding + this.textWidth());
    }

    public Arrow(Message message, ArrowStroke arrowStroke, Direction direction, int n) {
        this(message, message.getCaller(), message.getCallee(), arrowStroke, direction, n);
    }

    public final Point[] getPoints() {
        return this.pts;
    }

    public Point getTextPosition() {
        return this.textPoint;
    }

    public int getInnerHeight() {
        return this.textHeight() + this.diagram.messageLabelSpace;
    }

    public static int getInnerHeight(Message message) {
        int n = message.getText().split("\\\\n").length;
        return message.getDiagram().getPaintDevice().getTextHeight() * n + message.getDiagram().getConfiguration().getMessageLabelSpace();
    }

    public final int getSpace() {
        return this.space;
    }

    public final void setSpace(int n) {
        this.space = n;
    }

    protected void overrideColor(Graphics2D graphics2D) {
        Color color;
        String string = this.message.getData().getProperty("colour");
        if (string != null && (color = this.diagram.getPaintDevice().getColor(string)) != null) {
            graphics2D.setColor(color);
        }
    }

    public void draw(Graphics2D graphics2D) {
        int n;
        this.drawText(graphics2D);
        graphics2D.setColor(Color.BLACK);
        this.overrideColor(graphics2D);
        int n2 = n = this.getAlign() == Direction.LEFT ? 1 : -1;
        if (this.stroke != ArrowStroke.NONE) {
            graphics2D.setStroke(this.stroke == ArrowStroke.DASHED ? dashed : solid);
            graphics2D.drawLine(this.pts[0].x, this.pts[0].y, this.pts[1].x, this.pts[1].y);
            graphics2D.setStroke(solid);
            this.drawArrowHead(graphics2D, this.pts[1].x, this.pts[1].y, n);
            if (this.message.getCaller().isExternal()) {
                int n3 = this.diagram.arrowSize;
                int n4 = n == -1 ? n3 : 0;
                graphics2D.fillOval(this.pts[0].x - n4, this.pts[0].y - n3 / 2, n3, n3);
            }
        }
    }

    protected void drawText(Graphics2D graphics2D) {
        int n = this.getMessage().getData().getThread();
        Color color = this.getMessage().getData().getMessage().length() == 0 || !this.configuration().isOpaqueMessageText() || n == -1 ? null : THREAD_COLORS[n];
        this.drawMultilineString(graphics2D, this.textPoint.x, this.textPoint.y, true, color);
    }

    public Point getAnchor() {
        return new Point(this.pts[0].x + (this.pts[1].x - this.pts[0].x) / 2, this.pts[0].y);
    }

    public void computeLayoutInformation() {
        int n = this.getLeftEndpoint().getLeft() + this.getLeftEndpoint().getWidth();
        int n2 = this.getRightEndpoint().getLeft();
        Direction direction = this.getAlign();
        if (direction == Direction.LEFT) {
            n += this.space;
        } else {
            n2 -= this.space;
        }
        this.setLeft(n);
        this.setWidth(Math.max(this.getWidth(), n2 - n));
        int n3 = direction == Direction.LEFT ? this.getLeft() + this.getWidth() : this.getLeft();
        int n4 = direction == Direction.LEFT ? this.getLeft() : this.getLeft() + this.getWidth();
        int n5 = direction == Direction.LEFT ? 1 : -1;
        int n6 = n5 == 1 ? n3 - this.diagram.messagePadding - this.textWidth() - this.rightPadding() : n3 + this.diagram.messagePadding + this.leftPadding();
        int n7 = this.getTop() + this.textHeight() + this.diagram.messageLabelSpace;
        this.pts = new Point[2];
        this.pts[0] = new Point(n3, n7);
        this.pts[1] = new Point(n4, n7);
        this.textPoint = new Point(n6, n7 - this.diagram.messageLabelSpace);
    }

    protected final void drawArrowHead(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setStroke(solid);
        int n4 = this.diagram.arrowSize;
        switch (this.headType) {
            case CLOSED: {
                Polygon polygon = new Polygon(new int[]{n, n + n3 * n4, n + n3 * n4, n}, new int[]{n2, n2 - n4, n2 + n4, n2}, 4);
                graphics2D.fillPolygon(polygon);
                break;
            }
            case OPEN: {
                graphics2D.drawLine(n, n2, n + n3 * n4, n2 - n4);
                graphics2D.drawLine(n, n2, n + n3 * n4, n2 + n4);
                break;
            }
            case ROUNDED: {
                int n5 = n3 == -1 ? n - 2 * n4 : n;
                int n6 = n2 - n4;
                graphics2D.fillArc(n5, n6, n4 * 2, n4 * 2, 90, n3 * 180);
            }
        }
    }

    public final Message getMessage() {
        return this.message;
    }

    protected final ArrowStroke getStroke() {
        return this.stroke;
    }
}

