/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.Line;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.util.Direction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PaintDevice
implements Iterable<Drawable> {
    private static Map<String, Color> colorMap = new HashMap<String, Color>();
    private int height = 0;
    private final ArrayList<Set<SequenceElement>> leftOf = new ArrayList();
    private final List<Drawable> other = new LinkedList<Drawable>();
    private Diagram diagram;
    private final Line rightBound = new Line(1, null);
    private Font plainFont;
    private Font boldFont;

    protected PaintDevice() {
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        this.plainFont = diagram.getConfiguration().getFont();
        this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize() + 1);
    }

    public Color getColor(String string) {
        return colorMap.get(string.toUpperCase());
    }

    public void reinitialize() {
        this.leftOf.clear();
        this.other.clear();
        this.rightBound.setLeft(0);
        this.height = 0;
        for (int i = 0; i < this.diagram.getNumberOfLifelines(); ++i) {
            this.leftOf.add(new HashSet());
        }
    }

    public Font getFont(boolean bl) {
        return bl ? this.boldFont : this.plainFont;
    }

    public Line getRightBound() {
        return this.rightBound;
    }

    public void addOtherDrawable(Drawable drawable) {
        this.other.add(drawable);
        if (drawable.getRight() > this.rightBound.getLeft()) {
            this.rightBound.setLeft(drawable.getRight());
        }
        if (drawable.getBottom() > this.height) {
            this.height = drawable.getBottom();
        }
    }

    public void addSequenceElement(SequenceElement sequenceElement) {
        ExtensibleDrawable extensibleDrawable;
        ExtensibleDrawable extensibleDrawable2;
        int n;
        if (sequenceElement.getAlign() == Direction.RIGHT) {
            n = sequenceElement.getLeftEndpoint().getLifeline().getPosition();
            extensibleDrawable2 = sequenceElement.getLeftEndpoint().getLifeline().getRightmost().getView();
            extensibleDrawable = n == this.diagram.getNumberOfLifelines() - 1 ? this.rightBound : this.diagram.getLifelineAt(n + 1).getLeftmost().getView();
        } else {
            n = sequenceElement.getRightEndpoint().getLifeline().getPosition() - 1;
            extensibleDrawable = sequenceElement.getRightEndpoint().getLifeline().getLeftmost().getView();
            extensibleDrawable2 = this.diagram.getLifelineAt(n).getRightmost().getView();
        }
        this.leftOf.get(n).add(sequenceElement);
        sequenceElement.setLeftLimit(extensibleDrawable2);
        sequenceElement.setRightLimit(extensibleDrawable);
        this.diagram.getFragmentManager().addSequenceElement(sequenceElement);
    }

    public boolean isEmpty() {
        return this.diagram == null || this.diagram.getNumberOfLifelines() == 0;
    }

    public void computeAxes(int n) {
        int n2 = this.diagram.getNumberOfLifelines();
        int n3 = n;
        int n4 = this.diagram.getConfiguration().getMainLifelineWidth();
        int n5 = this.diagram.getConfiguration().getSubLifelineWidth();
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n3 += this.diagram.getConfiguration().getGlue();
            }
            for (ExtensibleDrawable extensibleDrawable : this.diagram.getLifelineAt(i).getAllViews()) {
                if (extensibleDrawable instanceof Line) {
                    extensibleDrawable.setLeft(n3 + n4 / 2);
                    continue;
                }
                switch (extensibleDrawable.getLifeline().getDirection()) {
                    case CENTER: {
                        extensibleDrawable.setLeft(n3);
                        break;
                    }
                    case LEFT: {
                        extensibleDrawable.setLeft(n3 - extensibleDrawable.getLifeline().getSideLevel() * n5);
                        break;
                    }
                    case RIGHT: {
                        extensibleDrawable.setLeft(n3 + n4 + (extensibleDrawable.getLifeline().getSideLevel() - 1) * n5);
                    }
                }
            }
            Lifeline lifeline = this.diagram.getLifelineAt(i);
            Drawable drawable2 = lifeline.getHead();
            int n6 = n4 / 2;
            drawable2.setLeft(n3 - drawable2.getWidth() / 2 + n6);
            if (lifeline.getCross() != null) {
                lifeline.getCross().setLeft(n3 - this.diagram.getConfiguration().getDestructorWidth() / 2 + n4 / 2);
            }
            n3 = i < this.diagram.getNumberOfLifelines() - 1 ? (n3 += drawable2.getWidth() / 2 + this.diagram.getLifelineAt(i + 1).getHead().getWidth() / 2) : (n3 += drawable2.getWidth() / 2 + n4 / 2);
            for (SequenceElement sequenceElement : this.leftOf.get(i)) {
                int n7 = sequenceElement.getLeftLimit().getRight();
                int n8 = sequenceElement.getRightLimit() == this.rightBound ? 0 : sequenceElement.getRightLimit().getLifeline().getSideLevel();
                n3 = Math.max(n3, n7 + sequenceElement.getSpace() + sequenceElement.getWidth() + n8 * n5);
            }
        }
        this.rightBound.setLeft(n3);
    }

    public abstract int getTextWidth(String var1, boolean var2);

    public int getTextWidth(String string) {
        return this.getTextWidth(string, false);
    }

    public abstract int getTextHeight(boolean var1);

    public int getTextHeight() {
        return this.getTextHeight(false);
    }

    public int getWidth() {
        return this.diagram == null ? 0 : this.rightBound.getLeft() + 6 + this.diagram.getConfiguration().getRightMargin();
    }

    public int getHeight() {
        return this.height;
    }

    public void clear() {
        this.diagram = null;
    }

    public void computeBounds() {
        int n;
        for (n = 0; n < this.diagram.getNumberOfLifelines(); ++n) {
            for (ExtensibleDrawable extensibleDrawable : this.diagram.getLifelineAt(n).getAllViews()) {
                this.processDrawable(extensibleDrawable);
            }
        }
        for (n = 0; n < this.leftOf.size(); ++n) {
            for (SequenceElement sequenceElement : this.leftOf.get(n)) {
                this.processDrawable(sequenceElement);
            }
        }
        for (Drawable drawable : this.other) {
            this.processDrawable(drawable);
        }
        this.height += this.diagram.getConfiguration().getLowerMargin();
    }

    public void close() {
    }

    private void processDrawable(Drawable drawable) {
        this.height = Math.max(this.height, drawable.getTop() + drawable.getHeight());
        drawable.computeLayoutInformation();
        if (drawable instanceof Fragment) {
            int n = this.rightBound.getLeft();
            this.rightBound.setLeft(Math.max(n, drawable.getLeft() + drawable.getWidth()));
        }
    }

    public void announce(int n) {
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("writeToStream not supported");
    }

    @Override
    public Iterator<Drawable> iterator() {
        return new Iter();
    }

    static {
        Field[] fieldArray = Color.class.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(fieldArray[i].getName().toUpperCase()) || fieldArray[i].getType() != Color.class) continue;
            try {
                colorMap.put(fieldArray[i].getName(), (Color)fieldArray[i].get(null));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Iter
    implements Iterator<Drawable> {
        private int counter;
        private Iterator<? extends Drawable> iterator;
        private Drawable next;
        private final Diagram diagram;

        private void nextIterator() {
            if (this.diagram == null || !this.diagram.isFinished()) {
                this.iterator = null;
                return;
            }
            ++this.counter;
            this.iterator = this.counter < this.diagram.getNumberOfLifelines() ? this.diagram.getLifelineAt(this.counter).getAllViews().iterator() : (this.counter < 2 * this.diagram.getNumberOfLifelines() ? ((Set)PaintDevice.this.leftOf.get(this.counter - this.diagram.getNumberOfLifelines())).iterator() : (this.counter == 2 * this.diagram.getNumberOfLifelines() ? PaintDevice.this.other.iterator() : null));
        }

        Iter() {
            this.diagram = PaintDevice.this.diagram;
            this.counter = -1;
            this.nextIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.diagram != null && this.diagram != PaintDevice.this.diagram) {
                return false;
            }
            if (this.next == null) {
                this.findNext();
            }
            return this.next != null;
        }

        private void findNext() {
            while (this.iterator != null) {
                while (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (!this.next.isVisible()) continue;
                    return;
                }
                this.nextIterator();
            }
            if (this.next != null && !this.next.isVisible()) {
                this.next = null;
            }
        }

        @Override
        public Drawable next() {
            if (this.next == null) {
                this.findNext();
            }
            if (this.next != null) {
                Drawable drawable = this.next;
                this.next = null;
                return drawable;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

