/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Note;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Pair;

public class NoteManager {
    private final LinkedList<Note> notes;
    private final Map<Integer, List<Message>> messageAssociation;
    private final Map<Integer, List<Pair<Lifeline, Integer>>> eventAssociation;
    private final Map<String, Note> pendingNotes;
    private int freeNoteNumber;
    private final Diagram diagram;

    public NoteManager(Diagram diagram) {
        this.diagram = diagram;
        this.notes = new LinkedList();
        this.messageAssociation = new HashMap<Integer, List<Message>>();
        this.eventAssociation = new HashMap<Integer, List<Pair<Lifeline, Integer>>>();
        this.freeNoteNumber = 0;
        this.pendingNotes = new HashMap<String, Note>();
    }

    public void associateMessage(int n, Message message) {
        List<Message> list = this.messageAssociation.get(n);
        if (list == null) {
            list = new LinkedList<Message>();
            this.messageAssociation.put(n, list);
        }
        list.add(message);
    }

    public void computeArrowAssociations() {
        for (Note note : this.notes) {
            Object object;
            Object object2;
            List<Message> list = this.messageAssociation.get(note.getNumber());
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((Message)object).getArrow() == null) continue;
                    note.addTarget(((Message)object).getArrow().getAnchor());
                }
            }
            if ((object2 = this.eventAssociation.get(note.getNumber())) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                Pair pair = (Pair)object.next();
                int n = ((Lifeline)pair.getFirst()).getView().getLeft() + ((Lifeline)pair.getFirst()).getView().getWidth() / 2;
                Point point = new Point(n, (Integer)pair.getSecond());
                note.addTarget(point);
            }
        }
    }

    public int getNextFreeNoteNumber() {
        return this.freeNoteNumber;
    }

    private void associateEvent(Lifeline lifeline, int n) {
        List<Pair<Lifeline, Integer>> list = this.eventAssociation.get(n);
        if (list == null) {
            list = new LinkedList<Pair<Lifeline, Integer>>();
            this.eventAssociation.put(n, list);
        }
        list.add(new Pair<Lifeline, Integer>(lifeline, this.diagram.getVerticalPosition()));
    }

    void closeNote(String string) {
        Note note = this.pendingNotes.get(string);
        if (note != null) {
            int n = note.getTop() + note.getHeight() - this.diagram.getVerticalPosition();
            if (n > 0) {
                this.diagram.extendLifelines(n);
            }
            this.pendingNotes.remove(string);
        }
    }

    public boolean step() throws SyntaxError {
        Note note = this.diagram.getDataProvider().getNote();
        if (note != null) {
            this.freeNoteNumber = Math.max(this.freeNoteNumber, note.getNumber() + 1);
            this.diagram.getPaintDevice().addSequenceElement(note);
            this.notes.add(note);
            this.closeNote(note.getLocation().getName());
            this.diagram.getFragmentManager().openFragments();
            this.diagram.getPaintDevice().announce(note.getHeight());
            note.setTop(this.diagram.getVerticalPosition());
            if (note.isConsuming()) {
                this.diagram.extendLifelines(note.getHeight());
            } else {
                this.pendingNotes.put(note.getLocation().getName(), note);
            }
            if (this.diagram.getDataProvider().getState() != null) {
                this.diagram.addToStateMap(note, this.diagram.getDataProvider().getState());
            }
            this.diagram.getFragmentManager().clearLabels();
            return true;
        }
        Pair<Lifeline, Integer> pair = this.diagram.getDataProvider().getEventAssociation();
        if (pair != null) {
            this.associateEvent(pair.getFirst(), pair.getSecond());
            return true;
        }
        return false;
    }
}

