/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.LinkedList;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.BroadcastMessage;
import net.sf.sdedit.message.ConstructorMessage;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.message.MessageToSelf;
import net.sf.sdedit.message.Primitive;

final class MessageProcessor {
    private final Diagram diagram;
    private final DiagramDataProvider provider;
    private MessageData data;
    private Lifeline rootCaller;
    private Lifeline rootCallee;
    private int callerThread = 0;
    private int calleeThread = 0;
    private Lifeline caller;
    private Lifeline callee;
    private Answer answer;

    private boolean calleeIsActiveObject() {
        return this.rootCallee != null && this.rootCallee.isActiveObject();
    }

    private boolean callerIsActor() {
        return this.rootCaller.isAlwaysActive();
    }

    private boolean calleeIsActor() {
        return this.rootCallee != null && this.rootCallee.isAlwaysActive();
    }

    private boolean isPrimitiveMessage() {
        return this.rootCallee == null;
    }

    MessageProcessor(Diagram diagram) {
        this.diagram = diagram;
        this.provider = diagram.getDataProvider();
    }

    ForwardMessage processMessage(MessageData messageData) throws SemanticError {
        this.data = messageData;
        this.initMessage();
        messageData.getBroadcastType();
        return this._processMessage(messageData.getBroadcastType() < 2);
    }

    private ForwardMessage _processMessage(boolean bl) throws SemanticError {
        this.checkSemantics();
        if (this.diagram.isThreaded()) {
            this.findThreadNumbers();
            this.diagram.setCallerThread(this.callerThread);
        } else {
            this.noThreadingChecks();
        }
        this.caller = this.findCaller();
        this.callee = !this.isPrimitiveMessage() ? this.findCallee() : null;
        ForwardMessage forwardMessage = this.getMessage();
        if (bl) {
            this.diagram.getFragmentManager().openFragments();
        }
        return forwardMessage;
    }

    private void noThreadingChecks() throws SemanticError {
        if (this.rootCallee != null && this.rootCallee.isActiveObject()) {
            throw new SemanticError(this.provider, "Active objects are not permitted when multithreading is not enabled.");
        }
        if (this.data.isSpawnMessage()) {
            throw new SemanticError(this.provider, "Threads cannot be spawned when multithreading is not enabled.");
        }
        if (this.data.returnsInstantly()) {
            throw new SemanticError(this.provider, "Instant return must not be specified when multithreading is not enabled.");
        }
        if (this.data.getThread() != -1) {
            throw new SemanticError(this.provider, "A thread number must not be specified when multithreading is not enabled.");
        }
        if (this.data.getBroadcastType() != 0) {
            throw new SemanticError(this.provider, "Broadcast messages can only be sent when multithreading is enabled");
        }
    }

    private void checkSemantics() throws SemanticError {
        if (this.callerIsActor() && this.data.getCaller().equals(this.data.getCallee())) {
            throw new SemanticError(this.provider, "an actor cannot send a message to itself");
        }
        if (this.callerIsActor() && this.data.getAnswer().length() > 0) {
            throw new SemanticError(this.provider, "An actor cannot receive an answer automatically. This should be done by means of an explicit message!");
        }
        if (this.calleeIsActor() && this.data.getAnswer().length() > 0) {
            throw new SemanticError(this.provider, "There are no automatic answers to messages that reach actors. This should be done by means of an explicit message!");
        }
        if (this.diagram.isThreaded() && this.data.isSpawnMessage() && this.data.getAnswer().length() > 0) {
            throw new SemanticError(this.provider, "There are no automatic answers to messages that spawn threads. This should be done by means of an explicit message!");
        }
        if (this.rootCallee != null) {
            if (!this.rootCallee.isAlive() && !this.data.isNewMessage()) {
                throw new SemanticError(this.provider, this.data.getMessage() + ": " + this.data.getCallee() + " must be created first");
            }
            if (this.rootCallee.isAlive() && this.data.isNewMessage()) {
                throw new SemanticError(this.provider, this.data.getMessage() + ": " + this.data.getCallee() + " has already been created");
            }
        }
        if (this.diagram.isThreaded() && this.callerIsActor() && this.data.isSpawnMessage()) {
            throw new SemanticError(this.provider, "Actor messages are spawning by default in threaded mode");
        }
        if (this.diagram.isThreaded() && this.calleeIsActor() && this.data.getBroadcastType() == 0 && this.data.isSpawnMessage()) {
            throw new SemanticError(this.provider, "Messages sent to actors must not be spawning");
        }
    }

    private void initMessage() throws SemanticError {
        this.rootCaller = this.diagram.getLifeline(this.data.getCaller());
        if (this.rootCaller == null) {
            throw new SemanticError(this.provider, this.data.getCaller() + " does not exist");
        }
        if (!this.data.getCallee().equals("")) {
            this.rootCallee = this.diagram.getLifeline(this.data.getCallee());
            if (this.rootCallee == null) {
                throw new SemanticError(this.provider, this.data.getCallee() + " does not exist");
            }
        } else {
            this.rootCallee = null;
        }
    }

    private void findThreadNumbers() throws SemanticError {
        if (this.callerIsActor() && (this.isPrimitiveMessage() || this.calleeIsActor())) {
            this.callerThread = -1;
            this.calleeThread = -1;
            return;
        }
        if (this.callerIsActor()) {
            this.callerThread = -1;
            if (!this.data.returnsInstantly()) {
                this.calleeThread = this.diagram.spawnThread();
            }
            return;
        }
        if (this.diagram.noThreadIsSpawned()) {
            this.callerThread = this.diagram.spawnThread();
        } else {
            Lifeline lifeline = null;
            if (!this.data.getCallerMnemonic().equals("")) {
                lifeline = this.diagram.getLifelineByMnemonic(this.data.getCaller(), this.data.getCallerMnemonic());
                if (lifeline == null) {
                    throw new SemanticError(this.provider, "There is no lifeline named \"" + this.data.getCaller() + "\" associated to mnemonic \"" + this.data.getCallerMnemonic() + "\"");
                }
                this.callerThread = lifeline.getThread();
            } else if (this.data.getThread() >= 0) {
                if (this.data.getThread() >= this.diagram.getNumberOfThreads()) {
                    throw new SemanticError(this.provider, "Illegal thread number: " + this.data.getThread());
                }
                this.callerThread = this.data.getThread();
            } else {
                int n = this.rootCaller.getUniqueThread();
                if (n >= 0) {
                    this.callerThread = n;
                } else {
                    if (this.calleeThread == -1) {
                        throw new SemanticError(this.provider, "Explicit thread number required.");
                    }
                    this.callerThread = this.calleeThread;
                }
            }
        }
        boolean bl = this.data.isSpawnMessage();
        if (bl && this.data.getBroadcastType() > 0) {
            bl = !this.calleeIsActor();
        }
        this.calleeThread = (bl || this.calleeIsActiveObject()) && !this.data.returnsInstantly() ? this.diagram.spawnThread() : this.callerThread;
    }

    private Lifeline findCaller() throws SemanticError {
        String string = this.data.getCaller();
        if (this.callerIsActor()) {
            if (!this.diagram.isThreaded()) {
                this.diagram.finish();
            }
            return this.rootCaller;
        }
        String string2 = this.data.getCallerMnemonic();
        Lifeline lifeline = null;
        if (!string2.equals("") && (lifeline = this.diagram.getLifelineByMnemonic(this.data.getCaller(), string2)) == null) {
            throw new SemanticError(this.provider, "There is no lifeline named \"" + this.data.getCaller() + "\" associated to mnemonic \"" + string2 + "\"");
        }
        LinkedList<Message> linkedList = this.diagram.currentStack();
        if (linkedList == null) {
            throw new SemanticError(this.provider, "Thread " + this.callerThread + " has died");
        }
        if (this.callerThread == 0 && linkedList.isEmpty() && this.diagram.firstCaller() == null) {
            this.diagram.setFirstCaller(this.rootCaller);
            this.rootCaller.setActive(true);
            return this.rootCaller;
        }
        int n = 0;
        while (!linkedList.isEmpty()) {
            Message message = linkedList.getLast();
            if (lifeline != null) {
                if (message.getCaller() == lifeline) {
                    return lifeline;
                }
            } else if (message.getCaller().getName().equals(this.data.getCaller())) {
                if (n == this.data.getLevel()) {
                    return message.getCaller();
                }
                ++n;
            }
            linkedList.removeLast();
            this.diagram.sendAnswer(message);
        }
        if (this.diagram.firstCaller() != null && this.diagram.firstCaller().getName().equals(string)) {
            if (n == this.data.getLevel()) {
                return this.diagram.firstCaller();
            }
            ++n;
        }
        throw this.objectNotFound(n, lifeline);
    }

    private SemanticError objectNotFound(int n, Lifeline lifeline) {
        String string = lifeline != null ? this.data.getCaller() + "[" + this.data.getCallerMnemonic() + "] is not active" : (n == 0 ? this.data.getCaller() + " is not active at all" : (n == 1 ? this.data.getCaller() + "[" + this.data.getLevel() + "]" + "is not active, but " + this.data.getCaller() + "[0] is" : this.data.getCaller() + "[" + this.data.getLevel() + "]" + "is not active, but " + this.data.getCaller() + "[0]" + (n == 2 ? ", " : " - ") + this.data.getCaller() + "[" + (n - 1) + "] are"));
        return new SemanticError(this.provider, string);
    }

    private Lifeline findCallee() throws SemanticError {
        String string;
        if (this.calleeIsActor()) {
            return this.rootCallee;
        }
        Lifeline lifeline = this.rootCallee.getLastInThread(this.calleeThread);
        if (lifeline == null) {
            lifeline = this.rootCallee;
        }
        if (!this.data.returnsInstantly() || !this.callerIsActor() && !this.data.isSpawnMessage()) {
            if (!lifeline.isAlive() && this.data.isNewMessage()) {
                lifeline.setThread(this.calleeThread);
            } else if (lifeline.isActive()) {
                lifeline = lifeline.addActivity(this.caller, this.calleeThread);
            } else {
                lifeline.setThread(this.calleeThread);
            }
        }
        if (!(string = this.data.getCalleeMnemonic()).equals("")) {
            this.diagram.associateLifeline(this.data.getCallee(), string, lifeline);
            lifeline.setMnemonic(string);
        }
        return lifeline;
    }

    private ForwardMessage getMessage() throws SemanticError {
        if (this.data.isDestroyMessage() && this.rootCallee != null && this.rootCallee.isActive()) {
            throw new SemanticError(this.provider, "cannot destroy active object");
        }
        if (this.isPrimitiveMessage()) {
            return new Primitive(this.caller, this.diagram, this.data);
        }
        if (this.data.getBroadcastType() != 0) {
            return new BroadcastMessage(this.caller, this.callee, this.diagram, this.data);
        }
        if (!this.callee.isAlive() && this.data.isNewMessage()) {
            return new ConstructorMessage(this.caller, this.callee, this.diagram, this.data);
        }
        if (this.caller.getName().equals(this.callee.getName())) {
            return new MessageToSelf(this.caller, this.callee, this.diagram, this.data);
        }
        return new ForwardMessage(this.caller, this.callee, this.diagram, this.data);
    }

    void execute(ForwardMessage forwardMessage) throws SemanticError {
        int n;
        if (forwardMessage instanceof Primitive && this.diagram.isThreaded() && forwardMessage.getText().equals("stop") && !this.caller.isAlwaysActive()) {
            this.diagram.finish(this.diagram.getCallerThread());
            this.diagram.setThreadState("dead");
            this.caller.finish();
            this.diagram.deleteStack();
            return;
        }
        forwardMessage.updateView();
        if (this.provider.getState() != null) {
            this.diagram.addToStateMap(forwardMessage.getArrow(), this.provider.getState());
        }
        this.answer = forwardMessage.getAnswerMessage();
        this.diagram.setCallerThread(this.calleeThread);
        if (this.diagram.isThreaded() && !this.calleeIsActor() && !this.data.returnsInstantly() && !(forwardMessage instanceof Primitive) && (this.calleeIsActiveObject() || this.data.isSpawnMessage() || this.caller.isAlwaysActive())) {
            this.diagram.setFirstCaller(this.callee);
            this.diagram.setThreadState("running");
        }
        if (this.answer != null) {
            if (this.data.returnsInstantly()) {
                this.diagram.sendAnswer(this.answer);
            } else {
                this.diagram.currentStack().add(this.answer);
            }
        }
        if ((n = this.data.getNoteNumber()) > 0) {
            this.diagram.associateMessage(n, forwardMessage);
        }
        if ((n = this.data.getAnswerNoteNumber()) > 0) {
            if (this.answer == null) {
                throw new SemanticError(this.provider, "You cannot associate a note to an answer when there is none.");
            }
            this.diagram.associateMessage(n, this.answer);
        }
    }
}

