/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.LinkedList;
import java.util.List;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.drawable.Cross;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Figure;
import net.sf.sdedit.drawable.LabeledBox;
import net.sf.sdedit.drawable.Line;
import net.sf.sdedit.drawable.Rectangle;
import net.sf.sdedit.util.Direction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lifeline {
    private final Direction direction;
    private final String name;
    private final String type;
    private String mnemonic;
    private final Lifeline root;
    private Lifeline parent;
    private Lifeline leftChild;
    private Lifeline rightChild;
    private boolean active;
    private boolean alive;
    private final int level;
    private final int sideLevel;
    private final Diagram diagram;
    private ExtensibleDrawable view;
    private final Drawable head;
    private Cross cross;
    private int thread;
    private final boolean activeObject;
    private final boolean process;
    private final boolean hasThread;
    private Line lastLine;
    private final boolean autodestroy;
    private int rectangleBottom;
    private final List<ExtensibleDrawable> allViews;
    private final boolean external;
    private boolean waiting;

    public Lifeline(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, Diagram diagram) {
        this.diagram = diagram;
        this.name = string;
        this.type = string2;
        this.direction = Direction.CENTER;
        this.alive = bl;
        this.thread = 0;
        this.level = 0;
        this.activeObject = bl4;
        this.process = bl5;
        this.hasThread = bl6;
        this.autodestroy = bl7;
        this.external = bl8;
        this.parent = null;
        this.root = this;
        this.sideLevel = 0;
        this.rectangleBottom = 0;
        this.waiting = false;
        this.allViews = new LinkedList<ExtensibleDrawable>();
        if (string2.equals("Actor")) {
            this.head = new Figure(this, string3, diagram.getVerticalPosition(), !bl3);
            this.view = new Rectangle(this.computeDrawableWidth(), this);
            this.active = true;
        } else if (bl5) {
            this.head = new LabeledBox(this, string3, diagram.getVerticalPosition(), bl2, !bl3);
            this.view = new Rectangle(this.computeDrawableWidth(), this);
            this.active = true;
        } else {
            this.head = new LabeledBox(this, string3, diagram.getVerticalPosition(), bl2, !bl3);
            this.view = new Line(1, this);
            this.active = false;
        }
        this.view.setTop(this.head.getTop() + this.head.getHeight());
        this.head.setVisible(bl);
        this.view.setVisible(bl);
        this.addView(this.view);
    }

    private Lifeline(Lifeline lifeline, Direction direction, int n) {
        this.name = lifeline.name;
        this.type = lifeline.type;
        this.direction = direction;
        this.activeObject = lifeline.activeObject;
        this.root = lifeline;
        this.thread = n;
        this.external = lifeline.external;
        this.autodestroy = false;
        this.hasThread = false;
        this.diagram = lifeline.diagram;
        this.alive = true;
        this.parent = lifeline;
        this.level = lifeline.getAllLifelines().size();
        this.allViews = null;
        this.waiting = false;
        if (direction == Direction.LEFT) {
            while (this.parent.leftChild != null) {
                this.parent = this.parent.leftChild;
            }
            this.parent.leftChild = this;
        } else {
            while (this.parent.rightChild != null) {
                this.parent = this.parent.rightChild;
            }
            this.parent.rightChild = this;
        }
        this.sideLevel = this.parent.sideLevel + 1;
        this.active = false;
        this.view = new Rectangle(this.computeDrawableWidth(), this);
        this.head = null;
        this.process = false;
    }

    public void addView(ExtensibleDrawable extensibleDrawable) {
        this.root.allViews.add(extensibleDrawable);
    }

    public List<ExtensibleDrawable> getAllViews() {
        return this.allViews;
    }

    public int getCallLevel() {
        int n = 0;
        for (Lifeline lifeline : this.getAllLifelines()) {
            if (lifeline == this || this.thread != lifeline.thread) continue;
            ++n;
        }
        return n;
    }

    public boolean isActiveObject() {
        return this.activeObject;
    }

    public boolean hasThread() {
        return this.hasThread;
    }

    public void setThread(int n) {
        this.thread = n;
    }

    public int getThread() {
        return this.thread;
    }

    public void setMnemonic(String string) {
        this.mnemonic = string;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public int getUniqueThread() {
        int n = -1;
        for (Lifeline lifeline : this.getAllLifelines()) {
            if (!lifeline.isActive()) continue;
            if (n == -1) {
                n = lifeline.getThread();
                continue;
            }
            if (n == lifeline.getThread()) continue;
            return -1;
        }
        return n;
    }

    public Lifeline getLeftmost() {
        Lifeline lifeline = this.root;
        while (lifeline.leftChild != null) {
            lifeline = lifeline.leftChild;
        }
        return lifeline;
    }

    public Lifeline getRightmost() {
        Lifeline lifeline = this.root;
        while (lifeline.rightChild != null) {
            lifeline = lifeline.rightChild;
        }
        return lifeline;
    }

    public Lifeline getRoot() {
        return this.root;
    }

    public boolean isAlwaysActive() {
        return this.type.equals("Actor") || this.process;
    }

    public LinkedList<Lifeline> getAllLifelines() {
        LinkedList<Lifeline> linkedList = new LinkedList<Lifeline>();
        linkedList.add(this);
        Lifeline lifeline = this.leftChild;
        while (lifeline != null) {
            linkedList.add(lifeline);
            lifeline = lifeline.leftChild;
        }
        lifeline = this.rightChild;
        while (lifeline != null) {
            linkedList.add(lifeline);
            lifeline = lifeline.rightChild;
        }
        return linkedList;
    }

    public Lifeline getLastInThread(int n) {
        Lifeline lifeline = null;
        for (Lifeline lifeline2 : this.getAllLifelines()) {
            if (lifeline2.getThread() != n || lifeline != null && lifeline2.level <= lifeline.level) continue;
            lifeline = lifeline2;
        }
        return lifeline;
    }

    public Lifeline getRightNeighbour() {
        int n = this.getPosition();
        if (n < this.diagram.getNumberOfLifelines() - 1) {
            Lifeline lifeline = this.diagram.getLifelineAt(n + 1);
            while (lifeline.leftChild != null) {
                lifeline = lifeline.leftChild;
            }
            return lifeline;
        }
        return null;
    }

    public Lifeline getLeftNeighbour() {
        int n = this.getPosition();
        if (n > 0) {
            Lifeline lifeline = this.diagram.getLifelineAt(n - 1);
            while (lifeline.rightChild != null) {
                lifeline = lifeline.rightChild;
            }
            return lifeline;
        }
        return null;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void giveBirth() {
        this.alive = true;
        this.head.setVisible(true);
        this.view.setVisible(true);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getPosition() {
        return this.diagram.getPositionOf(this);
    }

    public int getSideLevel() {
        return this.sideLevel;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Lifeline addActivity(Lifeline lifeline, int n) {
        Direction direction = lifeline.getName().equals(this.getName()) ? (lifeline.getDirection() == Direction.CENTER ? Direction.RIGHT : (this.getDirection() == Direction.CENTER ? lifeline.getDirection() : this.getDirection())) : (lifeline.getPosition() < this.getPosition() ? Direction.LEFT : Direction.RIGHT);
        return new Lifeline(this.root, direction, n);
    }

    public void finish() {
        this.setActive(false);
        this.getRoot().setRectangleBottom(this.diagram.getVerticalPosition());
    }

    public void terminate() {
        ExtensibleDrawable extensibleDrawable;
        ExtensibleDrawable extensibleDrawable2 = extensibleDrawable = this.lastLine != null ? this.lastLine : this.view;
        if (this.alive && this.autodestroy) {
            int n = Math.max(6, this.rectangleBottom - extensibleDrawable.getTop());
            this.cross = new Cross(this);
            int n2 = extensibleDrawable.getTop() + n + this.cross.getHeight();
            if (n2 > this.diagram.getVerticalPosition()) {
                this.diagram.extendLifelines(n2 - this.diagram.getVerticalPosition());
            }
            this.cross.setTop(extensibleDrawable.getTop() + n);
            this.diagram.getPaintDevice().addOtherDrawable(this.cross);
            extensibleDrawable.setHeight(n);
        }
        this.alive = false;
    }

    public void dispose() {
        if (this.active) {
            throw new IllegalStateException("lifeline is still active");
        }
        if (this.getRoot() == this) {
            throw new IllegalStateException("lifeline cannot be disposed");
        }
        switch (this.direction) {
            case LEFT: {
                this.parent.leftChild = this.leftChild;
                if (this.leftChild == null) break;
                this.leftChild.parent = this.parent;
                break;
            }
            case RIGHT: {
                this.parent.rightChild = this.rightChild;
                if (this.rightChild == null) break;
                this.rightChild.parent = this.parent;
                break;
            }
            case CENTER: {
                throw new IllegalStateException("The lifeline is not root, but has center direction");
            }
        }
        this.getRoot().setRectangleBottom(this.diagram.getVerticalPosition());
    }

    public void toggleWaitingStatus() {
        if (!this.active) {
            throw new IllegalArgumentException("an inactive lifeline cannot change its waiting status");
        }
        this.waiting = !this.waiting;
        int n = this.view.getTop() + this.view.getHeight();
        if (this.waiting) {
            this.lastLine = new Line(1, this);
            this.lastLine.setLeft(this.view.getLeft() + this.view.getWidth() / 2);
            this.view = this.lastLine;
        } else {
            this.view = new Rectangle(this.computeDrawableWidth(), this);
        }
        this.view.setTop(n);
    }

    public void setActive(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        if (this != this.getRoot()) {
            if (bl) {
                this.view.setTop(this.parent.getView().getTop() + this.parent.getView().getHeight());
                this.view.setHeight(0);
            } else {
                this.diagram.clearMnemonic(this);
            }
            return;
        }
        int n = this.view.getTop() + this.view.getHeight();
        if (bl) {
            this.view = new Rectangle(this.computeDrawableWidth(), this);
        } else {
            this.view = new Line(1, this);
            this.diagram.clearMnemonic(this);
            this.lastLine = (Line)this.view;
        }
        this.view.setTop(n);
    }

    public void setRectangleBottom(int n) {
        this.rectangleBottom = Math.max(this.rectangleBottom, n);
    }

    public String toString() {
        return this.getName() + ":" + this.getType();
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public ExtensibleDrawable getView() {
        return this.view;
    }

    public Drawable getHead() {
        return this.head;
    }

    private int computeDrawableWidth() {
        return this.sideLevel == 0 ? this.diagram.getConfiguration().getMainLifelineWidth() : this.diagram.getConfiguration().getSubLifelineWidth();
    }

    public boolean isExternal() {
        return this.external;
    }

    public void destroy() {
        this.diagram.removeLifeline(this.getName());
        this.cross = new Cross(this);
        this.diagram.getPaintDevice().addOtherDrawable(this.cross);
    }

    public Cross getCross() {
        return this.cross;
    }
}

