/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.LinkedList;
import java.util.ListIterator;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.message.Answer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FragmentManager {
    private final Diagram diagram;
    private final LinkedList<Fragment> openFragments;
    private final LinkedList<Fragment> closingFragments;
    private final LinkedList<String> fragmentLabels;
    private String fragmentSectionLabel;

    public FragmentManager(Diagram diagram) {
        this.diagram = diagram;
        this.openFragments = new LinkedList();
        this.closingFragments = new LinkedList();
        this.fragmentLabels = new LinkedList();
    }

    public LinkedList<String> getFragmentLabels() {
        return this.fragmentLabels;
    }

    public String getFragmentSectionLabel() {
        return this.fragmentSectionLabel;
    }

    public void clearLabels() {
        this.fragmentLabels.clear();
    }

    public void clearSectionLabel() {
        this.fragmentSectionLabel = null;
    }

    public boolean readFragments() throws SyntaxError {
        DiagramDataProvider diagramDataProvider = this.diagram.getDataProvider();
        if (diagramDataProvider.closeFragment()) {
            this.closeRecentFragment();
            return true;
        }
        String string = diagramDataProvider.openFragment();
        if (string != null) {
            this.fragmentLabels.add(string);
            return true;
        }
        String string2 = diagramDataProvider.getFragmentSeparator();
        if (string2 != null) {
            if (this.fragmentSectionLabel != null) {
                throw new SyntaxError(diagramDataProvider, "double separator");
            }
            if (this.getRecentFragment() == null) {
                throw new SyntaxError(diagramDataProvider, "no comment open");
            }
            this.fragmentSectionLabel = string2;
            return true;
        }
        return false;
    }

    public void openFragments() {
        this.finishFragments();
        Object object = this.fragmentLabels.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (string.startsWith("[c")) {
                string = string.substring(2, string.length() - 1).trim();
            }
            if (string.length() > 0 && string.charAt(0) == ':') {
                int n = (string = string.substring(1)).indexOf(32);
                if (n == -1) {
                    this.openFragment(string, "");
                    continue;
                }
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.openFragment(string2, string3);
                continue;
            }
            this.openFragment("", string);
        }
        if (this.fragmentSectionLabel != null && (object = this.getRecentFragment()) != null) {
            ((Fragment)object).addSection(this.fragmentSectionLabel);
        }
    }

    private void openFragment(String string, String string2) {
        Fragment fragment = new Fragment(string, string2, this.diagram);
        int n = this.diagram.getPaintDevice().getTextHeight();
        int n2 = 5 + (fragment.getCondition().length() > 0 ? n * 2 : n);
        this.diagram.getPaintDevice().announce(this.diagram.getConfiguration().getFragmentMargin() + n2);
        this.diagram.extendLifelines(this.diagram.getConfiguration().getFragmentMargin());
        fragment.setTop(this.diagram.getVerticalPosition());
        this.diagram.extendLifelines(n2);
        this.openFragments.addLast(fragment);
        this.diagram.getPaintDevice().addOtherDrawable(fragment);
        int n3 = this.openFragments.size() - 1;
        for (Fragment fragment2 : this.openFragments) {
            fragment2.setLevel(n3);
            --n3;
        }
    }

    public boolean openFragmentsExist() {
        return this.openFragments.size() > 0;
    }

    public void finishFragments() {
        for (Fragment fragment : this.closingFragments) {
            this.finishFragment(fragment);
        }
        this.closingFragments.clear();
    }

    private void finishFragment(Fragment fragment) {
        this.diagram.extendLifelines(this.diagram.getConfiguration().getFragmentPadding());
        fragment.setBottom(this.diagram.getVerticalPosition());
        this.diagram.extendLifelines(this.diagram.getConfiguration().getFragmentMargin());
    }

    public void finishFragmentsNotIncluding(Answer answer) {
        ListIterator listIterator = this.closingFragments.listIterator();
        Arrow arrow = answer.getForwardMessage().getArrow();
        while (listIterator.hasNext()) {
            Fragment fragment = (Fragment)listIterator.next();
            if (fragment.containsElement(arrow)) continue;
            listIterator.remove();
            this.finishFragment(fragment);
        }
    }

    public void addSequenceElement(SequenceElement sequenceElement) {
        for (Fragment fragment : this.openFragments) {
            fragment.addElement(sequenceElement);
        }
        for (Fragment fragment : this.closingFragments) {
            fragment.addElement(sequenceElement);
        }
    }

    private void closeRecentFragment() throws SyntaxError {
        if (this.openFragments.isEmpty()) {
            throw new SyntaxError(this.diagram.getDataProvider(), "There is no open comment");
        }
        Fragment fragment = this.openFragments.removeLast();
        this.closingFragments.addLast(fragment);
    }

    private Fragment getRecentFragment() {
        if (this.openFragments.isEmpty()) {
            return null;
        }
        return this.openFragments.getLast();
    }
}

