/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.diagram.FragmentManager;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.MessageProcessor;
import net.sf.sdedit.diagram.NoteManager;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.Text;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.BroadcastMessage;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Bijection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Diagram
implements Constants {
    private final Map<String, Lifeline> lifelineMap;
    private final List<Lifeline> lifelineList;
    private int verticalPosition;
    private final DiagramDataProvider provider;
    private final Configuration conf;
    private final ArrayList<LinkedList<Message>> threadStacks;
    private final ArrayList<Lifeline> first;
    private final PaintDevice paintDevice;
    private final Bijection<Drawable, Object> drawableBijection;
    private int callerThread;
    private final boolean threaded;
    private final ArrayList<String> threadStates;
    private final NoteManager noteManager;
    private final Map<String, Map<String, Lifeline>> mnemonicMap;
    private final FragmentManager fragmentManager;
    private final MessageProcessor processor;
    private boolean finished;
    public final int arrowSize;
    public final int messagePadding;
    public final int subLifelineWidth;
    public final int mainLifelineWidth;
    public final int messageLabelSpace;
    public final boolean returnArrowVisible;
    public final Color[] threadColors;

    public Diagram(Configuration configuration, DiagramDataProvider diagramDataProvider, PaintDevice paintDevice) {
        this.arrowSize = configuration.getArrowSize();
        this.messagePadding = configuration.getMessagePadding();
        this.subLifelineWidth = configuration.getMessagePadding();
        this.mainLifelineWidth = configuration.getMainLifelineWidth();
        this.messageLabelSpace = configuration.getMessageLabelSpace();
        this.returnArrowVisible = configuration.isReturnArrowVisible();
        this.paintDevice = paintDevice;
        this.lifelineMap = new HashMap<String, Lifeline>();
        this.lifelineList = new ArrayList<Lifeline>();
        this.conf = configuration;
        paintDevice.setDiagram(this);
        this.verticalPosition = 0;
        this.first = new ArrayList();
        this.provider = diagramDataProvider;
        diagramDataProvider.setDiagram(this);
        this.threadStacks = new ArrayList();
        this.threadStates = new ArrayList();
        this.drawableBijection = new Bijection();
        this.threaded = this.conf.isThreaded();
        if (!this.threaded) {
            this.callerThread = this.spawnThread();
        }
        this.mnemonicMap = new HashMap<String, Map<String, Lifeline>>();
        this.noteManager = new NoteManager(this);
        this.fragmentManager = new FragmentManager(this);
        this.processor = new MessageProcessor(this);
        this.finished = false;
        this.threadColors = new Color[]{configuration.getTc0(), configuration.getTc1(), configuration.getTc2(), configuration.getTc3(), configuration.getTc4(), configuration.getTc5(), configuration.getTc6(), configuration.getTc7(), configuration.getTc8(), configuration.getTc9()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws SemanticError, SyntaxError {
        block16: {
            Iterator<Lifeline> iterator;
            Fragment fragment = null;
            Text text = null;
            String string = this.provider.getTitle();
            String[] stringArray = this.provider.getDescription();
            if (stringArray != null) {
                text = new Text(stringArray, this.paintDevice);
                text.setTop(this.conf.getUpperMargin());
                text.setLeft(this.conf.getLeftMargin());
                this.verticalPosition = text.getBottom() + 3;
            } else {
                this.verticalPosition = this.conf.getUpperMargin();
            }
            if (string != null) {
                fragment = new Fragment(string, "", this);
                fragment.setTop(this.verticalPosition);
                this.verticalPosition += fragment.getLabelHeight() + 5;
            }
            this.readObjects();
            if (this.lifelineList.isEmpty()) {
                return;
            }
            this.paintDevice.reinitialize();
            try {
                for (Lifeline lifeline : this.lifelineList) {
                    this.paintDevice.addOtherDrawable(lifeline.getHead());
                    this.verticalPosition = Math.max(this.verticalPosition, lifeline.getHead().getTop() + lifeline.getHead().getHeight());
                }
                for (Lifeline lifeline : this.lifelineList) {
                    lifeline.getView().setBottom(this.verticalPosition);
                }
                this.extendLifelines(this.conf.getInitialSpace());
                for (Lifeline lifeline : this.lifelineList) {
                    if (!lifeline.hasThread()) continue;
                    lifeline.setActive(true);
                }
                this.readMessages();
                Object var8_7 = null;
                this.fragmentManager.finishFragments();
                if (this.getNumberOfLifelines() <= 0) break block16;
                this.paintDevice.computeAxes(this.conf.getLeftMargin() + 6 + this.getLifelineAt(0).getHead().getWidth() / 2);
                this.paintDevice.computeBounds();
                iterator = this.getAllLifelines().iterator();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.fragmentManager.finishFragments();
                if (this.getNumberOfLifelines() > 0) {
                    this.paintDevice.computeAxes(this.conf.getLeftMargin() + 6 + this.getLifelineAt(0).getHead().getWidth() / 2);
                    this.paintDevice.computeBounds();
                    for (Lifeline lifeline : this.getAllLifelines()) {
                        this.noteManager.closeNote(lifeline.getName());
                    }
                    this.noteManager.computeArrowAssociations();
                    if (fragment != null) {
                        fragment.setLeft(this.conf.getLeftMargin());
                        fragment.setRight(this.paintDevice.getWidth() - this.conf.getRightMargin() + 6);
                        fragment.setBottom(this.verticalPosition + 4);
                        this.paintDevice.addOtherDrawable(fragment);
                    }
                    if (text != null) {
                        this.paintDevice.addOtherDrawable(text);
                    }
                }
                this.finished = true;
                this.paintDevice.close();
                throw throwable;
            }
            while (iterator.hasNext()) {
                Lifeline lifeline = iterator.next();
                this.noteManager.closeNote(lifeline.getName());
            }
            this.noteManager.computeArrowAssociations();
            if (fragment != null) {
                fragment.setLeft(this.conf.getLeftMargin());
                fragment.setRight(this.paintDevice.getWidth() - this.conf.getRightMargin() + 6);
                fragment.setBottom(this.verticalPosition + 4);
                this.paintDevice.addOtherDrawable(fragment);
            }
            if (text != null) {
                this.paintDevice.addOtherDrawable(text);
            }
        }
        this.finished = true;
        this.paintDevice.close();
    }

    public final boolean isFinished() {
        return this.finished;
    }

    private void readObjects() throws SyntaxError, SemanticError {
        while (this.provider.advance()) {
            Lifeline lifeline = this.provider.nextObject();
            if (lifeline == null) {
                return;
            }
            if (lifeline.isActiveObject() && !this.threaded) {
                throw new SemanticError(this.provider, "v flag for active object cannot be set when multithreading is disabled");
            }
            if (this.provider.getState() != null) {
                this.drawableBijection.add(lifeline.getHead(), this.provider.getState());
            }
            this.addLifeline(lifeline);
        }
    }

    private void readMessages() throws SyntaxError, SemanticError {
        while (this.provider.advance()) {
            if (this.fragmentManager.readFragments()) continue;
            if (!this.noteManager.step()) {
                Object object;
                MessageData messageData = this.provider.nextMessage();
                this.noteManager.closeNote(messageData.getCaller());
                String[] stringArray = messageData.getCallees();
                if (stringArray.length == 1) {
                    throw new SyntaxError(this.provider, "A broadcast message must have at least two receivers");
                }
                if (stringArray.length >= 2) {
                    if (messageData.isSpawnMessage()) {
                        throw new SyntaxError(this.provider, "Broadcast messages are spawning by default");
                    }
                    object = new HashSet();
                    Lifeline[] lifelineArray = new Lifeline[stringArray.length - 1];
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (string.length() == 0) {
                            throw new SyntaxError(this.provider, "Malformed broadcast message");
                        }
                        if (!object.add(string)) {
                            throw new SyntaxError(this.provider, "Duplicate receiver: " + string);
                        }
                        if (string.equals(messageData.getCaller())) {
                            throw new SyntaxError(this.provider, "The sender " + string + " cannot be a " + "receiver of the broadcast message");
                        }
                        this.noteManager.closeNote(string);
                        MessageData messageData2 = new MessageData();
                        messageData2.setCaller(messageData.getCaller());
                        messageData2.setCallee(string);
                        messageData2.setLevel(messageData.getLevel());
                        messageData2.setThread(messageData.getThread());
                        if (this.getLifeline(messageData.getCaller()) != null && !this.getLifeline(messageData.getCaller()).isAlwaysActive()) {
                            messageData2.setSpawnMessage(true);
                        }
                        messageData2.setReturnsInstantly(messageData.returnsInstantly());
                        if (i == 0) {
                            messageData2.setNoteNumber(messageData.getNoteNumber());
                            messageData2.setMessage(messageData.getMessage());
                            messageData2.setBroadcastType(1);
                        } else if (i == stringArray.length - 1) {
                            messageData2.setBroadcastType(3);
                        } else {
                            messageData2.setBroadcastType(2);
                        }
                        BroadcastMessage broadcastMessage = (BroadcastMessage)this.processor.processMessage(messageData2);
                        if (i < stringArray.length - 1) {
                            lifelineArray[i] = broadcastMessage.getCallee();
                        } else {
                            broadcastMessage.setOtherCallees(lifelineArray);
                        }
                        this.processor.execute(broadcastMessage);
                    }
                } else {
                    this.noteManager.closeNote(messageData.getCallee());
                    object = this.processor.processMessage(messageData);
                    this.processor.execute((ForwardMessage)object);
                }
                this.fragmentManager.clearLabels();
            }
            this.fragmentManager.clearSectionLabel();
        }
        this.finish();
        for (Lifeline lifeline : this.getLifelines()) {
            if (lifeline.isAlwaysActive()) continue;
            lifeline.terminate();
        }
    }

    public int getNextFreeNoteNumber() {
        return this.noteManager.getNextFreeNoteNumber();
    }

    public FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public Object getStateForDrawable(Drawable drawable) {
        Message message;
        if (drawable instanceof Arrow && (message = ((Arrow)drawable).getMessage()) instanceof Answer) {
            drawable = ((Answer)message).getForwardMessage().getArrow();
        }
        return this.drawableBijection.getImage(drawable);
    }

    public Drawable getDrawableForState(Object object) {
        return this.drawableBijection.getPreImage(object);
    }

    private boolean addLifeline(Lifeline lifeline) throws SemanticError {
        if (this.lifelineMap.get(lifeline.getName()) != null) {
            throw new SemanticError(this.provider, lifeline.getName() + " already exists");
        }
        if (lifeline.hasThread()) {
            if (!this.threaded) {
                throw new SemanticError(this.provider, lifeline.getName() + " cannot have its own thread when multithreading is not enabled");
            }
            int n = this.spawnThread();
            this.first.set(n, lifeline);
            lifeline.setThread(n);
        }
        this.lifelineList.add(lifeline);
        this.lifelineMap.put(lifeline.getName(), lifeline);
        return true;
    }

    public final void extendLifelines(int n) {
        for (Lifeline lifeline : this.getLifelines()) {
            if (!lifeline.isAlive()) continue;
            for (Lifeline lifeline2 : lifeline.getAllLifelines()) {
                lifeline2.getView().extend(n);
            }
        }
        this.verticalPosition += n;
    }

    int getPositionOf(Lifeline lifeline) {
        return this.lifelineList.indexOf(lifeline.getRoot());
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public int getCallerThread() {
        return this.callerThread;
    }

    public void setCallerThread(int n) {
        this.callerThread = n;
    }

    public PaintDevice getPaintDevice() {
        return this.paintDevice;
    }

    public DiagramDataProvider getDataProvider() {
        return this.provider;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Collection<Lifeline> getLifelines() {
        return this.lifelineMap.values();
    }

    public Collection<Lifeline> getAllLifelines() {
        return this.lifelineList;
    }

    public void removeLifeline(String string) {
        if (this.lifelineMap.remove(string) == null) {
            throw new IllegalArgumentException("lifeline " + string + " should be removed, but does not exist");
        }
    }

    LinkedList<Message> currentStack() {
        return this.threadStacks.get(this.callerThread);
    }

    Lifeline firstCaller() {
        return this.first.get(this.callerThread);
    }

    void setFirstCaller(Lifeline lifeline) {
        this.first.set(this.callerThread, lifeline);
    }

    int spawnThread() {
        int n = this.threadStacks.size();
        this.threadStacks.add(new LinkedList());
        this.first.add(null);
        this.threadStates.add("new");
        return n;
    }

    boolean noThreadIsSpawned() {
        return this.threadStacks.isEmpty();
    }

    String threadState() {
        return this.threadStates.get(this.callerThread);
    }

    void setThreadState(String string) {
        this.threadStates.set(this.callerThread, string);
    }

    void deleteStack() {
        this.threadStacks.set(this.callerThread, null);
        this.first.set(this.callerThread, null);
    }

    void finish(int n) {
        Object object;
        LinkedList<Message> linkedList = this.threadStacks.get(n);
        while (linkedList != null && !linkedList.isEmpty()) {
            object = linkedList.removeLast();
            this.sendAnswer((Message)object);
        }
        object = this.first.get(n);
        if (object != null) {
            ((Lifeline)object).finish();
            if (((Lifeline)object).getRoot() != object) {
                ((Lifeline)object).dispose();
            }
        }
    }

    public void sendAnswer(Message message) {
        this.sendAnswer(message, false);
    }

    public void sendAnswer(Message message, boolean bl) {
        if (bl) {
            int n = message.getThread();
            this.threadStacks.get(n).removeLast();
        }
        this.noteManager.closeNote(message.getCaller().getName());
        this.noteManager.closeNote(message.getCallee().getName());
        message.updateView();
    }

    public void finish() {
        for (int i = 0; i < this.threadStacks.size(); ++i) {
            this.finish(i);
        }
        for (Lifeline lifeline : this.getLifelines()) {
            if (lifeline == null || lifeline.isAlwaysActive() || !lifeline.isActive()) continue;
            lifeline.finish();
        }
    }

    public Lifeline getLifelineAt(int n) {
        return this.lifelineList.get(n);
    }

    public Lifeline getLifeline(String string) {
        return this.lifelineMap.get(string);
    }

    public int getNumberOfLifelines() {
        return this.lifelineList.size();
    }

    void setVerticalPosition(int n) {
        this.verticalPosition = n;
    }

    public int getVerticalPosition() {
        return this.verticalPosition;
    }

    public int getNumberOfThreads() {
        return this.threadStacks.size();
    }

    void addToStateMap(Drawable drawable, Object object) {
        this.drawableBijection.add(drawable, object);
    }

    public Lifeline getLifelineByMnemonic(String string, String string2) {
        Map<String, Lifeline> map = this.mnemonicMap.get(string);
        return map == null ? null : map.get(string2);
    }

    public void associateLifeline(String string, String string2, Lifeline lifeline) throws SemanticError {
        Map<String, Lifeline> map = this.mnemonicMap.get(string);
        if (map == null) {
            map = new HashMap<String, Lifeline>();
            this.mnemonicMap.put(string, map);
        }
        if (map.put(string2, lifeline) != null) {
            throw new SemanticError(this.provider, "The mnemonic \"" + string2 + "\" is already defined for the lifeline " + "\"" + lifeline.getName());
        }
    }

    public void associateMessage(int n, Message message) {
        this.noteManager.associateMessage(n, message);
    }

    public void clearMnemonic(Lifeline lifeline) {
        String string = lifeline.getMnemonic();
        if (string == null) {
            return;
        }
        Map<String, Lifeline> map = this.mnemonicMap.get(lifeline.getName());
        map.remove(string);
    }

    public void toggleWaitingStatus(int n) {
        for (Lifeline lifeline : this.getLifelines(n)) {
            lifeline.toggleWaitingStatus();
        }
    }

    private Set<Lifeline> getLifelines(int n) {
        HashSet<Lifeline> hashSet = new HashSet<Lifeline>();
        Lifeline lifeline = this.first.get(n);
        if (!lifeline.isAlwaysActive()) {
            hashSet.add(lifeline);
        }
        for (Message message : this.threadStacks.get(n)) {
            hashSet.add(message.getCaller());
            if (message.getCallee() == null) continue;
            hashSet.add(message.getCallee());
        }
        return hashSet;
    }
}

