/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.GlobalConfiguration;
import net.sf.sdedit.config.GlobalConfigurationStrings;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.util.DocUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationManager {
    public static final Bean<GlobalConfiguration> GLOBAL_DEFAULT = new Bean<GlobalConfiguration>(GlobalConfiguration.class, new GlobalConfigurationStrings());
    public static final Bean<Configuration> LOCAL_DEFAULT = new Bean<Configuration>(Configuration.class, null);
    public static final Bean<PrintConfiguration> PRINT_DEFAULT = new Bean<PrintConfiguration>(PrintConfiguration.class, null);
    private static final Bean<GlobalConfiguration> global;
    private static final Bean<Configuration> local;
    private static final Bean<PrintConfiguration> print;

    private ConfigurationManager() {
    }

    public static Bean<GlobalConfiguration> getGlobalConfigurationBean() {
        return global;
    }

    public static Bean<PrintConfiguration> getPrintConfigurationBean() {
        return print;
    }

    public static PrintConfiguration getPrintConfiguration() {
        return print.getDataObject();
    }

    public static GlobalConfiguration getGlobalConfiguration() {
        return global.getDataObject();
    }

    public static Bean<Configuration> getDefaultConfigurationBean() {
        return local;
    }

    public static Configuration getDefaultConfiguration() {
        return local.getDataObject();
    }

    public static Bean<Configuration> createNewDefaultConfiguration() {
        return local.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void storeConfigurations() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(Constants.GLOBAL_CONF_FILE);
        try {
            try {
                Document document = DocUtil.newDocument();
                Element element = document.createElement("sdedit-configuration");
                document.appendChild(element);
                global.store(document, "/sdedit-configuration", "global-settings");
                local.store(document, "/sdedit-configuration", "default-settings");
                print.store(document, "/sdedit-configuration", "printer-settings");
                DocUtil.writeDocument(document, "UTF-8", fileOutputStream);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Object var4_7 = null;
                ((OutputStream)fileOutputStream).close();
                return;
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getValuesFromURL(URL uRL, Bean<GlobalConfiguration> bean, Bean<Configuration> bean2, Bean<PrintConfiguration> bean3) throws IOException, DocUtil.XMLException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Document document = DocUtil.readDocument(inputStream, "UTF-8");
            bean.load(document, "/sdedit-configuration/global-settings");
            bean2.load(document, "/sdedit-configuration/default-settings");
            if (bean3 != null) {
                bean3.load(document, "/sdedit-configuration/printer-settings");
            }
            Object var7_6 = null;
            if (inputStream == null) return true;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return true;
    }

    static {
        URL uRL = GlobalConfiguration.class.getResource("default.conf");
        try {
            ConfigurationManager.getValuesFromURL(uRL, GLOBAL_DEFAULT, LOCAL_DEFAULT, PRINT_DEFAULT);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IllegalStateException();
        }
        global = GLOBAL_DEFAULT.copy();
        local = LOCAL_DEFAULT.copy();
        print = PRINT_DEFAULT.copy();
        try {
            URL uRL2 = Constants.GLOBAL_CONF_FILE.toURI().toURL();
            ConfigurationManager.getValuesFromURL(uRL2, global, local, print);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

