/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.SwingUtilities;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.editor.DiagramLoader;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.server.Exporter;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.ImagePaintDevice;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.ObjectFactory;
import net.sf.sdedit.util.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
implements Constants {
    public static void main(String[] stringArray) throws Exception {
        PosixParser posixParser = new PosixParser();
        CommandLine commandLine = null;
        Options options = Main.createBasicOptions();
        Main.addPropertyOptions(options, ConfigurationManager.getDefaultConfigurationBean());
        try {
            commandLine = posixParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            Main.printHelp(Main.createBasicOptions());
            return;
        }
        if (commandLine.hasOption('h')) {
            Main.printHelp(options);
            return;
        }
        if (commandLine.getOptionValue('o') != null) {
            Main.createImage(commandLine);
            System.out.println("created image file: " + commandLine.getOptionValue('o'));
        } else {
            String[] stringArray2;
            if (OS.TYPE == OS.Type.MAC) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "sdedit");
                System.setProperty("com.apple.mrj.application.live-resize", "true");
            }
            if ((stringArray2 = Main.getInputFiles(commandLine)).length > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Editor editor = Editor.getEditor();
                        boolean bl = false;
                        for (String string : stringArray2) {
                            File file = new File(string);
                            if (file.exists() && file.canRead() && !file.isDirectory()) {
                                bl = true;
                                try {
                                    editor.loadCode(file);
                                }
                                catch (Exception exception) {
                                    editor.error(exception.getMessage());
                                }
                                continue;
                            }
                            System.err.println("Warning: ignoring file " + string);
                        }
                        if (!bl) {
                            editor.getUI().addTab("untitled", ConfigurationManager.createNewDefaultConfiguration());
                        }
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Editor editor = Editor.getEditor();
                        editor.getUI().addTab("untitled", ConfigurationManager.createNewDefaultConfiguration());
                    }
                });
            }
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("<sdedit-start-command> [options] [input-files]", options);
    }

    private static Options createBasicOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output file");
        Option option = OptionBuilder.create('o');
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output file type");
        OptionBuilder.withDescription("one of " + Main.availableTypes());
        OptionBuilder.hasArg();
        Option option2 = OptionBuilder.create('t');
        options.addOption(option2);
        OptionBuilder.withArgName("orientation");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("one of {Portrait, Landscape}");
        Option option3 = OptionBuilder.create('r');
        options.addOption(option3);
        OptionBuilder.withArgName("page format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("one of {A0, ..., A6}");
        Option option4 = OptionBuilder.create('f');
        options.addOption(option4);
        OptionBuilder.withDescription("show long options (for diagram preferences)");
        Option option5 = OptionBuilder.create('h');
        options.addOption(option5);
        return options;
    }

    private static void addPropertyOptions(Options options, Bean<Configuration> bean) {
        for (PropertyDescriptor propertyDescriptor : bean.getProperties()) {
            if (!propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class).editable()) continue;
            String string = propertyDescriptor.getName();
            String string2 = propertyDescriptor.getPropertyType().getSimpleName();
            String string3 = propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class).info();
            OptionBuilder.withArgName(string2);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription(string3);
            OptionBuilder.withValueSeparator('=');
            OptionBuilder.withLongOpt(string);
            Option option = OptionBuilder.create();
            options.addOption(option);
        }
    }

    private static String[] getInputFiles(CommandLine commandLine) {
        return commandLine.getArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createImage(CommandLine commandLine) throws IOException, DocUtil.XMLException, SyntaxError, SemanticError {
        File file = new File(Main.getInputFiles(commandLine)[0]);
        File file2 = new File(commandLine.getOptionValue('o'));
        String string = "png";
        if (commandLine.getOptionValue('t') != null) {
            string = commandLine.getOptionValue('t').toLowerCase();
        }
        String string2 = "A4";
        if (commandLine.getOptionValue('f') != null) {
            string2 = commandLine.getOptionValue('f').toUpperCase();
        }
        String string3 = "Portrait";
        if (commandLine.getOptionValue('r') != null && (string3 = commandLine.getOptionValue('r').toLowerCase()).length() > 0) {
            string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        fileInputStream = new FileInputStream(file);
        try {
            fileOutputStream = new FileOutputStream(file2);
            try {
                Pair<String, Bean<Configuration>> pair = DiagramLoader.load(fileInputStream, ConfigurationManager.getGlobalConfiguration().getFileEncoding());
                TextHandler textHandler = new TextHandler(pair.getFirst());
                Bean<Configuration> bean = pair.getSecond();
                Main.configure(bean, commandLine);
                if (string.equals("png")) {
                    ImagePaintDevice imagePaintDevice = new ImagePaintDevice();
                    new Diagram(bean.getDataObject(), textHandler, imagePaintDevice).generate();
                    imagePaintDevice.writeToStream(fileOutputStream);
                } else {
                    Exporter exporter = Exporter.getExporter(string, string3, string2, fileOutputStream);
                    new Diagram(bean.getDataObject(), textHandler, exporter).generate();
                    exporter.export();
                }
                fileOutputStream.flush();
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    private static void configure(Bean<Configuration> bean, CommandLine commandLine) {
        for (Option option : commandLine.getOptions()) {
            if (option.getLongOpt() == null) continue;
            String string = option.getLongOpt();
            String string2 = commandLine.getOptionValue(option.getLongOpt());
            if (string2 == null) continue;
            PropertyDescriptor propertyDescriptor = bean.getProperty(string);
            Object object = ObjectFactory.createFromString(propertyDescriptor.getPropertyType(), string2);
            bean.setValue(propertyDescriptor, object);
        }
    }

    private static String availableTypes() {
        if (Exporter.isAvailable()) {
            return "{ps, pdf, swf, emf, svg, png, gif, jpg, bmp}";
        }
        return "{png}";
    }
}

