/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesCommonOptionsTab
extends WizardPanel {
    private JPanel optionsPanel;
    private JCheckBox notifyAboutBetaVersionsCheckBox;
    private JCheckBox showResultsCheckBox;
    private JCheckBox dontHideRankingsCheckBox;
    private JCheckBox appendWhenSavingResultsCheckBox;
    private JCheckBox enableReplayRecordingCheckBox;
    private JCheckBox enableAutoRecordingCheckBox;
    private final ISettingsManager properties;

    public PreferencesCommonOptionsTab(ISettingsManager properties) {
        this.properties = properties;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getOptionsPanel());
        this.loadPreferences(this.properties);
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Common"));
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            this.optionsPanel.add(this.getNotifyAboutBetaVersionsCheckBox());
            this.optionsPanel.add(new JLabel(" "));
            this.optionsPanel.add(this.getShowResultsCheckBox());
            this.optionsPanel.add(this.getDontHideRankingsCheckBox());
            this.optionsPanel.add(this.getAppendWhenSavingResultsCheckBox());
            this.optionsPanel.add(new JLabel(" "));
            this.optionsPanel.add(this.getEnableReplayRecordingCheckBox());
            this.optionsPanel.add(this.getEnableAutoRecordingCheckBox());
        }
        return this.optionsPanel;
    }

    private JCheckBox getNotifyAboutBetaVersionsCheckBox() {
        if (this.notifyAboutBetaVersionsCheckBox == null) {
            this.notifyAboutBetaVersionsCheckBox = new JCheckBox("Notify about new Beta versions of Robocode");
            this.notifyAboutBetaVersionsCheckBox.setMnemonic('B');
            this.notifyAboutBetaVersionsCheckBox.setDisplayedMnemonicIndex(17);
        }
        return this.notifyAboutBetaVersionsCheckBox;
    }

    private JCheckBox getShowResultsCheckBox() {
        if (this.showResultsCheckBox == null) {
            this.showResultsCheckBox = new JCheckBox("Show results when battle(s) ends");
            this.showResultsCheckBox.setMnemonic('h');
            this.showResultsCheckBox.setDisplayedMnemonicIndex(1);
        }
        return this.showResultsCheckBox;
    }

    private JCheckBox getDontHideRankingsCheckBox() {
        if (this.dontHideRankingsCheckBox == null) {
            this.dontHideRankingsCheckBox = new JCheckBox("Don't hide current rankings when main window is minimized");
            this.dontHideRankingsCheckBox.setMnemonic('t');
            this.dontHideRankingsCheckBox.setDisplayedMnemonicIndex(4);
        }
        return this.dontHideRankingsCheckBox;
    }

    private JCheckBox getAppendWhenSavingResultsCheckBox() {
        if (this.appendWhenSavingResultsCheckBox == null) {
            this.appendWhenSavingResultsCheckBox = new JCheckBox("Append when saving results");
            this.appendWhenSavingResultsCheckBox.setMnemonic('A');
        }
        return this.appendWhenSavingResultsCheckBox;
    }

    private JCheckBox getEnableReplayRecordingCheckBox() {
        if (this.enableReplayRecordingCheckBox == null) {
            this.enableReplayRecordingCheckBox = new JCheckBox("Enable replay recording (uses memory and disk space)");
            this.enableReplayRecordingCheckBox.setMnemonic('E');
        }
        return this.enableReplayRecordingCheckBox;
    }

    private JCheckBox getEnableAutoRecordingCheckBox() {
        if (this.enableAutoRecordingCheckBox == null) {
            this.enableAutoRecordingCheckBox = new JCheckBox("Enable auto recording (every finished battle is automatically saved into battles folder)");
            this.enableAutoRecordingCheckBox.setMnemonic('u');
            this.enableAutoRecordingCheckBox.setDisplayedMnemonicIndex(8);
            this.enableAutoRecordingCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean isSelected = PreferencesCommonOptionsTab.this.enableAutoRecordingCheckBox.isSelected();
                    PreferencesCommonOptionsTab.this.enableReplayRecordingCheckBox.setEnabled(!isSelected);
                    PreferencesCommonOptionsTab.this.enableReplayRecordingCheckBox.setSelected(isSelected || PreferencesCommonOptionsTab.this.properties.getOptionsCommonEnableReplayRecording());
                }
            });
        }
        return this.enableAutoRecordingCheckBox;
    }

    private void loadPreferences(ISettingsManager props) {
        this.getNotifyAboutBetaVersionsCheckBox().setSelected(props.getOptionsCommonNotifyAboutNewBetaVersions());
        this.getShowResultsCheckBox().setSelected(props.getOptionsCommonShowResults());
        this.getDontHideRankingsCheckBox().setSelected(props.getOptionsCommonDontHideRankings());
        this.getAppendWhenSavingResultsCheckBox().setSelected(props.getOptionsCommonAppendWhenSavingResults());
        this.getEnableReplayRecordingCheckBox().setSelected(props.getOptionsCommonEnableReplayRecording());
        this.getEnableAutoRecordingCheckBox().setSelected(props.getOptionsCommonEnableAutoRecording());
    }

    public void storePreferences() {
        ISettingsManager props = this.properties;
        props.setOptionsCommonNotifyAboutNewBetaVersions(this.getNotifyAboutBetaVersionsCheckBox().isSelected());
        props.setOptionsCommonShowResults(this.getShowResultsCheckBox().isSelected());
        props.setOptionsCommonDontHideRankings(this.getDontHideRankingsCheckBox().isSelected());
        props.setOptionsCommonAppendWhenSavingResults(this.getAppendWhenSavingResultsCheckBox().isSelected());
        props.setOptionsCommonEnableReplayRecording(this.getEnableReplayRecordingCheckBox().isSelected());
        props.setOptionsCommonEnableAutoRecording(this.getEnableAutoRecordingCheckBox().isSelected());
        this.properties.saveProperties();
    }

    @Override
    public boolean isReady() {
        return true;
    }
}

