/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.dialog.WindowUtil;

public class NewBattleRulesTab
extends JPanel {
    private static final int MIN_BATTLEFIELD_SIZE = 400;
    private static final int MAX_BATTLEFIELD_SIZE = 5000;
    private static final int BATTLEFIELD_STEP_SIZE = 100;
    private ISettingsManager settingsManager;
    private BattleProperties battleProperties;
    private final EventHandler eventHandler = new EventHandler();
    private final SizeButton[] predefinedSizeButtons = new SizeButton[]{new SizeButton(400, 400), new SizeButton(600, 400), new SizeButton(600, 600), new SizeButton(800, 600), new SizeButton(800, 800), new SizeButton(1000, 800), new SizeButton(1000, 1000), new SizeButton(1200, 1200), new SizeButton(2000, 2000), new SizeButton(5000, 5000)};
    private final JLabel numberOfRoundsLabel = new JLabel("Number of Rounds:");
    private final JLabel gunCoolingRateLabel = new JLabel("Gun Cooling Rate:");
    private final JLabel inactivityTimeLabel = new JLabel("Inactivity Time:");
    private final JLabel sentryBorderSizeLabel = new JLabel("Sentry Border Size");
    private final JLabel hideEnemyNamesLabel = new JLabel("Hide Enemy Names:");
    private final JButton restoreDefaultsButton = new JButton("Restore Defaults");
    private JTextField numberOfRoundsTextField;
    private JTextField gunCoolingRateTextField;
    private JTextField inactivityTimeTextField;
    private JTextField sentryBorderSizeTextField;
    private final JCheckBox hideEnemyNamesCheckBox = new JCheckBox();
    private JSlider battlefieldWidthSlider;
    private JSlider battlefieldHeightSlider;
    private JLabel battlefieldSizeLabel;

    public void setup(ISettingsManager settingsManager, BattleProperties battleProperties) {
        this.settingsManager = settingsManager;
        this.battleProperties = battleProperties;
        EventHandler eventHandler = new EventHandler();
        this.battlefieldWidthSlider = this.createBattlefieldSizeSlider();
        this.battlefieldWidthSlider.setOrientation(0);
        this.battlefieldHeightSlider = this.createBattlefieldSizeSlider();
        this.battlefieldHeightSlider.setOrientation(1);
        this.battlefieldHeightSlider.setInverted(true);
        this.battlefieldSizeLabel = new BattlefieldSizeLabel();
        this.battlefieldSizeLabel.setHorizontalAlignment(0);
        this.battlefieldSizeLabel.setMinimumSize(new Dimension(50, 50));
        this.battlefieldSizeLabel.setMaximumSize(new Dimension(500, 500));
        this.battlefieldWidthSlider.addChangeListener(eventHandler);
        this.battlefieldHeightSlider.addChangeListener(eventHandler);
        JPanel rulesPanel = this.createRulesPanel();
        rulesPanel.addAncestorListener(eventHandler);
        this.restoreDefaultsButton.addActionListener(eventHandler);
        this.setLayout(new BorderLayout());
        this.add((Component)rulesPanel, "West");
        this.add((Component)this.restoreDefaultsButton, "South");
        this.add((Component)this.createBattlefieldSizePanel(), "Center");
    }

    private JPanel createBattlefieldSizePanel() {
        JPanel panel = new JPanel();
        panel.addAncestorListener(this.eventHandler);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Battlefield Size"), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setBorder(border);
        panel.setLayout(new BorderLayout());
        JPanel sliderPanel = this.createBattlefieldSlidersPanel();
        panel.add((Component)sliderPanel, "Center");
        JPanel buttonsPanel = this.createPredefinedSizesPanel();
        panel.add((Component)buttonsPanel, "East");
        return panel;
    }

    private JPanel createBattlefieldSlidersPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        GroupLayout.SequentialGroup leftToRight = layout.createSequentialGroup();
        GroupLayout.ParallelGroup left = layout.createParallelGroup();
        left.addComponent(this.battlefieldSizeLabel);
        left.addComponent(this.battlefieldWidthSlider);
        leftToRight.addGroup(left);
        GroupLayout.ParallelGroup right = layout.createParallelGroup();
        right.addComponent(this.battlefieldHeightSlider);
        leftToRight.addGroup(right);
        GroupLayout.SequentialGroup topToBottom = layout.createSequentialGroup();
        GroupLayout.ParallelGroup top = layout.createParallelGroup();
        top.addComponent(this.battlefieldSizeLabel);
        top.addComponent(this.battlefieldHeightSlider);
        topToBottom.addGroup(top);
        GroupLayout.ParallelGroup bottom = layout.createParallelGroup();
        bottom.addComponent(this.battlefieldWidthSlider);
        topToBottom.addGroup(bottom);
        layout.setHorizontalGroup(leftToRight);
        layout.setVerticalGroup(topToBottom);
        return panel;
    }

    private JPanel createPredefinedSizesPanel() {
        JPanel panel = new JPanel();
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Predefined Sizes"));
        panel.setBorder(border);
        panel.setLayout(new GridLayout(this.predefinedSizeButtons.length, 1));
        for (SizeButton button : this.predefinedSizeButtons) {
            panel.add(button);
        }
        return panel;
    }

    private JPanel createRulesPanel() {
        JPanel panel = new JPanel();
        panel.addAncestorListener(new EventHandler());
        panel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        panel.setLayout(layout);
        GroupLayout.SequentialGroup leftToRight = layout.createSequentialGroup();
        GroupLayout.ParallelGroup left = layout.createParallelGroup();
        left.addComponent(this.numberOfRoundsLabel);
        left.addComponent(this.gunCoolingRateLabel);
        left.addComponent(this.inactivityTimeLabel);
        left.addComponent(this.sentryBorderSizeLabel);
        left.addComponent(this.hideEnemyNamesLabel);
        leftToRight.addGroup(left);
        GroupLayout.ParallelGroup right = layout.createParallelGroup();
        right.addComponent(this.getNumberOfRoundsTextField());
        right.addComponent(this.getGunCoolingRateTextField());
        right.addComponent(this.getInactivityTimeTextField());
        right.addComponent(this.getSentryBorderSizeTextField());
        right.addComponent(this.hideEnemyNamesCheckBox);
        leftToRight.addGroup(right);
        GroupLayout.SequentialGroup topToBottom = layout.createSequentialGroup();
        GroupLayout.ParallelGroup row0 = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        row0.addComponent(this.numberOfRoundsLabel);
        row0.addComponent(this.numberOfRoundsTextField);
        topToBottom.addGroup(row0);
        GroupLayout.ParallelGroup row1 = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        row1.addComponent(this.gunCoolingRateLabel);
        row1.addComponent(this.getGunCoolingRateTextField());
        topToBottom.addGroup(row1);
        GroupLayout.ParallelGroup row2 = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        row2.addComponent(this.inactivityTimeLabel);
        row2.addComponent(this.inactivityTimeTextField);
        topToBottom.addGroup(row2);
        GroupLayout.ParallelGroup row3 = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        row3.addComponent(this.sentryBorderSizeLabel);
        row3.addComponent(this.sentryBorderSizeTextField);
        topToBottom.addGroup(row3);
        GroupLayout.ParallelGroup row4 = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        row4.addComponent(this.hideEnemyNamesLabel);
        row4.addComponent(this.hideEnemyNamesCheckBox);
        topToBottom.addGroup(row4);
        layout.setHorizontalGroup(leftToRight);
        layout.setVerticalGroup(topToBottom);
        return panel;
    }

    private JTextField getNumberOfRoundsTextField() {
        if (this.numberOfRoundsTextField == null) {
            this.numberOfRoundsTextField = new JTextField(5);
            this.numberOfRoundsTextField.setText("" + this.battleProperties.getNumRounds());
            this.numberOfRoundsTextField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    boolean isValid = false;
                    String text = ((JTextField)input).getText();
                    if (text != null && text.matches("\\d+")) {
                        int numRounds = Integer.parseInt(text);
                        boolean bl = isValid = numRounds > 0;
                    }
                    if (!isValid) {
                        WindowUtil.messageError("'Number of Rounds' must be an integer value > 0.\nDefault value is 10.");
                        NewBattleRulesTab.this.numberOfRoundsTextField.setText("" + NewBattleRulesTab.this.battleProperties.getNumRounds());
                    }
                    return isValid;
                }
            });
        }
        return this.numberOfRoundsTextField;
    }

    private JTextField getGunCoolingRateTextField() {
        if (this.gunCoolingRateTextField == null) {
            this.gunCoolingRateTextField = new JTextField(5);
            this.gunCoolingRateTextField.setText("" + this.battleProperties.getGunCoolingRate());
            this.gunCoolingRateTextField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    boolean isValid = false;
                    String text = ((JTextField)input).getText();
                    if (text != null && text.matches("\\d*(\\.\\d+)?")) {
                        double gunCoolingRate = Double.parseDouble(text);
                        boolean bl = isValid = gunCoolingRate > 0.0 && gunCoolingRate <= 0.7;
                    }
                    if (!isValid) {
                        WindowUtil.messageError("'Gun Cooling Rate' must be a floating point number > 0 and <= 0.7.\nDefault value is 0.1.");
                        NewBattleRulesTab.this.gunCoolingRateTextField.setText("" + NewBattleRulesTab.this.battleProperties.getGunCoolingRate());
                    }
                    return isValid;
                }
            });
        }
        return this.gunCoolingRateTextField;
    }

    private JTextField getInactivityTimeTextField() {
        if (this.inactivityTimeTextField == null) {
            this.inactivityTimeTextField = new JTextField(5);
            this.inactivityTimeTextField.setText("" + this.battleProperties.getInactivityTime());
            this.inactivityTimeTextField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    boolean isValid = false;
                    String text = ((JTextField)input).getText();
                    if (text != null && text.matches("\\d+")) {
                        int inactivityTime = Integer.parseInt(text);
                        boolean bl = isValid = inactivityTime >= 0;
                    }
                    if (!isValid) {
                        WindowUtil.messageError("'Inactivity Time' must be an integer value >= 0.\nDefault value is 450.");
                        NewBattleRulesTab.this.inactivityTimeTextField.setText("" + NewBattleRulesTab.this.battleProperties.getInactivityTime());
                    }
                    return isValid;
                }
            });
        }
        return this.inactivityTimeTextField;
    }

    private JTextField getSentryBorderSizeTextField() {
        if (this.sentryBorderSizeTextField == null) {
            this.sentryBorderSizeTextField = new JTextField(5);
            this.sentryBorderSizeTextField.setText("" + this.battleProperties.getSentryBorderSize());
            this.sentryBorderSizeTextField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    boolean isValid = false;
                    String text = ((JTextField)input).getText();
                    if (text != null && text.matches("\\d+")) {
                        int borderSize = Integer.parseInt(text);
                        boolean bl = isValid = borderSize >= 50;
                    }
                    if (!isValid) {
                        WindowUtil.messageError("'Sentry Border Size' must be an integer value >= 50.\nDefault value is 100.");
                        NewBattleRulesTab.this.sentryBorderSizeTextField.setText("" + NewBattleRulesTab.this.battleProperties.getSentryBorderSize());
                    }
                    return isValid;
                }
            });
        }
        return this.sentryBorderSizeTextField;
    }

    private JSlider createBattlefieldSizeSlider() {
        JSlider slider = new JSlider();
        slider.setMinimum(400);
        slider.setMaximum(5000);
        slider.setMajorTickSpacing(100);
        slider.setSnapToTicks(true);
        slider.setPaintTicks(true);
        return slider;
    }

    private void updateBattlefieldSizeLabel() {
        int w = this.battlefieldWidthSlider.getValue();
        int h = this.battlefieldHeightSlider.getValue();
        this.battlefieldSizeLabel.setText(w + " x " + h);
    }

    private class BattlefieldSizeLabel
    extends JLabel {
        private BattlefieldSizeLabel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(SystemColor.activeCaption);
            int width = this.getWidth() * NewBattleRulesTab.this.battlefieldWidthSlider.getValue() / 5000;
            int height = this.getHeight() * NewBattleRulesTab.this.battlefieldHeightSlider.getValue() / 5000;
            g.fillRect(0, 0, width, height);
            super.paintComponent(g);
        }
    }

    private class EventHandler
    implements AncestorListener,
    ActionListener,
    ChangeListener {
        private EventHandler() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.pushBattlePropertiesToUIComponents();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            Integer sentryBorderSize;
            Integer inactivityTime;
            Double gunCoolingRate;
            Integer numberOfRounds;
            try {
                numberOfRounds = Integer.parseInt(NewBattleRulesTab.this.getNumberOfRoundsTextField().getText());
            }
            catch (NumberFormatException e) {
                numberOfRounds = null;
            }
            if (numberOfRounds != null) {
                NewBattleRulesTab.this.settingsManager.setBattleDefaultNumberOfRounds(numberOfRounds.intValue());
                NewBattleRulesTab.this.battleProperties.setNumRounds(numberOfRounds.intValue());
            }
            try {
                gunCoolingRate = Double.parseDouble(NewBattleRulesTab.this.getGunCoolingRateTextField().getText());
            }
            catch (NumberFormatException e) {
                gunCoolingRate = null;
            }
            if (gunCoolingRate != null) {
                NewBattleRulesTab.this.settingsManager.setBattleDefaultGunCoolingRate(gunCoolingRate.doubleValue());
                NewBattleRulesTab.this.battleProperties.setGunCoolingRate(gunCoolingRate.doubleValue());
            }
            try {
                inactivityTime = Integer.parseInt(NewBattleRulesTab.this.getInactivityTimeTextField().getText());
            }
            catch (NumberFormatException e) {
                inactivityTime = null;
            }
            if (inactivityTime != null) {
                NewBattleRulesTab.this.settingsManager.setBattleDefaultInactivityTime((long)inactivityTime.intValue());
                NewBattleRulesTab.this.battleProperties.setInactivityTime((long)inactivityTime.intValue());
            }
            try {
                sentryBorderSize = Integer.parseInt(NewBattleRulesTab.this.getSentryBorderSizeTextField().getText());
            }
            catch (NumberFormatException e) {
                sentryBorderSize = null;
            }
            if (sentryBorderSize != null) {
                NewBattleRulesTab.this.settingsManager.setBattleDefaultSentryBorderSize(sentryBorderSize.intValue());
                NewBattleRulesTab.this.battleProperties.setSentryBorderSize(sentryBorderSize.intValue());
            }
            boolean hideEnemyNames = NewBattleRulesTab.this.hideEnemyNamesCheckBox.isSelected();
            NewBattleRulesTab.this.settingsManager.setBattleDefaultHideEnemyNames(hideEnemyNames);
            NewBattleRulesTab.this.battleProperties.setHideEnemyNames(hideEnemyNames);
            int weight = NewBattleRulesTab.this.battlefieldWidthSlider.getValue();
            int height = NewBattleRulesTab.this.battlefieldHeightSlider.getValue();
            NewBattleRulesTab.this.settingsManager.setBattleDefaultBattlefieldWidth(weight);
            NewBattleRulesTab.this.settingsManager.setBattleDefaultBattlefieldHeight(height);
            NewBattleRulesTab.this.battleProperties.setBattlefieldWidth(weight);
            NewBattleRulesTab.this.battleProperties.setBattlefieldHeight(height);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() instanceof SizeButton) {
                SizeButton button = (SizeButton)event.getSource();
                NewBattleRulesTab.this.battlefieldWidthSlider.setValue(button.width);
                NewBattleRulesTab.this.battlefieldHeightSlider.setValue(button.height);
                NewBattleRulesTab.this.updateBattlefieldSizeLabel();
            } else if (event.getSource() == NewBattleRulesTab.this.restoreDefaultsButton) {
                NewBattleRulesTab.this.battleProperties.setBattlefieldWidth(800);
                NewBattleRulesTab.this.battleProperties.setBattlefieldHeight(600);
                NewBattleRulesTab.this.battleProperties.setNumRounds(10);
                NewBattleRulesTab.this.battleProperties.setGunCoolingRate(0.1);
                NewBattleRulesTab.this.battleProperties.setInactivityTime(450L);
                NewBattleRulesTab.this.battleProperties.setHideEnemyNames(false);
                NewBattleRulesTab.this.battleProperties.setSentryBorderSize(100);
                this.pushBattlePropertiesToUIComponents();
            }
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (event.getSource() == NewBattleRulesTab.this.battlefieldWidthSlider || event.getSource() == NewBattleRulesTab.this.battlefieldHeightSlider) {
                NewBattleRulesTab.this.updateBattlefieldSizeLabel();
            }
        }

        private void pushBattlePropertiesToUIComponents() {
            NewBattleRulesTab.this.battlefieldWidthSlider.setValue(NewBattleRulesTab.this.battleProperties.getBattlefieldWidth());
            NewBattleRulesTab.this.battlefieldHeightSlider.setValue(NewBattleRulesTab.this.battleProperties.getBattlefieldHeight());
            NewBattleRulesTab.this.updateBattlefieldSizeLabel();
            NewBattleRulesTab.this.getNumberOfRoundsTextField().setText("" + NewBattleRulesTab.this.battleProperties.getNumRounds());
            NewBattleRulesTab.this.getGunCoolingRateTextField().setText("" + NewBattleRulesTab.this.battleProperties.getGunCoolingRate());
            NewBattleRulesTab.this.getInactivityTimeTextField().setText("" + NewBattleRulesTab.this.battleProperties.getInactivityTime());
            NewBattleRulesTab.this.getSentryBorderSizeTextField().setText("" + NewBattleRulesTab.this.battleProperties.getSentryBorderSize());
            NewBattleRulesTab.this.hideEnemyNamesCheckBox.setSelected(NewBattleRulesTab.this.battleProperties.getHideEnemyNames());
        }
    }

    private class SizeButton
    extends JButton {
        final int width;
        final int height;

        public SizeButton(int width, int height) {
            super(width + "x" + height);
            this.width = width;
            this.height = height;
            this.addActionListener(NewBattleRulesTab.this.eventHandler);
        }
    }
}

