/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.battleview;

import java.awt.KeyEventDispatcher;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.security.SafeComponent;
import net.sf.robocode.ui.battleview.BattleView;
import robocode.Event;
import robocode.KeyPressedEvent;
import robocode.KeyReleasedEvent;
import robocode.KeyTypedEvent;
import robocode.MouseClickedEvent;
import robocode.MouseDraggedEvent;
import robocode.MouseEnteredEvent;
import robocode.MouseExitedEvent;
import robocode.MouseMovedEvent;
import robocode.MousePressedEvent;
import robocode.MouseReleasedEvent;
import robocode.MouseWheelMovedEvent;

public final class InteractiveHandler
implements KeyEventDispatcher,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final IBattleManager battleManager;
    private final BattleView battleView;

    public InteractiveHandler(IBattleManager battleManager, BattleView battleView) {
        this.battleManager = battleManager;
        this.battleView = battleView;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        switch (e.getID()) {
            case 400: {
                this.handleInteractiveEvent((Event)new KeyTypedEvent(InteractiveHandler.cloneKeyEvent(e)));
                break;
            }
            case 401: {
                this.handleInteractiveEvent((Event)new KeyPressedEvent(InteractiveHandler.cloneKeyEvent(e)));
                break;
            }
            case 402: {
                this.handleInteractiveEvent((Event)new KeyReleasedEvent(InteractiveHandler.cloneKeyEvent(e)));
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handleInteractiveEvent((Event)new MouseClickedEvent(this.mirroredMouseEvent(e)));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.handleInteractiveEvent((Event)new MouseEnteredEvent(this.mirroredMouseEvent(e)));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.handleInteractiveEvent((Event)new MouseExitedEvent(this.mirroredMouseEvent(e)));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleInteractiveEvent((Event)new MousePressedEvent(this.mirroredMouseEvent(e)));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleInteractiveEvent((Event)new MouseReleasedEvent(this.mirroredMouseEvent(e)));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.handleInteractiveEvent((Event)new MouseMovedEvent(this.mirroredMouseEvent(e)));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleInteractiveEvent((Event)new MouseDraggedEvent(this.mirroredMouseEvent(e)));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.handleInteractiveEvent((Event)new MouseWheelMovedEvent((MouseEvent)this.mirroredMouseWheelEvent(e)));
    }

    public static KeyEvent cloneKeyEvent(KeyEvent e) {
        return new KeyEvent(SafeComponent.getSafeEventComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
    }

    private void handleInteractiveEvent(Event event) {
        this.battleManager.sendInteractiveEvent(event);
    }

    private MouseEvent mirroredMouseEvent(MouseEvent e) {
        BattleProperties battleProps = this.battleManager.getBattleProperties();
        int vWidth = this.battleView.getWidth();
        int vHeight = this.battleView.getHeight();
        int fWidth = battleProps.getBattlefieldWidth();
        int fHeight = battleProps.getBattlefieldHeight();
        double scale = vWidth < fWidth || vHeight < fHeight ? Math.min((double)vWidth / (double)fWidth, (double)vHeight / (double)fHeight) : 1.0;
        double dx = ((double)vWidth - scale * (double)fWidth) / 2.0;
        double dy = ((double)vHeight - scale * (double)fHeight) / 2.0;
        int x = (int)(((double)e.getX() - dx) / scale + 0.5);
        int y = (int)((double)fHeight - ((double)e.getY() - dy) / scale + 0.5);
        return new MouseEvent(SafeComponent.getSafeEventComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    private MouseWheelEvent mirroredMouseWheelEvent(MouseWheelEvent e) {
        BattleProperties battleProps = this.battleManager.getBattleProperties();
        int vWidth = this.battleView.getWidth();
        int vHeight = this.battleView.getHeight();
        int fWidth = battleProps.getBattlefieldWidth();
        int fHeight = battleProps.getBattlefieldHeight();
        double scale = vWidth < fWidth || vHeight < fHeight ? Math.min((double)vWidth / (double)fWidth, (double)vHeight / (double)fHeight) : 1.0;
        double dx = ((double)vWidth - scale * (double)fWidth) / 2.0;
        double dy = ((double)vHeight - scale * (double)fHeight) / 2.0;
        int x = (int)(((double)e.getX() - dx) / scale + 0.5);
        int y = (int)((double)fHeight - ((double)e.getY() - dy) / scale + 0.5);
        return new MouseWheelEvent(SafeComponent.getSafeEventComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
    }
}

