/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import net.sf.robocode.ui.CheckListItem;
import net.sf.robocode.ui.CheckListRenderer;

public class CheckList
extends JList {
    private DefaultListModel model;

    public CheckList() {
        this.initialize();
    }

    private void initialize() {
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.setCellRenderer(new CheckListRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                if (index >= 0 && event.getClickCount() == 2) {
                    CheckListItem item;
                    item.setSelected(!(item = (CheckListItem)CheckList.this.model.getElementAt(index)).isSelected());
                    list.repaint(list.getCellBounds(index, index));
                }
            }
        });
    }

    public void clear() {
        this.model.clear();
    }

    public int getLength() {
        return this.model.getSize();
    }

    public String get(int index) {
        return this.model.getElementAt(index).toString();
    }

    public void add(String label) {
        this.model.addElement(new CheckListItem(label));
    }

    @Override
    public void remove(int index) {
        this.model.remove(index);
    }

    public boolean contains(String label) {
        if (label == null) {
            return false;
        }
        for (int i = 0; i < this.model.getSize(); ++i) {
            CheckListItem item = (CheckListItem)this.model.getElementAt(i);
            if (!label.equals(item.toString())) continue;
            return true;
        }
        return false;
    }

    public void sort() {
        int size = this.model.getSize();
        if (size > 0) {
            Object[] items = new CheckListItem[size];
            this.model.copyInto(items);
            Arrays.sort(items);
            for (int i = 0; i < items.length; ++i) {
                this.model.setElementAt(items[i], i);
            }
        }
    }

    public void setChecked(String label, boolean isChecked) {
        if (label != null) {
            for (int i = 0; i < this.model.getSize(); ++i) {
                CheckListItem item = (CheckListItem)this.model.getElementAt(i);
                if (!label.equals(item.toString())) continue;
                item.setSelected(isChecked);
                break;
            }
        }
    }

    public Collection<String> getUnchecked() {
        HashSet<String> unchecked = new HashSet<String>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            CheckListItem item = (CheckListItem)this.model.getElementAt(i);
            if (item.isSelected()) continue;
            unchecked.add(item.toString());
        }
        return unchecked;
    }

    public Collection<String> getAll() {
        HashSet<String> all = new HashSet<String>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            CheckListItem item = (CheckListItem)this.model.getElementAt(i);
            all.add(item.toString());
        }
        return all;
    }
}

