/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.packager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.repository.RobotProperties;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.ConsoleDialog;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.dialog.WizardCardPanel;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.packager.ConfirmPanel;
import net.sf.robocode.ui.packager.FilenamePanel;
import net.sf.robocode.ui.packager.PackagerOptionsPanel;
import net.sf.robocode.ui.util.ShortcutUtil;

public class RobotPackager
extends JDialog
implements WizardListener {
    private final int minRobots = 1;
    private final int maxRobots = 1;
    private JPanel robotPackagerContentPane;
    private WizardCardPanel wizardPanel;
    private WizardController buttonsPanel;
    private FilenamePanel filenamePanel;
    private ConfirmPanel confirmPanel;
    private RobotSelectionPanel robotSelectionPanel;
    private PackagerOptionsPanel packagerOptionsPanel;
    private final IRepositoryManager repositoryManager;
    private final IWindowManager windowManager;
    private final EventHandler eventHandler = new EventHandler();

    public RobotPackager(IRepositoryManager repositoryManager, IWindowManager windowManager) {
        super(windowManager.getRobocodeFrame());
        this.repositoryManager = repositoryManager;
        this.windowManager = windowManager;
        this.initialize();
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    private WizardController getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = this.getWizardPanel().getWizardController();
        }
        return this.buttonsPanel;
    }

    private ConfirmPanel getConfirmPanel() {
        if (this.confirmPanel == null) {
            this.confirmPanel = new ConfirmPanel(this);
        }
        return this.confirmPanel;
    }

    protected FilenamePanel getFilenamePanel() {
        if (this.filenamePanel == null) {
            this.filenamePanel = new FilenamePanel(this);
        }
        return this.filenamePanel;
    }

    protected PackagerOptionsPanel getPackagerOptionsPanel() {
        if (this.packagerOptionsPanel == null) {
            this.packagerOptionsPanel = new PackagerOptionsPanel(this);
        }
        return this.packagerOptionsPanel;
    }

    private JPanel getRobotPackagerContentPane() {
        if (this.robotPackagerContentPane == null) {
            this.robotPackagerContentPane = new JPanel();
            this.robotPackagerContentPane.setLayout(new BorderLayout());
            this.robotPackagerContentPane.add((Component)this.getButtonsPanel(), "South");
            this.robotPackagerContentPane.add((Component)this.getWizardPanel(), "Center");
            this.getWizardPanel().getWizardController().setFinishButtonTextAndMnemonic("Package!", 'P', 0);
            this.robotPackagerContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 1);
            this.robotPackagerContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 0);
        }
        return this.robotPackagerContentPane;
    }

    public RobotSelectionPanel getRobotSelectionPanel() {
        if (this.robotSelectionPanel == null) {
            this.robotSelectionPanel = (RobotSelectionPanel)Container.createComponent(RobotSelectionPanel.class);
            this.robotSelectionPanel.setup(1, 1, false, "Select the robot or team you would like to package.", false, false, false, true, false, true, null);
        }
        return this.robotSelectionPanel;
    }

    private WizardCardPanel getWizardPanel() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new WizardCardPanel(this);
            this.wizardPanel.add((Component)this.getRobotSelectionPanel(), "Select robot");
            this.wizardPanel.add((Component)this.getPackagerOptionsPanel(), "Select options");
            this.wizardPanel.add((Component)this.getFilenamePanel(), "Select filename");
            this.wizardPanel.add((Component)this.getConfirmPanel(), "Confirm");
        }
        return this.wizardPanel;
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Robot Packager");
        this.setContentPane(this.getRobotPackagerContentPane());
    }

    @Override
    public void finishButtonActionPerformed() {
        String jarFilename = this.getFilenamePanel().getFilenameField().getText();
        File jarFile = new File(jarFilename);
        if (jarFile.exists()) {
            int ok = JOptionPane.showConfirmDialog(this, jarFilename + " already exists.  Are you sure you want to replace it?", "Warning", 1);
            if (ok == 1 || ok == 2) {
                Logger.logMessage((String)"Cancelled by user.");
                return;
            }
            Logger.logMessage((String)("Overwriting " + jarFilename));
        }
        String webPageFieldString = this.getPackagerOptionsPanel().getWebpageField().getText();
        URL webPage = null;
        if (webPageFieldString.length() > 0) {
            try {
                webPage = new URL(webPageFieldString);
            }
            catch (MalformedURLException e) {
                try {
                    webPage = new URL("http://" + webPageFieldString);
                    this.getPackagerOptionsPanel().getWebpageField().setText(webPage.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        boolean includeSource = this.getPackagerOptionsPanel().getIncludeSource().isSelected();
        boolean includeData = this.getPackagerOptionsPanel().getIncludeData().isSelected();
        String version = this.getPackagerOptionsPanel().getVersionField().getText();
        String author = this.getPackagerOptionsPanel().getAuthorField().getText();
        String desc = this.getPackagerOptionsPanel().getDescriptionArea().getText();
        List<IRobotSpecItem> robots = this.getRobotSelectionPanel().getSelectedRobots();
        RobotProperties props = new RobotProperties();
        props.setIncludeSource(includeSource);
        props.setIncludeData(includeData);
        props.setVersion(version);
        props.setAuthor(author);
        props.setDescription(desc);
        props.setWebPage(webPage);
        String outputText = this.repositoryManager.createPackage(jarFile, robots, props);
        ConsoleDialog dialog = new ConsoleDialog(this.windowManager.getRobocodeFrame(), "Packaging results", false);
        dialog.setText(outputText);
        dialog.pack();
        WindowUtil.packCenterShow(this, dialog);
        this.dispose();
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Refresh")) {
                RobotPackager.this.getRobotSelectionPanel().refreshRobotList(true);
            }
        }
    }
}

