/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.ui.dialog.TeamCreator;
import net.sf.robocode.ui.dialog.WizardPanel;
import net.sf.robocode.ui.packager.RobotPackager;
import net.sf.robocode.ui.util.LimitedClassnameDocument;
import net.sf.robocode.ui.util.LimitedDocument;

public class TeamCreatorOptionsPanel
extends WizardPanel {
    private TeamCreator teamCreator;
    private RobotPackager teamPackager;
    private final EventHandler eventHandler = new EventHandler();
    private JLabel authorLabel;
    private JTextField authorField;
    private JLabel descriptionLabel;
    private JTextArea descriptionArea;
    private JLabel versionLabel;
    private JTextField versionField;
    private JLabel webpageLabel;
    private JTextField webpageField;
    private JLabel webpageHelpLabel;
    private JLabel teamNameLabel;
    private JLabel teamPackageLabel;
    private JTextField teamNameField;
    private String teamPackage;
    public JPanel robotListPanel;

    public TeamCreatorOptionsPanel(TeamCreator teamCreator) {
        this.teamCreator = teamCreator;
        this.initialize();
    }

    public TeamCreatorOptionsPanel(RobotPackager teamPackager) {
        this.teamPackager = teamPackager;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.getTeamNameLabel().setAlignmentX(0.0f);
        this.add(this.getTeamNameLabel());
        JPanel teamNamePanel = new JPanel();
        teamNamePanel.setLayout(new FlowLayout(0, 0, 0));
        teamNamePanel.setAlignmentX(0.0f);
        this.getTeamNameField().setAlignmentX(0.0f);
        this.getTeamNameField().setMaximumSize(this.getTeamNameField().getPreferredSize());
        teamNamePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getTeamNameField().getPreferredSize().height));
        teamNamePanel.add(this.getTeamPackageLabel());
        teamNamePanel.add(this.getTeamNameField());
        this.add(teamNamePanel);
        JLabel label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getVersionLabel());
        JPanel versionPanel = new JPanel();
        versionPanel.setLayout(new FlowLayout(0, 0, 0));
        versionPanel.setAlignmentX(0.0f);
        this.getVersionField().setAlignmentX(0.0f);
        this.getVersionField().setMaximumSize(this.getVersionField().getPreferredSize());
        versionPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getVersionField().getPreferredSize().height));
        versionPanel.add(this.getVersionField());
        this.add(versionPanel);
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getDescriptionLabel());
        JScrollPane scrollPane = new JScrollPane(this.getDescriptionArea(), 21, 32);
        scrollPane.setMaximumSize(scrollPane.getPreferredSize());
        scrollPane.setMinimumSize(new Dimension(100, scrollPane.getPreferredSize().height));
        scrollPane.setAlignmentX(0.0f);
        this.add(scrollPane);
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getAuthorLabel());
        this.getAuthorField().setAlignmentX(0.0f);
        this.getAuthorField().setMaximumSize(this.getAuthorField().getPreferredSize());
        this.add(this.getAuthorField());
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getWebpageLabel());
        this.getWebpageField().setAlignmentX(0.0f);
        this.getWebpageField().setMaximumSize(this.getWebpageField().getPreferredSize());
        this.add(this.getWebpageField());
        this.getWebpageHelpLabel().setAlignmentX(0.0f);
        this.add(this.getWebpageHelpLabel());
        JPanel panel = new JPanel();
        panel.setAlignmentX(0.0f);
        this.add(panel);
        this.addComponentListener(this.eventHandler);
    }

    @Override
    public boolean isReady() {
        return this.getTeamNameField().getText().length() != 0 && this.getDescriptionArea().getText().length() != 0;
    }

    private JLabel getAuthorLabel() {
        if (this.authorLabel == null) {
            this.authorLabel = new JLabel("Please enter your name. (optional)");
            this.authorLabel.setAlignmentX(0.0f);
        }
        return this.authorLabel;
    }

    public JTextField getAuthorField() {
        if (this.authorField == null) {
            this.authorField = new JTextField(40);
        }
        return this.authorField;
    }

    public JLabel getDescriptionLabel() {
        if (this.descriptionLabel == null) {
            this.descriptionLabel = new JLabel("");
            this.descriptionLabel.setAlignmentX(0.0f);
        }
        return this.descriptionLabel;
    }

    public JTextArea getDescriptionArea() {
        if (this.descriptionArea == null) {
            LimitedDocument doc = new LimitedDocument(3, 72);
            this.descriptionArea = new JTextArea(doc, null, 3, 72);
            doc.addDocumentListener(this.eventHandler);
        }
        return this.descriptionArea;
    }

    private JLabel getVersionLabel() {
        if (this.versionLabel == null) {
            this.versionLabel = new JLabel("Please enter a version number for this robot (up to 10 word chars: letters, digits, dots, but no spaces).");
            this.versionLabel.setAlignmentX(0.0f);
        }
        return this.versionLabel;
    }

    public JTextField getVersionField() {
        if (this.versionField == null) {
            LimitedDocument doc = new LimitedDocument(1, 10);
            this.versionField = new JTextField(doc, null, 10);
            doc.addDocumentListener(this.eventHandler);
        }
        return this.versionField;
    }

    public JLabel getWebpageLabel() {
        if (this.webpageLabel == null) {
            this.webpageLabel = new JLabel("Please enter a URL for your team's webpage (optional)");
            this.webpageLabel.setAlignmentX(0.0f);
        }
        return this.webpageLabel;
    }

    public JTextField getWebpageField() {
        if (this.webpageField == null) {
            this.webpageField = new JTextField(40);
        }
        return this.webpageField;
    }

    public JLabel getWebpageHelpLabel() {
        if (this.webpageHelpLabel == null) {
            this.webpageHelpLabel = new JLabel("");
        }
        return this.webpageHelpLabel;
    }

    public JTextField getTeamNameField() {
        if (this.teamNameField == null) {
            LimitedClassnameDocument doc = new LimitedClassnameDocument(1, 32);
            this.teamNameField = new JTextField(doc, null, 32);
            doc.addDocumentListener(this.eventHandler);
        }
        return this.teamNameField;
    }

    public JLabel getTeamNameLabel() {
        if (this.teamNameLabel == null) {
            this.teamNameLabel = new JLabel("");
        }
        return this.teamNameLabel;
    }

    public JLabel getTeamPackageLabel() {
        if (this.teamPackageLabel == null) {
            this.teamPackageLabel = new JLabel("");
        }
        return this.teamPackageLabel;
    }

    public String getTeamPackage() {
        return this.teamPackage != null ? this.teamPackage : ".";
    }

    private class EventHandler
    implements ComponentListener,
    DocumentListener {
        private EventHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TeamCreatorOptionsPanel.this.fireStateChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TeamCreatorOptionsPanel.this.fireStateChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TeamCreatorOptionsPanel.this.fireStateChanged();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            List<IRobotSpecItem> selectedRobots = TeamCreatorOptionsPanel.this.teamCreator != null ? TeamCreatorOptionsPanel.this.teamCreator.getRobotSelectionPanel().getSelectedRobots() : TeamCreatorOptionsPanel.this.teamPackager.getRobotSelectionPanel().getSelectedRobots();
            if (selectedRobots != null) {
                String d;
                IRobotSpecItem robotSpecification = selectedRobots.get(0);
                TeamCreatorOptionsPanel.this.getTeamNameLabel().setText("Please choose a name for your team: (Must be a valid Java classname)");
                TeamCreatorOptionsPanel.this.getTeamNameField().setText(robotSpecification.getShortClassName() + "Team");
                TeamCreatorOptionsPanel.this.getTeamPackageLabel().setText(robotSpecification.getFullPackage() + ".");
                TeamCreatorOptionsPanel.this.teamPackage = robotSpecification.getFullPackage();
                if (TeamCreatorOptionsPanel.this.teamPackage != null) {
                    TeamCreatorOptionsPanel.this.teamPackage = TeamCreatorOptionsPanel.this.teamPackage + ".";
                }
                if ((d = robotSpecification.getDescription()) == null) {
                    d = "";
                }
                TeamCreatorOptionsPanel.this.getDescriptionArea().setText(d);
                String a = robotSpecification.getAuthorName();
                if (a == null) {
                    a = "";
                }
                TeamCreatorOptionsPanel.this.getAuthorField().setText(a);
                URL u = robotSpecification.getWebpage();
                if (u == null) {
                    TeamCreatorOptionsPanel.this.getWebpageField().setText("");
                } else {
                    TeamCreatorOptionsPanel.this.getWebpageField().setText(u.toString());
                }
                TeamCreatorOptionsPanel.this.getVersionLabel().setVisible(true);
                TeamCreatorOptionsPanel.this.getVersionField().setVisible(true);
                TeamCreatorOptionsPanel.this.getAuthorLabel().setVisible(true);
                TeamCreatorOptionsPanel.this.getAuthorField().setVisible(true);
                TeamCreatorOptionsPanel.this.getWebpageLabel().setVisible(true);
                TeamCreatorOptionsPanel.this.getWebpageField().setVisible(true);
                TeamCreatorOptionsPanel.this.getWebpageHelpLabel().setVisible(true);
                TeamCreatorOptionsPanel.this.getDescriptionLabel().setText("Please enter a short description of this team (up to 3 lines of 72 chars each).");
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }
    }
}

