/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.packager;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.ui.dialog.WizardPanel;
import net.sf.robocode.ui.packager.RobotPackager;

public class ConfirmPanel
extends WizardPanel {
    private final RobotPackager robotPackager;
    private final EventHandler eventHandler = new EventHandler();
    private boolean visible;
    private JPanel robotListPanel;

    public ConfirmPanel(RobotPackager robotPackager) {
        this.robotPackager = robotPackager;
        this.initialize();
    }

    public JPanel getRobotListPanel() {
        if (this.robotListPanel == null) {
            this.robotListPanel = new JPanel();
            this.robotListPanel.setLayout(new BoxLayout(this.robotListPanel, 1));
            this.robotListPanel.setAlignmentX(0.0f);
        }
        return this.robotListPanel;
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.addComponentListener(this.eventHandler);
        this.add(new JPanel());
    }

    @Override
    public boolean isReady() {
        return this.visible;
    }

    public void setSelectedRobots(List<IRobotSpecItem> selectedRobots) {
        this.getRobotListPanel().removeAll();
        if (selectedRobots == null || selectedRobots.size() == 0) {
            this.getRobotListPanel().add(new JLabel("You have not yet selected any robots."));
        } else if (selectedRobots.size() == 1) {
            String robotName = selectedRobots.get(0).getFullClassName();
            this.getRobotListPanel().add(new JLabel("You have selected " + robotName + " for packaging."));
        } else {
            this.getRobotListPanel().add(new JLabel("You have selected the following robots for packaging:"));
            for (IRobotSpecItem selected : selectedRobots) {
                this.getRobotListPanel().add(new JLabel(selected.getFullClassName()));
            }
        }
        this.getRobotListPanel().add(new JLabel(""));
        this.getRobotListPanel().setMaximumSize(new Dimension(10000, this.robotListPanel.getPreferredSize().height));
        this.validate();
    }

    public void updateFields() {
        this.removeAll();
        this.setSelectedRobots(this.robotPackager.getRobotSelectionPanel().getSelectedRobots());
        this.add(this.getRobotListPanel());
        this.add(Box.createVerticalStrut(20));
        if (this.robotPackager.getPackagerOptionsPanel().getIncludeSource().isSelected()) {
            this.add(new JLabel("Java source files will be included."));
        } else {
            this.add(new JLabel("Java source files will NOT be included."));
        }
        if (this.robotPackager.getPackagerOptionsPanel().getIncludeData().isSelected()) {
            this.add(new JLabel("Data files will be included, if they exists."));
        } else {
            this.add(new JLabel("Data source files will NOT be included."));
        }
        this.add(Box.createVerticalStrut(20));
        this.add(new JLabel("The package will be saved in: " + this.robotPackager.getFilenamePanel().getFilenameField().getText()));
        this.add(Box.createVerticalStrut(20));
        this.add(new JLabel("If all of the above is correct, click the Package button to start packaging."));
        this.add(new JPanel());
        this.revalidate();
    }

    private class EventHandler
    implements ComponentListener {
        private EventHandler() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ConfirmPanel.this.visible = false;
            ConfirmPanel.this.fireStateChanged();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (ConfirmPanel.this.robotPackager != null) {
                ConfirmPanel.this.visible = true;
                ConfirmPanel.this.updateFields();
                ConfirmPanel.this.fireStateChanged();
                ConfirmPanel.this.repaint();
            }
        }
    }
}

