/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.gfx;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import net.sf.robocode.ui.gfx.RenderObject;

public class RenderImage
extends RenderObject {
    protected final Image image;
    protected final Area boundArea;

    public RenderImage(Image image) {
        this(image, (double)image.getWidth(null) / 2.0, (double)image.getHeight(null) / 2.0);
    }

    public RenderImage(Image image, double originX, double originY) {
        this.image = image;
        this.baseTransform = AffineTransform.getTranslateInstance(-originX, -originY);
        this.boundArea = new Area(new Rectangle(0, 0, image.getWidth(null), image.getHeight(null)));
    }

    public RenderImage(RenderImage ri) {
        super(ri);
        this.image = ri.image;
        this.boundArea = new Area(ri.boundArea);
    }

    @Override
    public void paint(Graphics2D g) {
        g.drawImage(this.image, this.transform, null);
    }

    @Override
    public Rectangle getBounds() {
        return this.boundArea.createTransformedArea(this.transform).getBounds();
    }

    @Override
    public RenderObject copy() {
        return new RenderImage(this);
    }
}

